/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolJob;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.RCABatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class JUnitRCABatchTestClassGroup
extends RCABatchTestClassGroup {
    private final List<PathMatcher> _pathMatchers = new ArrayList<PathMatcher>();

    protected JUnitRCABatchTestClassGroup(JSONObject jsonObject, RootCauseAnalysisToolJob rootCauseAnalysisToolJob) {
        super(jsonObject, rootCauseAnalysisToolJob);
    }

    protected JUnitRCABatchTestClassGroup(String batchName, RootCauseAnalysisToolJob rootCauseAnalysisToolJob) {
        super(batchName, rootCauseAnalysisToolJob);
        this._setPathMatchers();
        this._setTestClasses();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    @Override
    protected void setAxisTestClassGroups() {
        int axisCount = this.getAxisCount();
        if (axisCount == 0) {
            return;
        }
        int testClassCount = this.testClasses.size();
        if (testClassCount == 0) {
            this.axisTestClassGroups.add(0, TestClassGroupFactory.newAxisTestClassGroup(this));
            return;
        }
        int axisSize = (int)Math.ceil((double)testClassCount / (double)axisCount);
        for (List axisTestClasses : Lists.partition((List)this.testClasses, (int)axisSize)) {
            AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this);
            for (TestClass axisTestClass : axisTestClasses) {
                axisTestClassGroup.addTestClass(axisTestClass);
            }
            this.axisTestClassGroups.add(axisTestClassGroup);
        }
    }

    private void _setPathMatchers() {
        ArrayList includeGlobs = new ArrayList();
        String portalBatchTestSelector = System.getenv("PORTAL_BATCH_TEST_SELECTOR");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            portalBatchTestSelector = this.getBuildStartProperty("PORTAL_BATCH_TEST_SELECTOR");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBatchTestSelector)) {
            Collections.addAll(includeGlobs, JenkinsResultsParserUtil.getGlobsFromProperty(portalBatchTestSelector));
        }
        this._pathMatchers.addAll(JenkinsResultsParserUtil.toPathMatchers(JenkinsResultsParserUtil.combine(JenkinsResultsParserUtil.getCanonicalPath(this.portalGitWorkingDirectory.getWorkingDirectory()), File.separator), includeGlobs.toArray(new String[0])));
    }

    private void _setTestClasses() {
        final JUnitRCABatchTestClassGroup batchTestClassGroup = this;
        File portalWorkingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
        try {
            Files.walkFileTree(portalWorkingDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    if (JenkinsResultsParserUtil.isFileExcluded(new ArrayList<PathMatcher>(), filePath.toFile())) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                    TestClass testClass;
                    List<TestClassMethod> testClassMethods;
                    if (JenkinsResultsParserUtil.isFileIncluded(new ArrayList<PathMatcher>(), (List<PathMatcher>)JUnitRCABatchTestClassGroup.this._pathMatchers, filePath.toFile()) && !(testClassMethods = (testClass = this._getPackagePathClassFile(filePath)).getTestClassMethods()).isEmpty()) {
                        JUnitRCABatchTestClassGroup.this.testClasses.add(testClass);
                    }
                    return FileVisitResult.CONTINUE;
                }

                private TestClass _getPackagePathClassFile(Path path) {
                    return TestClassFactory.newTestClass(batchTestClassGroup, path.toFile());
                }
            });
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to search for test file names in " + portalWorkingDirectory.getPath(), ioException);
        }
        Collections.sort(this.testClasses);
    }
}

