/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.AntException;
import com.liferay.jenkins.results.parser.AntUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.util.PropsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class FunctionalBatchTestClassGroup
extends BatchTestClassGroup {
    private static final Pattern _poshiTestCasePattern = Pattern.compile("(?<namespace>[^\\.]+)\\.(?<className>[^\\#]+)\\#(?<methodName>.*)");
    private final Map<File, String> _testBatchRunPropertyQueries = new HashMap<File, String>();

    @Override
    public int getAxisCount() {
        return this.axisTestClassGroups.size();
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.getTestBatchRunPropertyQuery());
        sb.append(") AND (ignored == null)");
        String testRunEnvironment = PropsUtil.get((String)"test.run.environment");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testRunEnvironment)) {
            sb.append(" AND (test.run.environment == \"");
            sb.append(testRunEnvironment);
            sb.append("\" OR test.run.environment == null)");
        }
        this.jsonObject.put("pql_query", (Object)sb.toString());
        this.jsonObject.put("test_batch_run_property_queries", this._testBatchRunPropertyQueries);
        return this.jsonObject;
    }

    public List<File> getTestBaseDirs() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return Arrays.asList(new File(portalGitWorkingDirectory.getWorkingDirectory(), "portal-web/test/functional/portalweb"));
    }

    public String getTestBatchRunPropertyQuery() {
        List<File> testBaseDirs = this.getTestBaseDirs();
        if (testBaseDirs.isEmpty()) {
            return null;
        }
        return this.getTestBatchRunPropertyQuery(testBaseDirs.get(0));
    }

    public String getTestBatchRunPropertyQuery(File testBaseDir) {
        return this._testBatchRunPropertyQueries.get(testBaseDir);
    }

    @Override
    public List<TestClass> getTestClasses() {
        ArrayList<TestClass> testClasses = new ArrayList<TestClass>();
        for (AxisTestClassGroup axisTestClassGroup : this.axisTestClassGroups) {
            testClasses.addAll(axisTestClassGroup.getTestClasses());
        }
        return testClasses;
    }

    protected FunctionalBatchTestClassGroup(JSONObject jsonObject, PortalTestClassJob portalTestClassJob) {
        super(jsonObject, portalTestClassJob);
        JSONObject testBatchRunPropertyQueriesJSONObject = jsonObject.optJSONObject("test_batch_run_property_queries");
        if (testBatchRunPropertyQueriesJSONObject == null) {
            return;
        }
        for (String key : testBatchRunPropertyQueriesJSONObject.keySet()) {
            this._testBatchRunPropertyQueries.put(new File(key), testBatchRunPropertyQueriesJSONObject.getString(key));
        }
    }

    protected FunctionalBatchTestClassGroup(String batchName, PortalTestClassJob portalTestClassJob) {
        super(batchName, portalTestClassJob);
        this._setTestBatchRunPropertyQueries();
        this.setAxisTestClassGroups();
        this.setSegmentTestClassGroups();
    }

    protected String getDefaultTestBatchRunPropertyQuery(File testBaseDir, String testSuiteName) {
        String query = System.getenv("TEST_BATCH_RUN_PROPERTY_QUERY");
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            query = this.getBuildStartProperty("TEST_BATCH_RUN_PROPERTY_QUERY");
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return query;
        }
        JobProperty jobProperty = this.getJobProperty("test.batch.run.property.query", testSuiteName, this.batchName);
        this.recordJobProperty(jobProperty);
        return jobProperty.getValue();
    }

    protected List<List<String>> getPoshiTestClassGroups(File testBaseDir) {
        String query = this.getTestBatchRunPropertyQuery(testBaseDir);
        if (JenkinsResultsParserUtil.isNullOrEmpty(query)) {
            return new ArrayList<List<String>>();
        }
        Pattern pattern = _poshiTestCasePattern;
        synchronized (pattern) {
            PortalGitWorkingDirectory portalGitWorkingDirectory = this.portalTestClassJob.getPortalGitWorkingDirectory();
            File portalWorkingDirectory = portalGitWorkingDirectory.getWorkingDirectory();
            HashMap<String, String> parameters = new HashMap<String, String>();
            String testBaseDirPath = null;
            if (testBaseDir != null && testBaseDir.exists()) {
                testBaseDirPath = JenkinsResultsParserUtil.getCanonicalPath(testBaseDir);
                parameters.put("test.base.dir.name", testBaseDirPath);
            }
            try {
                AntUtil.callTarget(portalWorkingDirectory, "build-test.xml", "prepare-poshi-runner-properties", parameters);
            }
            catch (AntException antException) {
                throw new RuntimeException(antException);
            }
            Properties properties = JenkinsResultsParserUtil.getProperties(new File(portalWorkingDirectory, "portal-web/poshi-ext.properties"));
            if (!JenkinsResultsParserUtil.isNullOrEmpty(testBaseDirPath)) {
                properties.setProperty("test.base.dir.name", testBaseDirPath);
            }
            PropsUtil.clear();
            PropsUtil.setProperties((Properties)properties);
            try {
                PoshiContext.clear();
                PoshiContext.readFiles();
                return PoshiContext.getTestBatchGroups((String)query, (int)this.getAxisMaxSize());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    protected void setAxisTestClassGroups() {
        if (!this.axisTestClassGroups.isEmpty()) {
            return;
        }
        for (File testBaseDir : this.getTestBaseDirs()) {
            String query = this.getTestBatchRunPropertyQuery(testBaseDir);
            if (query == null) continue;
            List<List<String>> poshiTestClassGroups = this.getPoshiTestClassGroups(testBaseDir);
            for (List<String> poshiTestClassGroup : poshiTestClassGroups) {
                if (poshiTestClassGroup.isEmpty()) continue;
                AxisTestClassGroup axisTestClassGroup = TestClassGroupFactory.newAxisTestClassGroup(this, testBaseDir);
                for (String testClassMethodName : poshiTestClassGroup) {
                    Matcher matcher = _poshiTestCasePattern.matcher(testClassMethodName);
                    if (!matcher.find()) {
                        throw new RuntimeException("Invalid test class method name " + testClassMethodName);
                    }
                    axisTestClassGroup.addTestClass(TestClassFactory.newTestClass((BatchTestClassGroup)this, testClassMethodName));
                }
                this.axisTestClassGroups.add(axisTestClassGroup);
            }
        }
    }

    private List<File> _getFunctionalRequiredModuleDirs(List<File> moduleDirs) {
        ArrayList functionalRequiredModuleDirs = Lists.newArrayList(moduleDirs);
        File modulesBaseDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        for (File moduleDir : moduleDirs) {
            JobProperty jobProperty = this.getJobProperty("modules.includes.required.functional", moduleDir, JobProperty.Type.MODULE_TEST_DIR);
            String jobPropertyValue = jobProperty.getValue();
            if (jobPropertyValue == null) continue;
            this.recordJobProperty(jobProperty);
            for (String functionalRequiredModuleDirPath : jobPropertyValue.split(",")) {
                File functionalRequiredModuleDir = new File(modulesBaseDir, functionalRequiredModuleDirPath);
                if (!functionalRequiredModuleDir.exists() || functionalRequiredModuleDirs.contains(functionalRequiredModuleDir)) continue;
                functionalRequiredModuleDirs.add(functionalRequiredModuleDir);
            }
        }
        return Lists.newArrayList((Iterable)functionalRequiredModuleDirs);
    }

    private String _getTestBatchRunPropertyQuery(File testBaseDir) {
        JobProperty jobProperty;
        String jobPropertyValue;
        if (!this.testRelevantChanges) {
            return this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName);
        }
        HashSet<File> modifiedDirsList = new HashSet<File>();
        try {
            modifiedDirsList.addAll(this.portalGitWorkingDirectory.getModifiedModuleDirsList());
        }
        catch (IOException ioException) {
            File workingDirectory = this.portalGitWorkingDirectory.getWorkingDirectory();
            throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get module directories in ", workingDirectory.getPath()), ioException);
        }
        File modulesDir = new File(this.portalGitWorkingDirectory.getWorkingDirectory(), "modules");
        modifiedDirsList.addAll(this.portalGitWorkingDirectory.getModifiedDirsList(false, JenkinsResultsParserUtil.toPathMatchers(null, JenkinsResultsParserUtil.getCanonicalPath(modulesDir)), null));
        modifiedDirsList.addAll(this.getRequiredModuleDirs(Lists.newArrayList(modifiedDirsList)));
        modifiedDirsList.addAll(this._getFunctionalRequiredModuleDirs(Lists.newArrayList(modifiedDirsList)));
        StringBuilder sb = new StringBuilder();
        for (File modifiedDir : modifiedDirsList) {
            JobProperty jobProperty2 = this.getJobProperty("test.batch.run.property.query", modifiedDir, JobProperty.Type.MODULE_TEST_DIR, false);
            String jobPropertyValue2 = jobProperty2.getValue();
            if (JenkinsResultsParserUtil.isNullOrEmpty(jobPropertyValue2) || jobPropertyValue2.equals("false")) continue;
            this.recordJobProperty(jobProperty2);
            if (sb.length() > 0) {
                sb.append(" OR (");
            } else {
                sb.append("(");
            }
            sb.append(jobPropertyValue2);
            sb.append(")");
        }
        if (sb.length() > 0) {
            sb.append(" OR ");
        }
        sb.append("(");
        sb.append(this.getDefaultTestBatchRunPropertyQuery(testBaseDir, this.testSuiteName));
        sb.append(")");
        if (!"stable".equals(this.getTestSuiteName())) {
            String batchName = this.getBatchName();
            if (!batchName.endsWith("_stable")) {
                batchName = batchName + "_stable";
            }
            if ((jobPropertyValue = (jobProperty = this.getJobProperty("test.batch.run.property.query", "stable", batchName)).getValue()) != null && this.includeStableTestSuite && this.isStableTestSuiteBatch(batchName)) {
                this.recordJobProperty(jobProperty);
                sb.append(" OR (");
                sb.append(jobPropertyValue);
                sb.append(")");
            }
        }
        String testBatchRunPropertyQuery = sb.toString();
        jobProperty = this.getJobProperty("test.batch.run.property.global.query");
        jobPropertyValue = jobProperty.getValue();
        if (jobPropertyValue != null) {
            this.recordJobProperty(jobProperty);
            testBatchRunPropertyQuery = JenkinsResultsParserUtil.combine("(", jobPropertyValue, ") AND (", testBatchRunPropertyQuery, ")");
        }
        return testBatchRunPropertyQuery;
    }

    private void _setTestBatchRunPropertyQueries() {
        for (File testBaseDir : this.getTestBaseDirs()) {
            String testBatchRunPropertyQuery = this._getTestBatchRunPropertyQuery(testBaseDir);
            if (JenkinsResultsParserUtil.isNullOrEmpty(testBatchRunPropertyQuery)) continue;
            this._testBatchRunPropertyQueries.put(testBaseDir, testBatchRunPropertyQuery);
        }
    }
}

