/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class BaseTestClassGroup
implements TestClassGroup {
    protected final List<TestClass> testClasses = new ArrayList<TestClass>();

    @Override
    public List<TestClass> getTestClasses() {
        return this.testClasses;
    }

    @Override
    public List<File> getTestClassFiles() {
        ArrayList<File> testClassFiles = new ArrayList<File>();
        for (TestClass testClass : this.testClasses) {
            testClassFiles.add(testClass.getTestClassFile());
        }
        return testClassFiles;
    }

    protected void addTestClass(TestClass testClass) {
        if (!this.testClasses.contains(testClass)) {
            this.testClasses.add(testClass);
        }
    }

    protected String getBuildStartProperty(String propertyName) {
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        if (buildDatabase.hasProperties("start.properties")) {
            Properties startProperties = buildDatabase.getProperties("start.properties");
            return JenkinsResultsParserUtil.getProperty(startProperties, propertyName);
        }
        return null;
    }
}

