/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz.group;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.BaseTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import java.io.File;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class AxisTestClassGroup
extends BaseTestClassGroup {
    private BatchTestClassGroup _batchTestClassGroup;
    private SegmentTestClassGroup _segmentTestClassGroup;

    public String getAxisName() {
        if (this._segmentTestClassGroup != null) {
            List<AxisTestClassGroup> axisTestClassGroups = this._segmentTestClassGroup.getAxisTestClassGroups();
            return JenkinsResultsParserUtil.combine(this._segmentTestClassGroup.getSegmentName(), "/", String.valueOf(axisTestClassGroups.indexOf(this)));
        }
        List<AxisTestClassGroup> axisTestClassGroups = this._batchTestClassGroup.getAxisTestClassGroups();
        return JenkinsResultsParserUtil.combine(this._batchTestClassGroup.getBatchName(), "/", String.valueOf(axisTestClassGroups.indexOf(this)));
    }

    public String getBatchJobName() {
        return this._batchTestClassGroup.getBatchJobName();
    }

    public String getBatchName() {
        return this._batchTestClassGroup.getBatchName();
    }

    public BatchTestClassGroup getBatchTestClassGroup() {
        return this._batchTestClassGroup;
    }

    @Override
    public Job getJob() {
        return this._batchTestClassGroup.getJob();
    }

    public JSONObject getJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("axis_name", (Object)this.getAxisName());
        JSONArray testClassesJSONArray = new JSONArray();
        jsonObject.put("test_classes", (Object)testClassesJSONArray);
        for (TestClass testClass : this.getTestClasses()) {
            if (testClass == null) {
                throw new RuntimeException("Unable to not find test class in " + this.getAxisName());
            }
            testClassesJSONArray.put((Object)testClass.getJSONObject());
        }
        return jsonObject;
    }

    public Integer getMinimumSlaveRAM() {
        if (this._segmentTestClassGroup != null) {
            return this._segmentTestClassGroup.getMinimumSlaveRAM();
        }
        return this._batchTestClassGroup.getMinimumSlaveRAM();
    }

    public String getSegmentName() {
        if (this._segmentTestClassGroup != null) {
            return this._segmentTestClassGroup.getSegmentName();
        }
        return null;
    }

    public SegmentTestClassGroup getSegmentTestClassGroup() {
        return this._segmentTestClassGroup;
    }

    public String getSlaveLabel() {
        if (this._segmentTestClassGroup != null) {
            return this._segmentTestClassGroup.getSlaveLabel();
        }
        return this._batchTestClassGroup.getSlaveLabel();
    }

    public File getTestBaseDir() {
        return null;
    }

    protected AxisTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        this.setBatchTestClassGroup(batchTestClassGroup);
    }

    protected AxisTestClassGroup(JSONObject jsonObject, SegmentTestClassGroup segmentTestClassGroup) {
        BatchTestClassGroup batchTestClassGroup = segmentTestClassGroup.getBatchTestClassGroup();
        this.setBatchTestClassGroup(batchTestClassGroup);
        this.setSegmentTestClassGroup(segmentTestClassGroup);
        JSONArray testClassesJSONArray = jsonObject.getJSONArray("test_classes");
        if (testClassesJSONArray == null || testClassesJSONArray.isEmpty()) {
            return;
        }
        for (int i = 0; i < testClassesJSONArray.length(); ++i) {
            JSONObject testClassJSONObject = testClassesJSONArray.getJSONObject(i);
            if (testClassJSONObject == null) continue;
            this.testClasses.add(TestClassFactory.newTestClass(batchTestClassGroup, testClassJSONObject));
        }
    }

    protected void setBatchTestClassGroup(BatchTestClassGroup batchTestClassGroup) {
        this._batchTestClassGroup = batchTestClassGroup;
    }

    protected void setSegmentTestClassGroup(SegmentTestClassGroup segmentTestClassGroup) {
        this._segmentTestClassGroup = segmentTestClassGroup;
    }
}

