/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.test.clazz.BatchTestClass;
import com.liferay.jenkins.results.parser.test.clazz.CompileModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.FunctionalTestClass;
import com.liferay.jenkins.results.parser.test.clazz.JSUnitModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.JUnitTestClass;
import com.liferay.jenkins.results.parser.test.clazz.NPMTestClass;
import com.liferay.jenkins.results.parser.test.clazz.PluginsGulpTestClass;
import com.liferay.jenkins.results.parser.test.clazz.PluginsTestClass;
import com.liferay.jenkins.results.parser.test.clazz.RESTBuilderModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.SemVerModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.ServiceBuilderModulesTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TCKTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.CompileModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JSUnitModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.JUnitBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.NPMTestBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.PluginsGulpBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.RESTBuilderModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SemVerModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.ServiceBuilderModulesBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TCKJunitBatchTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class TestClassFactory {
    private static final Map<String, TestClass> _testClasses = new HashMap<String, TestClass>();

    public static List<TestClass> getTestClasses() {
        return new ArrayList<TestClass>(_testClasses.values());
    }

    public static TestClass newTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        return TestClassFactory._newTestClass(batchTestClassGroup, null, testClassFile, null);
    }

    public static TestClass newTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile, String testClassMethodName) {
        return TestClassFactory._newTestClass(batchTestClassGroup, null, testClassFile, testClassMethodName);
    }

    public static TestClass newTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        return TestClassFactory._newTestClass(batchTestClassGroup, jsonObject, null, null);
    }

    public static TestClass newTestClass(BatchTestClassGroup batchTestClassGroup, String testClassMethodName) {
        return TestClassFactory._newTestClass(batchTestClassGroup, null, null, testClassMethodName);
    }

    public static TestClassMethod newTestClassMethod(boolean ignored, String name, TestClass testClass) {
        return new TestClassMethod(ignored, name, testClass);
    }

    public static TestClassMethod newTestClassMethod(JSONObject jsonObject, TestClass testClass) {
        return new TestClassMethod(jsonObject, testClass);
    }

    private static TestClass _newTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject, File testClassFile, String testClassMethodName) {
        StringBuilder sb = new StringBuilder();
        sb.append(batchTestClassGroup.getBatchName());
        if (testClassFile != null && testClassFile.exists()) {
            sb.append("_");
            sb.append(JenkinsResultsParserUtil.getCanonicalPath(testClassFile));
        } else if (jsonObject != null && jsonObject.has("file")) {
            sb.append("_");
            sb.append(jsonObject.getString("file"));
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(testClassMethodName)) {
            sb.append("_");
            sb.append(testClassMethodName);
        } else if (jsonObject != null && jsonObject.has("test_class_method_name")) {
            sb.append("_");
            sb.append(jsonObject.getString("test_class_method_name"));
        }
        String key = sb.toString();
        TestClass testClass = _testClasses.get(key);
        if (testClass != null) {
            return testClass;
        }
        testClass = batchTestClassGroup instanceof CompileModulesBatchTestClassGroup ? (jsonObject != null ? new CompileModulesTestClass(batchTestClassGroup, jsonObject) : new CompileModulesTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof FunctionalBatchTestClassGroup ? (jsonObject != null ? new FunctionalTestClass(batchTestClassGroup, jsonObject) : new FunctionalTestClass(batchTestClassGroup, testClassMethodName)) : (batchTestClassGroup instanceof JSUnitModulesBatchTestClassGroup ? (jsonObject != null ? new JSUnitModulesTestClass(batchTestClassGroup, jsonObject) : new JSUnitModulesTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof JUnitBatchTestClassGroup ? (jsonObject != null ? new JUnitTestClass(batchTestClassGroup, jsonObject) : new JUnitTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof NPMTestBatchTestClassGroup ? (jsonObject != null ? new NPMTestClass(batchTestClassGroup, jsonObject) : new NPMTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof PluginsBatchTestClassGroup ? (jsonObject != null ? new PluginsTestClass(batchTestClassGroup, jsonObject) : new PluginsTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof PluginsGulpBatchTestClassGroup ? (jsonObject != null ? new PluginsGulpTestClass(batchTestClassGroup, jsonObject) : new PluginsGulpTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof RESTBuilderModulesBatchTestClassGroup ? (jsonObject != null ? new RESTBuilderModulesTestClass(batchTestClassGroup, jsonObject) : new RESTBuilderModulesTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof SemVerModulesBatchTestClassGroup ? (jsonObject != null ? new SemVerModulesTestClass(batchTestClassGroup, jsonObject) : new SemVerModulesTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof ServiceBuilderModulesBatchTestClassGroup ? (jsonObject != null ? new ServiceBuilderModulesTestClass(batchTestClassGroup, jsonObject) : new ServiceBuilderModulesTestClass(batchTestClassGroup, testClassFile)) : (batchTestClassGroup instanceof TCKJunitBatchTestClassGroup ? (jsonObject != null ? new TCKTestClass(batchTestClassGroup, jsonObject) : new TCKTestClass(batchTestClassGroup, testClassFile)) : (jsonObject != null ? new BatchTestClass(batchTestClassGroup, jsonObject) : new BatchTestClass(batchTestClassGroup, testClassFile))))))))))));
        _testClasses.put(key, testClass);
        return _testClasses.get(key);
    }
}

