/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.test.clazz.BaseTestClass;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.json.JSONObject;

public abstract class ModulesTestClass
extends BaseTestClass {
    private final String _taskName;

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = super.getJSONObject();
        jsonObject.put("task_name", (Object)this._taskName);
        return jsonObject;
    }

    protected ModulesTestClass(BatchTestClassGroup batchTestClassGroup, File moduleBaseDir, String taskName) {
        super(batchTestClassGroup, moduleBaseDir);
        this._taskName = taskName;
        for (File modulesProjectDir : this.getModulesProjectDirs()) {
            String path = JenkinsResultsParserUtil.getPathRelativeTo(modulesProjectDir, this.getPortalModulesBaseDir());
            String moduleTaskCall = JenkinsResultsParserUtil.combine(":", path.replaceAll("/", ":"), ":", this.getTaskName());
            this.addTestClassMethod(moduleTaskCall);
        }
    }

    protected ModulesTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._taskName = jsonObject.getString("task_name");
    }

    protected File getModuleBaseDir() {
        return this.getTestClassFile();
    }

    protected Path getModuleBaseDirPath() {
        File testClassFile = this.getTestClassFile();
        return testClassFile.toPath();
    }

    protected abstract List<File> getModulesProjectDirs();

    protected File getPortalModulesBaseDir() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return new File(portalGitWorkingDirectory.getWorkingDirectory(), "modules");
    }

    protected String getTaskName() {
        return this._taskName;
    }
}

