/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.test.clazz.BaseTestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class JUnitTestClass
extends BaseTestClass {
    private static final Pattern _classHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\*/(?<annotations>[^/]*)public\\s+class\\s+", "(?<className>[^\\(\\s]+)"));
    private static final Pattern _methodHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\t(?<annotations>(@[\\s\\S]+?))public\\s+void\\s+", "(?<methodName>[^\\(\\s]+)"));
    private boolean _classIgnored;
    private final String _fileContent;
    private Properties _testProperties;

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = super.getJSONObject();
        jsonObject.put("test_properties", (Map)this._testProperties);
        return jsonObject;
    }

    public Properties getTestProperties() {
        return this._testProperties;
    }

    @Override
    public boolean isIgnored() {
        return this._classIgnored;
    }

    protected JUnitTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        super(batchTestClassGroup, testClassFile);
        String testClassFileName = testClassFile.getName();
        if (!testClassFileName.endsWith(".java")) {
            this._fileContent = "";
            return;
        }
        this._setTestProperties(this._getTestPropertiesBaseDir(this.getTestClassFile()));
        try {
            this._fileContent = JenkinsResultsParserUtil.read(this.getTestClassFile());
            this._initTestClassMethods();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    protected JUnitTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        super(batchTestClassGroup, jsonObject);
        this._classIgnored = jsonObject.getBoolean("ignored");
        this._fileContent = "";
        this._testProperties = new Properties();
        JSONObject testPropertiesJSONObject = jsonObject.getJSONObject("test_properties");
        if (testPropertiesJSONObject == null) {
            return;
        }
        for (String key : testPropertiesJSONObject.keySet()) {
            this._testProperties.setProperty(key, testPropertiesJSONObject.getString(key));
        }
    }

    private String _getClassName() {
        File testClassFile = this.getTestClassFile();
        String testClassFileName = testClassFile.getName();
        return testClassFileName.substring(0, testClassFileName.lastIndexOf("."));
    }

    private String _getPackageName() {
        String testClassFilePath = JenkinsResultsParserUtil.getCanonicalPath(this.getTestClassFile());
        int x = testClassFilePath.indexOf("/com/");
        int y = testClassFilePath.lastIndexOf("/");
        testClassFilePath = testClassFilePath.substring(x + 1, y);
        return testClassFilePath.replaceAll("/", ".");
    }

    private String _getParentClassName() {
        Pattern classHeaderPattern = Pattern.compile(JenkinsResultsParserUtil.combine("public\\s+(abstract\\s+)?(class|interface)\\s+", this._getClassName(), "(\\<[^\\<]+\\>)?(?<classHeaderEntities>[^\\{]+)\\{"));
        Matcher classHeaderMatcher = classHeaderPattern.matcher(this._fileContent);
        if (!classHeaderMatcher.find()) {
            throw new RuntimeException("No class header found in " + this.getTestClassFile());
        }
        String classHeaderEntities = classHeaderMatcher.group("classHeaderEntities");
        Pattern parentClassPattern = Pattern.compile(JenkinsResultsParserUtil.combine("extends\\s+(?<parentClassName>[^\\s\\<]+)"));
        Matcher parentClassMatcher = parentClassPattern.matcher(classHeaderEntities);
        if (parentClassMatcher.find()) {
            return parentClassMatcher.group("parentClassName");
        }
        return null;
    }

    private String _getParentFullClassName() {
        String parentClassName = this._getParentClassName();
        if (parentClassName == null) {
            return null;
        }
        if (parentClassName.contains(".") && parentClassName.matches("[a-z].*")) {
            if (!parentClassName.startsWith("com.liferay")) {
                return null;
            }
            return parentClassName;
        }
        String parentPackageName = this._getParentPackageName(parentClassName);
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName + "." + parentClassName;
    }

    private String _getParentPackageName(String parentClassName) {
        Pattern parentImportClassPattern = Pattern.compile(JenkinsResultsParserUtil.combine("import\\s+(?<parentPackageName>[^;]+)\\.", parentClassName, ";"));
        Matcher parentImportClassMatcher = parentImportClassPattern.matcher(this._fileContent);
        if (parentImportClassMatcher.find()) {
            String parentPackageName = parentImportClassMatcher.group("parentPackageName");
            if (!parentPackageName.startsWith("com.liferay")) {
                return null;
            }
            return parentPackageName;
        }
        return this._getPackageName();
    }

    private File _getTestPropertiesBaseDir(File file) {
        if (file == null) {
            return null;
        }
        File canonicalFile = JenkinsResultsParserUtil.getCanonicalFile(file);
        File parentFile = canonicalFile.getParentFile();
        if (parentFile == null || !parentFile.exists()) {
            return file;
        }
        if (!canonicalFile.isDirectory()) {
            return this._getTestPropertiesBaseDir(parentFile);
        }
        File testPropertiesFile = new File(canonicalFile, "test.properties");
        if (!testPropertiesFile.exists()) {
            return this._getTestPropertiesBaseDir(parentFile);
        }
        return canonicalFile;
    }

    private void _initTestClassMethods() {
        String annotations;
        Matcher classHeaderMatcher = _classHeaderPattern.matcher(this._fileContent);
        this._classIgnored = false;
        if (classHeaderMatcher.find() && (annotations = classHeaderMatcher.group("annotations")) != null && annotations.contains("@Ignore")) {
            this._classIgnored = true;
        }
        Matcher methodHeaderMatcher = _methodHeaderPattern.matcher(this._fileContent);
        while (methodHeaderMatcher.find()) {
            String annotations2 = methodHeaderMatcher.group("annotations");
            boolean methodIgnored = false;
            if (this._classIgnored || annotations2.contains("@Ignore")) {
                methodIgnored = true;
            }
            if (!annotations2.contains("@Test")) continue;
            String methodName = methodHeaderMatcher.group("methodName");
            this.addTestClassMethod(methodIgnored, methodName);
        }
        String parentFullClassName = this._getParentFullClassName();
        if (parentFullClassName == null) {
            return;
        }
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        File parentJavaFile = portalGitWorkingDirectory.getJavaFileFromFullClassName(parentFullClassName);
        if (parentJavaFile == null) {
            System.out.println("No matching files found for " + parentFullClassName);
            return;
        }
        TestClass parentTestClass = TestClassFactory.newTestClass(this.getBatchTestClassGroup(), parentJavaFile);
        if (parentTestClass == null) {
            return;
        }
        for (TestClassMethod testClassMethod : parentTestClass.getTestClassMethods()) {
            this.addTestClassMethod(this._classIgnored, testClassMethod.getName());
        }
    }

    private void _setTestProperties(File testPropertiesBaseDir) {
        this._testProperties = JenkinsResultsParserUtil.getProperties(new File(testPropertiesBaseDir, "test.properties"));
    }
}

