/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.test.clazz;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.test.clazz.TestClass;
import com.liferay.jenkins.results.parser.test.clazz.TestClassFactory;
import com.liferay.jenkins.results.parser.test.clazz.TestClassMethod;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseTestClass
implements TestClass {
    private final BatchTestClassGroup _batchTestClassGroup;
    private final File _testClassFile;
    private final List<TestClassMethod> _testClassMethods = new ArrayList<TestClassMethod>();

    @Override
    public int compareTo(TestClass testClass) {
        if (testClass == null) {
            throw new NullPointerException("Test class is null");
        }
        return this._testClassFile.compareTo(testClass.getTestClassFile());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TestClass)) {
            return false;
        }
        return Objects.equals(this.hashCode(), object.hashCode());
    }

    @Override
    public JSONObject getJSONObject() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("file", (Object)this.getTestClassFile());
        jsonObject.put("ignored", this.isIgnored());
        JSONArray methodsJSONArray = new JSONArray();
        for (TestClassMethod testClassMethod : this.getTestClassMethods()) {
            methodsJSONArray.put((Object)testClassMethod.getJSONObject());
        }
        jsonObject.put("methods", (Object)methodsJSONArray);
        jsonObject.put("name", (Object)this.getName());
        return jsonObject;
    }

    @Override
    public String getName() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return JenkinsResultsParserUtil.getPathRelativeTo(this.getTestClassFile(), portalGitWorkingDirectory.getWorkingDirectory());
    }

    @Override
    public File getTestClassFile() {
        return this._testClassFile;
    }

    @Override
    public List<TestClassMethod> getTestClassMethods() {
        return this._testClassMethods;
    }

    public int hashCode() {
        JSONObject jsonObject = this.getJSONObject();
        return jsonObject.hashCode();
    }

    @Override
    public boolean hasTestClassMethods() {
        List<TestClassMethod> testClassMethods = this.getTestClassMethods();
        return testClassMethods != null && !testClassMethods.isEmpty();
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    protected BaseTestClass(BatchTestClassGroup batchTestClassGroup, File testClassFile) {
        this._batchTestClassGroup = batchTestClassGroup;
        this._testClassFile = testClassFile;
    }

    protected BaseTestClass(BatchTestClassGroup batchTestClassGroup, JSONObject jsonObject) {
        this._batchTestClassGroup = batchTestClassGroup;
        this._testClassFile = new File(jsonObject.getString("file"));
        JSONArray methodsJSONArray = jsonObject.getJSONArray("methods");
        if (methodsJSONArray != null && !methodsJSONArray.isEmpty()) {
            for (int i = 0; i < methodsJSONArray.length(); ++i) {
                JSONObject methodJSONObject = methodsJSONArray.getJSONObject(i);
                if (methodJSONObject == null) continue;
                this._testClassMethods.add(TestClassFactory.newTestClassMethod(methodJSONObject, this));
            }
        }
    }

    protected void addTestClassMethod(boolean methodIgnored, String methodName) {
        this.addTestClassMethod(TestClassFactory.newTestClassMethod(methodIgnored, methodName, this));
    }

    protected void addTestClassMethod(String methodName) {
        this.addTestClassMethod(false, methodName);
    }

    protected void addTestClassMethod(TestClassMethod testClassMethod) {
        this._testClassMethods.add(testClassMethod);
    }

    protected BatchTestClassGroup getBatchTestClassGroup() {
        return this._batchTestClassGroup;
    }

    protected PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return this._batchTestClassGroup.getPortalGitWorkingDirectory();
    }

    protected File getPortalWorkingDirectory() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        return portalGitWorkingDirectory.getWorkingDirectory();
    }
}

