/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.job.property;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.BaseTestDirJobProperty;
import com.liferay.jenkins.results.parser.job.property.GlobJobProperty;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import java.io.File;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class BaseGlobJobProperty
extends BaseTestDirJobProperty
implements GlobJobProperty {
    @Override
    public List<PathMatcher> getPathMatchers() {
        List<PathMatcher> pathMatchers = JenkinsResultsParserUtil.toPathMatchers(this._getWorkingDirectory() + "/", this.getRelativeGlobs());
        pathMatchers.removeAll(Collections.singleton(null));
        return pathMatchers;
    }

    @Override
    public List<String> getRelativeGlobs() {
        ArrayList<String> relativeGlobs = new ArrayList<String>();
        String value = this.getValue();
        if (JenkinsResultsParserUtil.isNullOrEmpty(value)) {
            return relativeGlobs;
        }
        String relativePath = this.getRelativePath();
        for (String glob : value.split(",")) {
            String relativeGlob = relativePath + "/" + glob;
            if ((relativeGlob = relativeGlob.replaceAll("/+", "/")).startsWith("/")) {
                relativeGlob = relativeGlob.substring(1);
            }
            relativeGlobs.add(relativeGlob);
        }
        return relativeGlobs;
    }

    @Override
    public File getTestBaseDir() {
        File testBaseDir = super.getTestBaseDir();
        if (testBaseDir != null) {
            return testBaseDir;
        }
        Job job = this.getJob();
        if (job instanceof PortalTestClassJob) {
            PortalTestClassJob portalTestClassJob = (PortalTestClassJob)job;
            PortalGitWorkingDirectory portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
            return portalGitWorkingDirectory.getWorkingDirectory();
        }
        return null;
    }

    protected BaseGlobJobProperty(Job job, JobProperty.Type type, File testBaseDir, String basePropertyName, boolean useBasePropertyName, String testSuiteName, String testBatchName) {
        super(job, type, testBaseDir, basePropertyName, useBasePropertyName, testSuiteName, testBatchName);
    }

    protected String getRelativePath() {
        File testBaseDir;
        File gitWorkingDirectory = this._getWorkingDirectory();
        if (Objects.equals(gitWorkingDirectory, testBaseDir = this.getTestBaseDir())) {
            return "";
        }
        return JenkinsResultsParserUtil.getPathRelativeTo(testBaseDir, gitWorkingDirectory);
    }

    private File _getWorkingDirectory() {
        File testBaseDir = this.getTestBaseDir();
        if (testBaseDir != null) {
            return BaseGlobJobProperty.getWorkingDirectory(testBaseDir);
        }
        Job job = this.getJob();
        if (!(job instanceof PortalTestClassJob)) {
            return new File(".");
        }
        PortalTestClassJob portalTestClassJob = (PortalTestClassJob)job;
        PortalGitWorkingDirectory portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
        return portalGitWorkingDirectory.getWorkingDirectory();
    }
}

