/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser.github.webhook;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PullRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class PullRequestTesterParameters
extends HashMap<String, String> {
    private static final String _KEY_CI_FORWARD_RECEIVER_USERNAME = "CI_FORWARD_RECEIVER_USERNAME";
    private static final String _KEY_CI_REEVALUATE_BUILD_ID = "BUILD_ID";
    private static final String _KEY_CI_TEST_SUITE_NAME = "CI_TEST_SUITE";
    private static final String _KEY_GITHUB_UPSTREAM_BRANCH_SHA = "GITHUB_UPSTREAM_BRANCH_SHA";
    private static final String _KEY_JENKINS_AUTHENTICATION_TOKEN = "token";
    private static final String _KEY_PORTAL_BUNDLES_DIST_URL = "PORTAL_BUNDLES_DIST_URL";
    private static final String _KEY_PULL_REQUEST_NUMBER = "GITHUB_PULL_REQUEST_NUMBER";
    private final PullRequest _pullRequest;

    public PullRequestTesterParameters(PullRequest pullRequest) {
        Properties jenkinsBuildProperties;
        this._pullRequest = pullRequest;
        try {
            jenkinsBuildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        this.put(_KEY_CI_TEST_SUITE_NAME, "default");
        this.put(_KEY_JENKINS_AUTHENTICATION_TOKEN, jenkinsBuildProperties.getProperty("jenkins.authentication.token"));
        String ciForwardReceiverUsername = jenkinsBuildProperties.getProperty("pull.request.forward.default.receiver.username");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(ciForwardReceiverUsername)) {
            this.setCiForwardReceiverUsername(ciForwardReceiverUsername);
        }
    }

    public String getCiForwardReceiverUsername() {
        return (String)this.get(_KEY_CI_FORWARD_RECEIVER_USERNAME);
    }

    public String getCiReevaluateBuildId() {
        return (String)this.get(_KEY_CI_REEVALUATE_BUILD_ID);
    }

    public String getCiTestSuiteName() {
        return (String)this.get(_KEY_CI_TEST_SUITE_NAME);
    }

    public PullRequest getPullRequest() {
        return this._pullRequest;
    }

    @Override
    public String put(String key, String value) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(value) && this.containsKey(key)) {
            return (String)this.remove(key);
        }
        return super.put(key, value);
    }

    public void setCiForwardReceiverUsername(String ciForwardReceiverUsername) {
        this.put(_KEY_CI_FORWARD_RECEIVER_USERNAME, ciForwardReceiverUsername);
    }

    public void setCiReevaluateBuildId(String ciReevaluateBuildId) {
        this.put(_KEY_CI_REEVALUATE_BUILD_ID, ciReevaluateBuildId);
    }

    public void setCiTestSuiteName(String ciTestSuiteName) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(ciTestSuiteName)) {
            ciTestSuiteName = "default";
        }
        this.put(_KEY_CI_TEST_SUITE_NAME, ciTestSuiteName);
    }

    public void setPortalBundlesDistURL(String portalBundlesDistURL) {
        this.put(_KEY_PORTAL_BUNDLES_DIST_URL, portalBundlesDistURL);
    }

    public void setUpstreamBranchSHA(String upstreamBranchSHA) {
        this.put(_KEY_GITHUB_UPSTREAM_BRANCH_SHA, upstreamBranchSHA);
    }

    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.entrySet()) {
            this._appendParameter(sb, (String)entry.getKey(), (String)entry.getValue());
        }
        this._appendParameter(sb, _KEY_PULL_REQUEST_NUMBER, this._pullRequest.getNumber());
        this._appendParameter(sb, "GITHUB_ORIGIN_NAME", this._encode(this._pullRequest.getSenderUsername()));
        this._appendParameter(sb, "GITHUB_RECEIVER_USERNAME", this._pullRequest.getReceiverUsername());
        this._appendParameter(sb, "GITHUB_SENDER_BRANCH_NAME", this._pullRequest.getSenderBranchName());
        this._appendParameter(sb, "GITHUB_SENDER_BRANCH_SHA", this._pullRequest.getSenderSHA());
        this._appendParameter(sb, "GITHUB_SENDER_USERNAME", this._encode(this._pullRequest.getSenderUsername()));
        this._appendParameter(sb, "GITHUB_UPSTREAM_BRANCH_NAME", this._pullRequest.getUpstreamRemoteGitBranchName());
        if (!this.containsKey(_KEY_GITHUB_UPSTREAM_BRANCH_SHA)) {
            this._appendParameter(sb, _KEY_GITHUB_UPSTREAM_BRANCH_SHA, this._pullRequest.getUpstreamBranchSHA());
        }
        this._appendParameter(sb, "PULL_REQUEST_URL", this._pullRequest.getHtmlURL());
        this._appendParameter(sb, "REPOSITORY_NAME", this._pullRequest.getGitRepositoryName());
        return sb.toString();
    }

    private void _appendParameter(StringBuilder sb, String name, String value) {
        if (JenkinsResultsParserUtil.isNullOrEmpty(value)) {
            return;
        }
        if (sb.length() > 0) {
            sb.append("&");
        }
        sb.append(name);
        sb.append("=");
        sb.append(value);
    }

    private String _encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported Encoding: UTF-8", unsupportedEncodingException);
        }
    }
}

