/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpstreamPortalTopLevelBuild
extends PortalTopLevelBuild
implements PortalWorkspaceBuild {
    private static final Pattern _pattern = Pattern.compile("https://github.com/(?<username>[^/]+)/(?<repositoryName>[^/]+)/tree/(?<branchName>[^/]+)");

    public UpstreamPortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public Workspace getWorkspace() {
        String portalGitCommit;
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        if (workspace instanceof PortalWorkspace) {
            PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
            portalWorkspace.setBuildProfile(this.getBuildProfile());
            portalWorkspace.setOSBAsahGitHubURL(this._getOSBAsahGitHubURL());
            portalWorkspace.setOSBFaroGitHubURL(this._getOSBFaroGitHubURL());
            portalWorkspace.setPortalPrivateGitHubURL(this._getPortalPrivateGitHubURL());
        }
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        String portalGitHubURL = this._getPortalGitHubURL();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL)) {
            workspaceGitRepository.setGitHubURL(portalGitHubURL);
        }
        if (JenkinsResultsParserUtil.isSHA(portalGitCommit = this._getPortalGitCommit())) {
            workspaceGitRepository.setSenderBranchSHA(portalGitCommit);
        }
        return workspace;
    }

    private String _getOSBAsahGitHubURL() {
        String osbAsahGitHubURL = this.getParameterValue("OSB_ASAH_GITHUB_URL");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(osbAsahGitHubURL)) {
            return osbAsahGitHubURL;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild != null) {
            return controllerBuild.getParameterValue("OSB_ASAH_GITHUB_URL");
        }
        return null;
    }

    private String _getOSBFaroGitHubURL() {
        String osbFaroGitHubURL = this.getParameterValue("OSB_FARO_GITHUB_URL");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(osbFaroGitHubURL)) {
            return osbFaroGitHubURL;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild != null) {
            return controllerBuild.getParameterValue("OSB_FARO_GITHUB_URL");
        }
        return null;
    }

    private String _getPortalGitCommit() {
        String portalGitCommit = this.getParameterValue("PORTAL_GIT_COMMIT");
        if (JenkinsResultsParserUtil.isSHA(portalGitCommit)) {
            return portalGitCommit;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild != null && JenkinsResultsParserUtil.isSHA(portalGitCommit = controllerBuild.getParameterValue("PORTAL_GIT_COMMIT"))) {
            return portalGitCommit;
        }
        String portalBundlesDistURL = this.getParameterValue("PORTAL_BUNDLES_DIST_URL");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBundlesDistURL)) {
            return null;
        }
        try {
            URL portalBundlesGitHashURL = new URL(JenkinsResultsParserUtil.getLocalURL(portalBundlesDistURL) + "/git-hash");
            if (!JenkinsResultsParserUtil.exists(portalBundlesGitHashURL)) {
                return null;
            }
            String portalBundlesGitHash = JenkinsResultsParserUtil.toString(portalBundlesGitHashURL.toString());
            if (JenkinsResultsParserUtil.isSHA(portalBundlesGitHash = portalBundlesGitHash.trim())) {
                return portalBundlesGitHash;
            }
            return null;
        }
        catch (IOException ioException) {
            return null;
        }
    }

    private String _getPortalGitHubURL() {
        String gitHubURL = this.getParameterValue("PORTAL_GITHUB_URL");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return gitHubURL;
        }
        Build controllerBuild = this.getControllerBuild();
        if (controllerBuild != null && !JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL = controllerBuild.getParameterValue("PORTAL_GITHUB_URL"))) {
            return gitHubURL;
        }
        String gitHubBranchName = this.getParameterValue("PORTAL_GITHUB_BRANCH_NAME");
        String gitHubBranchUsername = this.getParameterValue("PORTAL_GITHUB_BRANCH_USERNAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(gitHubBranchUsername)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(gitHubBranchUsername);
        sb.append("/liferay-portal");
        String branchName = this.getBranchName();
        if (!branchName.equals("master")) {
            sb.append("-ee");
        }
        sb.append("/tree/");
        sb.append(gitHubBranchName);
        return sb.toString();
    }

    private String _getPortalPrivateGitHubURL() {
        String branchName = this.getBranchName();
        if (branchName.startsWith("ee-") || branchName.endsWith("-private")) {
            return null;
        }
        String portalGitHubURL = this._getPortalGitHubURL();
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL)) {
            return null;
        }
        Matcher matcher = _pattern.matcher(portalGitHubURL);
        if (!matcher.find()) {
            return null;
        }
        return JenkinsResultsParserUtil.combine("https://github.com/", matcher.group("username"), "/liferay-portal-ee/tree/", branchName, "-private");
    }
}

