/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UpstreamFailureUtil {
    private static final JSONObject _defaultUpstreamFailuresJSONObject = new JSONObject("{\"SHA\":\"\",\"failedBatches\":[]}");
    private static boolean _upstreamComparisonAvailable = true;
    private static JSONObject _upstreamFailuresJobJSONObject;
    private static final File _upstreamJobFailuresJSONFile;

    public static int getUpstreamJobFailuresBuildNumber(TopLevelBuild topLevelBuild) {
        try {
            JSONObject upstreamJobFailuresJSONObject = UpstreamFailureUtil.getUpstreamJobFailuresJSONObject(topLevelBuild);
            return upstreamJobFailuresJSONObject.getInt("buildNumber");
        }
        catch (JSONException jsonException) {
            System.out.println("Unable to get upstream acceptance failure data");
            jsonException.printStackTrace();
            return 0;
        }
    }

    public static int getUpstreamJobFailuresBuildNumber(TopLevelBuild topLevelBuild, String sha) {
        int lastUpstreamBuildNumber;
        String jobURL = UpstreamFailureUtil.getUpstreamJobFailuresJobURL(topLevelBuild);
        for (int buildNumber = lastUpstreamBuildNumber = UpstreamFailureUtil._getLastUpstreamBuildNumber(topLevelBuild); buildNumber > Math.max(0, lastUpstreamBuildNumber - 10); --buildNumber) {
            try {
                String upstreamBranchSHA = JenkinsResultsParserUtil.getBuildParameter(jobURL + "/" + buildNumber, "PORTAL_GIT_COMMIT");
                if (!upstreamBranchSHA.equals(sha)) continue;
                return buildNumber;
            }
            catch (RuntimeException runtimeException) {
                System.out.println(runtimeException.getMessage());
            }
        }
        return lastUpstreamBuildNumber;
    }

    public static String getUpstreamJobFailuresJobURL(TopLevelBuild topLevelBuild) {
        try {
            JSONObject upstreamJobFailuresJSONObject = UpstreamFailureUtil.getUpstreamJobFailuresJSONObject(topLevelBuild);
            return upstreamJobFailuresJSONObject.getString("jobURL");
        }
        catch (JSONException jsonException) {
            System.out.println("Unable to get upstream acceptance failure data");
            jsonException.printStackTrace();
            return "";
        }
    }

    public static JSONObject getUpstreamJobFailuresJSONObject(TopLevelBuild topLevelBuild) {
        if (_upstreamFailuresJobJSONObject == null) {
            UpstreamFailureUtil.initUpstreamJobFailuresJSONObject(topLevelBuild);
        }
        return _upstreamFailuresJobJSONObject;
    }

    public static String getUpstreamJobFailuresSHA(TopLevelBuild topLevelBuild) {
        try {
            JSONObject upstreamJobFailuresJSONObject = UpstreamFailureUtil.getUpstreamJobFailuresJSONObject(topLevelBuild);
            return upstreamJobFailuresJSONObject.getString("SHA");
        }
        catch (JSONException jsonException) {
            System.out.println("Unable to get upstream acceptance failure data");
            jsonException.printStackTrace();
            return "";
        }
    }

    public static void initUpstreamJobFailuresJSONObject(TopLevelBuild topLevelBuild) {
        _upstreamFailuresJobJSONObject = _defaultUpstreamFailuresJSONObject;
        if (!topLevelBuild.isCompareToUpstream()) {
            return;
        }
        try {
            if (_upstreamJobFailuresJSONFile.exists()) {
                String fileContent = JenkinsResultsParserUtil.read(_upstreamJobFailuresJSONFile);
                _upstreamFailuresJobJSONObject = new JSONObject(fileContent);
            } else {
                _upstreamFailuresJobJSONObject = UpstreamFailureUtil._getUpstreamJobFailuresJSONObject(topLevelBuild);
                System.out.println("Caching upstream test results in: " + _upstreamJobFailuresJSONFile);
                JenkinsResultsParserUtil.write(_upstreamJobFailuresJSONFile, _upstreamFailuresJobJSONObject.toString());
            }
            System.out.println(JenkinsResultsParserUtil.combine("Comparing with test results from ", topLevelBuild.getAcceptanceUpstreamJobURL(), "/", String.valueOf(_upstreamFailuresJobJSONObject.getInt("buildNumber")), " at SHA ", _upstreamFailuresJobJSONObject.getString("SHA")));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println("Unable to load upstream acceptance failure data");
            _upstreamComparisonAvailable = false;
        }
    }

    public static boolean isBuildFailingInUpstreamJob(Build build) {
        if (!_upstreamComparisonAvailable || !build.isCompareToUpstream()) {
            return false;
        }
        try {
            ArrayList<TestResult> testResults = new ArrayList<TestResult>();
            testResults.addAll(build.getTestResults("FAILED"));
            testResults.addAll(build.getTestResults("REGRESSION"));
            if (testResults.isEmpty()) {
                return UpstreamFailureUtil._isBuildFailingInUpstreamJob(build);
            }
            for (TestResult testResult : testResults) {
                if (!testResult.isUniqueFailure()) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Unable to get upstream acceptance failure data.");
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isTestFailingInUpstreamJob(TestResult testResult) {
        Build build = testResult.getBuild();
        if (!_upstreamComparisonAvailable || !build.isCompareToUpstream()) {
            return false;
        }
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        try {
            String jobVariant = build.getJobVariant();
            jobVariant = UpstreamFailureUtil._formatJobVariant(jobVariant);
            for (String failure : UpstreamFailureUtil._getUpstreamJobFailures("test", topLevelBuild)) {
                if (!failure.equals(UpstreamFailureUtil._formatUpstreamTestFailure(jobVariant, testResult.getDisplayName()))) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("Unable to get upstream acceptance failure data.");
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isUpstreamComparisonAvailable(TopLevelBuild topLevelBuild) {
        UpstreamFailureUtil.initUpstreamJobFailuresJSONObject(topLevelBuild);
        return _upstreamComparisonAvailable;
    }

    public static void resetUpstreamJobFailuresJSONObject() {
        if (_upstreamJobFailuresJSONFile.exists()) {
            _upstreamJobFailuresJSONFile.delete();
        }
        _upstreamFailuresJobJSONObject = null;
    }

    private static String _formatJobVariant(String jobVariant) {
        jobVariant = jobVariant.replaceAll("(.*)/.*", "$1");
        return jobVariant.replaceAll("_stable$", "");
    }

    private static String _formatUpstreamBuildFailure(String jobVariant, String testResult) {
        return JenkinsResultsParserUtil.combine(jobVariant, ",", testResult);
    }

    private static String _formatUpstreamTestFailure(String jobVariant, String testName) {
        return JenkinsResultsParserUtil.combine(testName, ",", jobVariant);
    }

    private static int _getLastUpstreamBuildNumber(TopLevelBuild topLevelBuild) {
        try {
            JSONObject lastBuildJSONObject = JenkinsResultsParserUtil.toJSONObject(topLevelBuild.getAcceptanceUpstreamJobURL() + "/lastBuild/api/json?tree=number", false);
            return lastBuildJSONObject.getInt("number");
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private static List<String> _getUpstreamJobFailures(String type, TopLevelBuild topLevelBuild) {
        ArrayList<String> upstreamFailures = new ArrayList<String>();
        JSONObject upstreamJobFailuresJSONObject = UpstreamFailureUtil.getUpstreamJobFailuresJSONObject(topLevelBuild);
        JSONArray failedBatchesJSONArray = upstreamJobFailuresJSONObject.optJSONArray("failedBatches");
        if (failedBatchesJSONArray == null) {
            return upstreamFailures;
        }
        for (int i = 0; i < failedBatchesJSONArray.length(); ++i) {
            JSONObject failedBatchJSONObject = failedBatchesJSONArray.getJSONObject(i);
            String jobVariant = failedBatchJSONObject.getString("jobVariant");
            jobVariant = UpstreamFailureUtil._formatJobVariant(jobVariant);
            if (type.equals("build")) {
                upstreamFailures.add(UpstreamFailureUtil._formatUpstreamBuildFailure(jobVariant, failedBatchJSONObject.getString("result")));
                continue;
            }
            if (!type.equals("test")) continue;
            JSONArray failedTestsJSONArray = failedBatchJSONObject.getJSONArray("failedTests");
            for (int j = 0; j < failedTestsJSONArray.length(); ++j) {
                Object object = failedTestsJSONArray.get(j);
                upstreamFailures.add(UpstreamFailureUtil._formatUpstreamTestFailure(jobVariant, object.toString()));
            }
        }
        return upstreamFailures;
    }

    private static JSONObject _getUpstreamJobFailuresJSONObject(TopLevelBuild topLevelBuild) throws IllegalStateException {
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get build properties", ioException);
        }
        String portalDirName = buildProperties.getProperty(JenkinsResultsParserUtil.combine("portal.dir[", topLevelBuild.getBranchName(), "]"));
        String baseGitRepositoryName = portalDirName.replaceAll("(?:.*)(liferay-portal.*)", "$1");
        GitWorkingDirectory gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(topLevelBuild.getBranchName(), (File)null, baseGitRepositoryName);
        List<String> buildResultJSONURLs = JenkinsResultsParserUtil.getBuildResultJsonURLs(topLevelBuild.getAcceptanceUpstreamJobURL(), 20);
        Collections.reverse(buildResultJSONURLs);
        for (String buildResultJSONURL : buildResultJSONURLs) {
            try {
                JSONArray failureBatchesJSONArray;
                buildResultJSONURL = buildResultJSONURL.replace("test-1-1/userContent/jobs/", "test-1-0/userContent/testResults/");
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(buildResultJSONURL = buildResultJSONURL.replace("build-result.json", "test.results.json"));
                String sha = jsonObject.getString("SHA");
                if (!gitWorkingDirectory.refContainsSHA("HEAD", sha) || (failureBatchesJSONArray = jsonObject.getJSONArray("failedBatches")).length() <= 0) continue;
                System.out.println("Downloading upstream test results from " + buildResultJSONURL);
                return jsonObject;
            }
            catch (IOException ioException) {
                System.out.println(ioException.toString());
            }
        }
        throw new IllegalStateException("Unable to find comparable upstream test results");
    }

    private static boolean _isBuildFailingInUpstreamJob(Build build) {
        String jobVariant = build.getJobVariant();
        if (jobVariant == null) {
            return false;
        }
        String result = build.getResult();
        if (result == null) {
            return false;
        }
        jobVariant = UpstreamFailureUtil._formatJobVariant(jobVariant);
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        for (String upstreamJobFailure : UpstreamFailureUtil._getUpstreamJobFailures("build", topLevelBuild)) {
            if (!upstreamJobFailure.equals(UpstreamFailureUtil._formatUpstreamBuildFailure(jobVariant, result))) continue;
            return true;
        }
        return false;
    }

    static {
        _upstreamJobFailuresJSONFile = new File(System.getenv("WORKSPACE"), "test.results.json");
    }
}

