/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.google.common.collect.Lists;
import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.FilePropagator;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.TopLevelBuildData;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public abstract class TopLevelBuildRunner<T extends TopLevelBuildData>
extends BaseBuildRunner<T> {
    private static final String _COMMAND_FILE_PROPAGATOR_CLEAN_UP = JenkinsResultsParserUtil.combine("find ", "/tmp/dist", "/*/* -maxdepth 1 -type d -mmin +", String.valueOf(1440), " -exec rm -frv {} \\;");
    private static final int _MILLIS_FILE_PROPAGATOR_EXPIRATION = 1440;
    private static final long _MILLIS_REPORT_GENERATION_INTERVAL = 300000L;
    private static final int _SECONDS_WAIT_FOR_INVOKED_JOB_DURATION = 30;
    private static final int _THREADS_FILE_PROPAGATOR_THREAD_SIZE = 1;
    private final List<BuildData> _downstreamBuildDataList = new ArrayList<BuildData>();
    private long _lastGeneratedReportTime = -1L;
    private final TopLevelBuild _topLevelBuild;

    @Override
    public void run() {
        this.validateBuildParameters();
        this.publishJenkinsReport();
        this.updateBuildDescription();
        this.setUpWorkspace();
        this.prepareInvocationBuildDataList();
        this.propagateBuildDatabaseToDistNodes();
        this.invokeDownstreamBuilds();
        this.propagateBuildDatabaseToUserContent();
        this.waitForDownstreamBuildsToComplete();
        this.publishJenkinsReport();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.publishJenkinsReport();
    }

    protected TopLevelBuildRunner(T topLevelBuildData) {
        super(topLevelBuildData);
        Build build = BuildFactory.newBuild(topLevelBuildData.getBuildURL(), null);
        if (!(build instanceof TopLevelBuild)) {
            throw new RuntimeException("Invalid build URL " + topLevelBuildData.getBuildURL());
        }
        this._topLevelBuild = (TopLevelBuild)build;
        topLevelBuildData.setInvocationTime(topLevelBuildData.getStartTime());
    }

    protected void addInvocationBuildData(BuildData buildData) {
        this._downstreamBuildDataList.add(buildData);
    }

    protected void failBuildRunner(String message) {
        this.failBuildRunner(message, null);
    }

    protected void failBuildRunner(String message, Exception exception) {
        TopLevelBuildData topLevelBuildData = (TopLevelBuildData)this.getBuildData();
        topLevelBuildData.setBuildDescription("<b>ERROR:</b> " + message);
        this.updateBuildDescription();
        if (exception == null) {
            throw new RuntimeException(message);
        }
        throw new RuntimeException(message, exception);
    }

    protected String getBuildParameter(String key) {
        TopLevelBuildData topLevelBuildData = (TopLevelBuildData)this.getBuildData();
        return topLevelBuildData.getBuildParameter(key);
    }

    protected Element getJenkinsReportElement() {
        return this._topLevelBuild.getJenkinsReportElement();
    }

    protected String getJobPropertyValue(String key) {
        JobProperty jobProperty = JobPropertyFactory.newJobProperty(key, this.getJob());
        return jobProperty.getValue();
    }

    protected TopLevelBuild getTopLevelBuild() {
        return this._topLevelBuild;
    }

    protected void invokeDownstreamBuilds() {
        for (BuildData downstreamBuildData : this._downstreamBuildDataList) {
            this._invokeDownstreamBuild(downstreamBuildData);
        }
    }

    protected abstract void prepareInvocationBuildDataList();

    protected void propagateBuildDatabaseToDistNodes() {
        if (!JenkinsResultsParserUtil.isCINode()) {
            return;
        }
        TopLevelBuildData topLevelBuildData = (TopLevelBuildData)this.getBuildData();
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        File buildDatabaseFile = buildDatabase.getBuildDatabaseFile();
        FilePropagator filePropagator = new FilePropagator(new String[]{buildDatabaseFile.getName()}, JenkinsResultsParserUtil.combine(topLevelBuildData.getHostname(), ":", buildDatabaseFile.getParent()), topLevelBuildData.getDistPath(), topLevelBuildData.getDistNodes());
        filePropagator.setCleanUpCommand(_COMMAND_FILE_PROPAGATOR_CLEAN_UP);
        filePropagator.start(1);
        ArrayList distNodes = Lists.newArrayList(topLevelBuildData.getDistNodes());
        distNodes.removeAll(filePropagator.getErrorSlaves());
        topLevelBuildData.setDistNodes(distNodes);
    }

    protected void propagateBuildDatabaseToUserContent() {
        if (!JenkinsResultsParserUtil.isCINode()) {
            return;
        }
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        this.publishToUserContentDir(buildDatabase.getBuildDatabaseFile());
    }

    protected void publishJenkinsReport() {
        this._updateBuildData();
        try {
            String jenkinsReportString = StringEscapeUtils.unescapeXml((String)Dom4JUtil.format(this.getJenkinsReportElement(), true));
            TopLevelBuildData topLevelBuildData = (TopLevelBuildData)this.getBuildData();
            File jenkinsReportFile = new File(topLevelBuildData.getWorkspaceDir(), "jenkins-report.html");
            JenkinsResultsParserUtil.write(jenkinsReportFile, jenkinsReportString);
            this.publishToUserContentDir(jenkinsReportFile);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    @Override
    protected void setUpWorkspace() {
        Workspace workspace = this.getWorkspace();
        workspace.setUp();
        workspace.synchronizeToGitHubDev();
    }

    protected void updateJenkinsReport() {
        if (!this._allBuildsAreRunning()) {
            this._lastGeneratedReportTime = -1L;
            return;
        }
        long currentTimeMillis = JenkinsResultsParserUtil.getCurrentTimeMillis();
        if (this._lastGeneratedReportTime == -1L) {
            this._lastGeneratedReportTime = currentTimeMillis;
            this.publishJenkinsReport();
            return;
        }
        if (this._lastGeneratedReportTime + 300000L > currentTimeMillis) {
            return;
        }
        this._lastGeneratedReportTime = currentTimeMillis;
        this.publishJenkinsReport();
    }

    protected abstract void validateBuildParameters();

    protected void waitForDownstreamBuildsToComplete() {
        while (true) {
            this._topLevelBuild.update();
            this.updateJenkinsReport();
            System.out.println(this._topLevelBuild.getStatusSummary());
            int completed = this._topLevelBuild.getDownstreamBuildCount("completed");
            int total = this._topLevelBuild.getDownstreamBuildCount(null);
            if (completed >= total) break;
            JenkinsResultsParserUtil.sleep(30000L);
        }
    }

    private boolean _allBuildsAreRunning() {
        ArrayList<Build> runningBuilds = new ArrayList<Build>();
        runningBuilds.addAll(this._topLevelBuild.getDownstreamBuilds("running"));
        runningBuilds.addAll(this._topLevelBuild.getDownstreamBuilds("completed"));
        List<Build> totalBuilds = this._topLevelBuild.getDownstreamBuilds(null);
        return runningBuilds.size() >= totalBuilds.size();
    }

    private BuildData _getDownstreamBuildData(Build downstreamBuild) {
        if (this._downstreamBuildDataList.isEmpty()) {
            return null;
        }
        String buildURL = downstreamBuild.getBuildURL();
        if (buildURL == null) {
            return null;
        }
        String runID = downstreamBuild.getParameterValue("RUN_ID");
        for (BuildData downstreamBuildData : this._downstreamBuildDataList) {
            if (!runID.equals(downstreamBuildData.getRunID())) continue;
            return downstreamBuildData;
        }
        return null;
    }

    private void _invokeBuild(String cohortName, String jobName, Map<String, String> invocationParameters) {
        Properties buildProperties;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        String invocationURL = JenkinsResultsParserUtil.getMostAvailableMasterURL(JenkinsResultsParserUtil.combine("http://", cohortName, ".liferay.com"), 1);
        StringBuilder sb = new StringBuilder();
        sb.append(invocationURL);
        sb.append("/job/");
        sb.append(jobName);
        sb.append("/buildWithParameters?token=");
        sb.append(buildProperties.getProperty("jenkins.authentication.token"));
        for (Map.Entry<String, String> invocationParameter : invocationParameters.entrySet()) {
            sb.append("&");
            sb.append(JenkinsResultsParserUtil.fixURL(invocationParameter.getKey()));
            sb.append("=");
            sb.append(JenkinsResultsParserUtil.fixURL(invocationParameter.getValue()));
        }
        this._topLevelBuild.addDownstreamBuilds(sb.toString());
    }

    private void _invokeDownstreamBuild(BuildData buildData) {
        TopLevelBuildData topLevelBuildData = (TopLevelBuildData)this.getBuildData();
        topLevelBuildData.addDownstreamBuildData(buildData);
        HashMap<String, String> invocationParameters = new HashMap<String, String>();
        invocationParameters.put("DIST_NODES", StringUtils.join(topLevelBuildData.getDistNodes(), (String)","));
        invocationParameters.put("DIST_PATH", topLevelBuildData.getDistPath());
        invocationParameters.put("JENKINS_GITHUB_URL", topLevelBuildData.getJenkinsGitHubURL());
        invocationParameters.put("RUN_ID", buildData.getRunID());
        invocationParameters.put("TOP_LEVEL_RUN_ID", topLevelBuildData.getRunID());
        buildData.setInvocationTime(JenkinsResultsParserUtil.getCurrentTimeMillis());
        this._invokeBuild(topLevelBuildData.getCohortName(), buildData.getJobName(), invocationParameters);
    }

    private void _updateBuildData() {
        TopLevelBuildData topLevelBuildData = (TopLevelBuildData)this.getBuildData();
        topLevelBuildData.setBuildDuration(JenkinsResultsParserUtil.getCurrentTimeMillis() - topLevelBuildData.getStartTime());
        topLevelBuildData.setBuildResult(this._topLevelBuild.getResult());
        topLevelBuildData.setBuildStatus(this._topLevelBuild.getStatus());
        for (Build downstreamBuild : this._topLevelBuild.getDownstreamBuilds(null)) {
            BuildData downstreamBuildData;
            String buildURL = downstreamBuild.getBuildURL();
            if (buildURL == null || (downstreamBuildData = this._getDownstreamBuildData(downstreamBuild)) == null) continue;
            downstreamBuildData.setBuildDuration(downstreamBuild.getDuration());
            downstreamBuildData.setBuildResult(downstreamBuild.getResult());
            downstreamBuildData.setBuildStatus(downstreamBuild.getStatus());
            downstreamBuildData.setBuildURL(buildURL);
        }
    }
}

