/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.testray.TestrayAttachment;
import com.liferay.jenkins.results.parser.testray.TestrayBuild;
import com.liferay.jenkins.results.parser.testray.TestrayCaseResult;
import com.liferay.jenkins.results.parser.testray.TestrayFactory;
import com.liferay.jenkins.results.parser.testray.TestrayProject;
import com.liferay.jenkins.results.parser.testray.TestrayRoutine;
import com.liferay.jenkins.results.parser.testray.TestrayServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestHistoryMap
extends HashMap<Map<String, String>, TestHistory> {
    private static final long _MAXIMUM_TEST_DURATION = 0x6DDD00L;
    private static final List<String> _excludedTestNameRegexes = new ArrayList<String>(){
        {
            Properties buildProperties = null;
            try {
                buildProperties = JenkinsResultsParserUtil.getBuildProperties();
                String excludedTestNames = buildProperties.getProperty("flaky.test.report.test.name.excludes");
                Collections.addAll(this, excludedTestNames.split("\\s*,\\s*"));
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to get build properties", ioException);
            }
        }
    };
    private static final Pattern _testrayLogPattern = Pattern.compile("test[0-9-]+\\/[0-9]+\\/.+?\\/[0-9]+\\/(?<jobVariant>.+?)\\/.*");
    private int _minimumStatusChanges = 3;
    private long _minimumTestDuration = 60000L;

    public TestHistoryMap(String jenkinsJobURL, int maxBuildCount) {
        this.populate(jenkinsJobURL, maxBuildCount);
    }

    public TestHistoryMap(String testrayServerName, String projectName, String routineName, int maxBuildCount) {
        this.populate(testrayServerName, projectName, routineName, maxBuildCount);
    }

    public void populate(JSONObject buildResultJSONObject) {
        JSONArray batchResultsJSONArray = buildResultJSONObject.getJSONArray("batchResults");
        for (int i = 0; i < batchResultsJSONArray.length(); ++i) {
            JSONObject batchResultJSONObject = batchResultsJSONArray.getJSONObject(i);
            String jobVariant = batchResultJSONObject.getString("jobVariant");
            jobVariant = jobVariant.replaceAll("(.*)/.*", "$1");
            JSONArray testResultsJSONArray = batchResultJSONObject.getJSONArray("testResults");
            for (int j = 0; j < testResultsJSONArray.length(); ++j) {
                JSONObject testResultJSONObject = testResultsJSONArray.getJSONObject(j);
                String name = testResultJSONObject.optString("name");
                String status = testResultJSONObject.optString("status");
                status = status.replace("REGRESSION", "FAILED");
                status = status.replace("FIXED", "PASSED");
                if (name.startsWith("PortalLogAssertorTest") || name.startsWith("JenkinsLogAsserterTest") || status.equals("SKIPPED")) continue;
                String buildURL = testResultJSONObject.optString("buildURL");
                long duration = testResultJSONObject.optLong("duration");
                String errorDetails = testResultJSONObject.optString("errorDetails");
                this.put(name, jobVariant, buildURL, duration, errorDetails, status);
            }
        }
    }

    public void populate(String jenkinsJobURL, int maxBuildCount) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        List<String> buildResultJsonURLs = JenkinsResultsParserUtil.getBuildResultJsonURLs(jenkinsJobURL, maxBuildCount);
        Map<String, JSONObject> buildResultJSONObjects = JenkinsResultsParserUtil.getBuildResultJSONObjects(buildResultJsonURLs);
        for (String buildResultJsonURL : buildResultJsonURLs) {
            if (!buildResultJSONObjects.containsKey(buildResultJsonURL)) continue;
            this.populate(buildResultJSONObjects.get(buildResultJsonURL));
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("Test history map populated in ", JenkinsResultsParserUtil.toDurationString(duration)));
    }

    public void populate(String testrayServerName, String projectName, String routineName, int maxBuildCount) {
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        TestrayServer testrayServer = TestrayFactory.newTestrayServer(testrayServerName);
        TestrayProject testrayProject = testrayServer.getTestrayProjectByName(projectName);
        TestrayRoutine testrayRoutine = testrayProject.getTestrayRoutineByName(routineName);
        for (TestrayBuild testrayBuild : testrayRoutine.getTestrayBuilds(maxBuildCount, new String[0])) {
            for (TestrayCaseResult testrayCaseResult : testrayBuild.getTestrayCaseResults()) {
                String name = testrayCaseResult.getName();
                String jobVariant = null;
                List<TestrayAttachment> testrayAttachments = testrayCaseResult.getTestrayAttachments();
                if (!testrayAttachments.isEmpty()) {
                    for (TestrayAttachment testrayAttachment : testrayAttachments) {
                        String testrayAttachmentKey = testrayAttachment.getKey();
                        Matcher matcher = _testrayLogPattern.matcher(testrayAttachmentKey);
                        if (!matcher.find()) continue;
                        jobVariant = matcher.group("jobVariant");
                    }
                }
                TestrayCaseResult.Status status = testrayCaseResult.getStatus();
                this.put(name, jobVariant, String.valueOf(testrayCaseResult.getURL()), 0L, testrayCaseResult.getErrors(), status.getName());
            }
        }
        long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("Test history map populated in ", JenkinsResultsParserUtil.toDurationString(duration)));
    }

    public void put(String testName, String batchName, String buildURL, long duration, String errorSnippet, String status) {
        for (String excludedTestNameRegex : _excludedTestNameRegexes) {
            if (!testName.matches(".*" + excludedTestNameRegex + ".*")) continue;
            return;
        }
        if (this.containsKey(Collections.singletonMap(testName, batchName))) {
            TestHistory testHistory = (TestHistory)this.get(Collections.singletonMap(testName, batchName));
            testHistory.add(buildURL, duration, errorSnippet, status);
            return;
        }
        this.put(Collections.singletonMap(testName, batchName), new TestHistory(testName, batchName, buildURL, duration, errorSnippet, status));
    }

    public void setMinimumStatusChanges(int minimumStatusChanges) {
        this._minimumStatusChanges = minimumStatusChanges;
    }

    public void setMinimumTestDuration(long minimumTestDuration) {
        this._minimumTestDuration = minimumTestDuration;
    }

    public void writeDurationDataJavaScriptFile(String filePath, String batchNameRegex) throws IOException {
        JSONArray durationDataJSONArray = new JSONArray();
        durationDataJSONArray.put((Object)new String[]{"Name", "Batch Type", "Results", "Duration", "Average Duration"});
        for (TestHistory testHistory : this.values()) {
            String batchName = testHistory.getBatchName();
            if (!batchName.matches(batchNameRegex) || testHistory.getAverageDuration() <= this._minimumTestDuration) continue;
            durationDataJSONArray.put((Object)testHistory.toDurationJSONArray());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var durationData = ");
        sb.append(durationDataJSONArray.toString());
        sb.append(";\nvar durationDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    public void writeFlakyTestDataJavaScriptFile(String filePath) throws IOException {
        JSONArray flakyTestDataJSONArray = new JSONArray();
        flakyTestDataJSONArray.put((Object)new String[]{"Name", "Batch Type", "Results", "Status Changes"});
        for (TestHistory testHistory : this.values()) {
            if (!testHistory.isFlaky()) continue;
            flakyTestDataJSONArray.put((Object)testHistory.toStatusJSONArray());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("var flakyTestData = ");
        sb.append(flakyTestDataJSONArray.toString());
        sb.append(";\nvar flakyTestDataGeneratedDate = new Date(");
        sb.append(JenkinsResultsParserUtil.getCurrentTimeMillis());
        sb.append(");");
        JenkinsResultsParserUtil.write(filePath, sb.toString());
    }

    public class TestHistory {
        private final String _batchName;
        private final String _name;
        private int _statusChanges;
        private final List<TestHistoryEntry> _testHistoryEntries = new ArrayList<TestHistoryEntry>();

        public TestHistory(String name, String batchName, String buildURL, long duration, String errorSnippet, String status) {
            this._name = name;
            this._batchName = batchName;
            this.add(buildURL, duration, errorSnippet, status);
        }

        public void add(String buildURL, long duration, String errorSnippet, String status) {
            this._testHistoryEntries.add(new TestHistoryEntry(buildURL, duration, errorSnippet, status));
        }

        public long getAverageDuration() {
            long count = 0L;
            long totalDuration = 0L;
            for (TestHistoryEntry testHistoryEntry : this._testHistoryEntries) {
                long duration = testHistoryEntry.getDuration();
                if (duration > 0x6DDD00L) continue;
                ++count;
                totalDuration += duration;
            }
            if (count == 0L) {
                return 0L;
            }
            return totalDuration / count;
        }

        public String getBatchName() {
            return this._batchName;
        }

        public String getName() {
            return this._name;
        }

        public List<String> getStatuses() {
            ArrayList<String> statuses = new ArrayList<String>();
            for (TestHistoryEntry testHistoryEntry : this._testHistoryEntries) {
                statuses.add(testHistoryEntry.getStatus());
            }
            return statuses;
        }

        public boolean isFlaky() {
            String lastStatus = null;
            for (TestHistoryEntry testHistoryEntry : this._testHistoryEntries) {
                String status = testHistoryEntry.getStatus();
                if (lastStatus == null) {
                    lastStatus = status;
                    continue;
                }
                if (lastStatus.equals(status)) continue;
                lastStatus = status;
                ++this._statusChanges;
            }
            return this._statusChanges >= TestHistoryMap.this._minimumStatusChanges;
        }

        public JSONArray toDurationJSONArray() {
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)this.getName());
            jsonArray.put((Object)this.getBatchName());
            JSONArray durationJSONArray = new JSONArray();
            JSONArray statusesJSONArray = new JSONArray();
            long totalDuration = 0L;
            for (TestHistoryEntry testHistoryEntry : this._testHistoryEntries) {
                long duration = testHistoryEntry.getDuration();
                if (duration > 0x6DDD00L) continue;
                totalDuration += duration;
                durationJSONArray.put(duration);
                JSONArray statusJSONArray = new JSONArray();
                statusJSONArray.put((Object)testHistoryEntry.getStatus());
                statusJSONArray.put((Object)testHistoryEntry.getBuildURL());
                statusesJSONArray.put((Object)statusJSONArray);
            }
            jsonArray.put((Object)statusesJSONArray);
            jsonArray.put((Object)durationJSONArray);
            jsonArray.put(this.getAverageDuration());
            return jsonArray;
        }

        public JSONArray toStatusJSONArray() {
            JSONArray jsonArray = new JSONArray();
            jsonArray.put((Object)this.getName());
            jsonArray.put((Object)this.getBatchName());
            JSONArray statusesJSONArray = new JSONArray();
            for (TestHistoryEntry testHistoryEntry : this._testHistoryEntries) {
                JSONArray statusJSONArray = new JSONArray();
                statusJSONArray.put((Object)testHistoryEntry.getStatus());
                statusJSONArray.put((Object)testHistoryEntry.getBuildURL());
                statusesJSONArray.put((Object)statusJSONArray);
            }
            jsonArray.put((Object)statusesJSONArray);
            jsonArray.put(this._statusChanges);
            return jsonArray;
        }

        private class TestHistoryEntry {
            private final String _buildURL;
            private final long _duration;
            private final String _errorSnippet;
            private final String _status;

            public TestHistoryEntry(String buildURL, long duration, String errorSnippet, String status) {
                this._buildURL = buildURL;
                this._duration = duration;
                this._errorSnippet = errorSnippet;
                this._status = status;
            }

            public String getBuildURL() {
                return this._buildURL;
            }

            public long getDuration() {
                return this._duration;
            }

            public String getErrorSnippet() {
                return this._errorSnippet;
            }

            public String getStatus() {
                return this._status;
            }
        }
    }
}

