/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.amazonaws.util.StringUtils;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;

public class TGZUtil {
    public static boolean debug = false;
    private static final int _CHARS_BUFFER_SIZE = 8192;

    public static void archive(File sourceFile, File archiveFile) throws IOException {
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("Unable to find " + sourceFile);
        }
        File parentDir = archiveFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(archiveFile);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
             GzipCompressorOutputStream gzipCompressorOutputStream = new GzipCompressorOutputStream((OutputStream)bufferedOutputStream);
             TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream((OutputStream)gzipCompressorOutputStream);){
            tarArchiveOutputStream.setBigNumberMode(2);
            tarArchiveOutputStream.setLongFileMode(3);
            if (sourceFile.isFile()) {
                TGZUtil._archiveFile(sourceFile.getParentFile(), sourceFile, (ArchiveOutputStream)tarArchiveOutputStream);
            } else {
                TGZUtil._archiveDir(sourceFile.getParentFile(), sourceFile, (ArchiveOutputStream)tarArchiveOutputStream);
            }
            tarArchiveOutputStream.flush();
            tarArchiveOutputStream.finish();
        }
    }

    public static void unarchive(File archiveFile, File destinationDir) throws IOException {
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        try (FileInputStream fileInputStream = new FileInputStream(archiveFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
             GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)bufferedInputStream);
             TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)gzipCompressorInputStream);){
            TarArchiveEntry tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
            while (tarArchiveEntry != null) {
                if (tarArchiveInputStream.canReadEntryData((ArchiveEntry)tarArchiveEntry)) {
                    if (tarArchiveEntry.isDirectory()) {
                        TGZUtil._unarchiveDir(destinationDir, tarArchiveEntry);
                    } else {
                        TGZUtil._unarchiveFile(destinationDir, tarArchiveEntry, tarArchiveInputStream);
                    }
                } else {
                    System.out.println("Unable to read " + tarArchiveEntry.getName());
                }
                tarArchiveEntry = tarArchiveInputStream.getNextTarEntry();
            }
        }
    }

    private static void _archiveDir(File sourceRootDir, File dir, ArchiveOutputStream archiveOutputStream) throws IOException {
        if (debug) {
            System.out.println("Archiving " + dir);
        }
        TGZUtil._archiveFile(sourceRootDir, dir, archiveOutputStream);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile()) {
                TGZUtil._archiveFile(sourceRootDir, file, archiveOutputStream);
                continue;
            }
            TGZUtil._archiveDir(sourceRootDir, file, archiveOutputStream);
        }
    }

    private static void _archiveFile(File sourceRootDir, File file, ArchiveOutputStream archiveOutputStream) throws IOException {
        String filePath;
        String archiveEntryName;
        ArchiveEntry archiveEntry;
        if (debug) {
            System.out.println("Archiving " + file);
        }
        if (!((archiveEntry = archiveOutputStream.createArchiveEntry(file, archiveEntryName = (filePath = JenkinsResultsParserUtil.getCanonicalPath(file)).replace(JenkinsResultsParserUtil.getCanonicalPath(sourceRootDir) + "/", ""))) instanceof TarArchiveEntry)) {
            throw new IOException("Invalid archive entry");
        }
        TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)archiveEntry;
        tarArchiveEntry.setMode(TGZUtil._getPosixIntegerValue(Files.getPosixFilePermissions(file.toPath(), new LinkOption[0])).intValue());
        archiveOutputStream.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
        if (file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                IOUtils.copy((InputStream)fileInputStream, (OutputStream)archiveOutputStream);
            }
        }
        archiveOutputStream.closeArchiveEntry();
    }

    private static Set<PosixFilePermission> _getPosixFilePermissions(Integer posixIntegerValue) {
        String binaryString = Integer.toBinaryString(posixIntegerValue);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < binaryString.length(); ++i) {
            char c = binaryString.charAt(i);
            if (c == '0') {
                sb.append("-");
                continue;
            }
            int accessIndex = i % 3;
            if (accessIndex == 0) {
                sb.append("r");
                continue;
            }
            if (accessIndex == 1) {
                sb.append("w");
                continue;
            }
            if (accessIndex != 2) continue;
            sb.append("x");
        }
        try {
            return PosixFilePermissions.fromString(sb.toString());
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid POSIX integer value " + posixIntegerValue, exception);
        }
    }

    private static Integer _getPosixIntegerValue(Set<PosixFilePermission> posixFilePermissions) {
        Integer total = 0;
        for (PosixFilePermission posixFilePermission : posixFilePermissions) {
            if (posixFilePermission == null) continue;
            PosixIntegerValue posixIntegerValue = PosixIntegerValue.valueOf(StringUtils.upperCase((String)posixFilePermission.toString()));
            total = total + posixIntegerValue.getValue();
        }
        return total;
    }

    private static void _unarchiveDir(File destinationRootDir, TarArchiveEntry tarArchiveEntry) {
        File dir = new File(destinationRootDir, tarArchiveEntry.getName());
        if (debug) {
            System.out.println("Unarchiving " + dir);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private static void _unarchiveFile(File destinationRootDir, TarArchiveEntry tarArchiveEntry, TarArchiveInputStream tarArchiveInputStream) throws IOException {
        File parentDir;
        File file = new File(destinationRootDir, tarArchiveEntry.getName());
        if (debug) {
            System.out.println("Unarchiving " + file);
        }
        if (!(parentDir = file.getParentFile()).exists()) {
            parentDir.mkdirs();
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)fileOutputStream);
        }
        Files.setPosixFilePermissions(file.toPath(), TGZUtil._getPosixFilePermissions(tarArchiveEntry.getMode()));
    }

    public static enum PosixIntegerValue {
        GROUP_EXECUTE(8),
        GROUP_READ(32),
        GROUP_WRITE(16),
        OTHERS_EXECUTE(1),
        OTHERS_READ(4),
        OTHERS_WRITE(2),
        OWNER_EXECUTE(64),
        OWNER_READ(256),
        OWNER_WRITE(128);

        private final Integer _value;

        public Integer getValue() {
            return this._value;
        }

        private PosixIntegerValue(Integer value) {
            this._value = value;
        }
    }
}

