/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import org.json.JSONObject;

public class SubrepositoryWorkspace
extends PortalWorkspace {
    private String _portalUpstreamBranchName;

    @Override
    public PortalWorkspaceGitRepository getPortalWorkspaceGitRepository() {
        String directoryName;
        WorkspaceGitRepository portalWorkspaceGitRepository;
        if (this._portalUpstreamBranchName == null) {
            WorkspaceGitRepository workspaceGitRepository = this.getPrimaryWorkspaceGitRepository();
            this._portalUpstreamBranchName = workspaceGitRepository.getUpstreamBranchName();
        }
        String repositoryName = "liferay-portal";
        if (!this._portalUpstreamBranchName.equals("master")) {
            repositoryName = repositoryName + "-ee";
        }
        if (!((portalWorkspaceGitRepository = this.getWorkspaceGitRepository(directoryName = JenkinsResultsParserUtil.getGitDirectoryName(repositoryName, this._portalUpstreamBranchName))) instanceof PortalWorkspaceGitRepository)) {
            throw new RuntimeException("The portal workspace Git repository is not set");
        }
        return (PortalWorkspaceGitRepository)portalWorkspaceGitRepository;
    }

    public void setPortalUpstreamBranchName(String portalUpstreamBranchName) {
        this._portalUpstreamBranchName = portalUpstreamBranchName;
    }

    protected SubrepositoryWorkspace(JSONObject jsonObject) {
        super(jsonObject);
    }

    protected SubrepositoryWorkspace(String primaryRepositoryName, String upstreamBranchName) {
        super(primaryRepositoryName, upstreamBranchName);
    }

    protected SubrepositoryWorkspace(String primaryRepositoryName, String upstreamBranchName, String jobName) {
        super(primaryRepositoryName, upstreamBranchName, jobName);
    }

    @Override
    protected void updateOSBAsahModule() {
        WorkspaceGitRepository primaryWorkspaceGitRepository = this.getPrimaryWorkspaceGitRepository();
        String repositoryName = primaryWorkspaceGitRepository.getName();
        if (repositoryName.equals("com-liferay-osb-asah-private")) {
            this.copyOSBAsahRepositoryToModule();
        }
    }
}

