/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

public abstract class Retryable<T> {
    private boolean _exceptionOnFail;
    private int _maxRetries;
    private int _retryPeriod;
    private boolean _verbose;

    public Retryable() {
        this(5, 30, true);
    }

    public Retryable(boolean exceptionOnFail, int maxRetries, int retryPeriod, boolean verbose) {
        this._exceptionOnFail = exceptionOnFail;
        this._maxRetries = maxRetries;
        this._retryPeriod = retryPeriod;
        this._verbose = verbose;
    }

    public Retryable(int maxRetries, int retryPeriod, boolean verbose) {
        this(true, maxRetries, retryPeriod, verbose);
    }

    public abstract T execute();

    public final T executeWithRetries() {
        int retryCount = 0;
        while (true) {
            try {
                return this.execute();
            }
            catch (Exception exception) {
                ++retryCount;
                if (this._verbose) {
                    System.out.println("An error has occurred: " + exception);
                }
                if (this._maxRetries >= 0 && retryCount > this._maxRetries) {
                    if (this._exceptionOnFail) {
                        throw exception;
                    }
                    return null;
                }
                this.sleep(this._retryPeriod * 1000);
                if (!this._verbose) continue;
                System.out.println("Retry attempt " + retryCount + " of " + this._maxRetries);
                continue;
            }
            break;
        }
    }

    public void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }
}

