/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildRunner;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class QAWebsitesControllerBuildRunner
extends BaseBuildRunner<BuildData> {
    private static final Integer _CONTROLLER_BUILD_TIMEOUT_DEFAULT = 86400000;
    private static final Pattern _buildDescriptionPattern = Pattern.compile("<a href=\"(?<buildURL>[^\"]+)\">Build URL</a>");
    private static final Pattern _buildURLPattern = Pattern.compile("https://(?<masterHostname>test-\\d+-\\d+)\\.?.*/job/(?<jobName>[^/]+)/(?<buildNumber>\\d+)/?");
    private static final Pattern _gitHubURLPattern = Pattern.compile("https://github.com/(?<username>[^/]+)/(?<repository>[^/]+)/(commits|tree)/(?<branch>[^/]+)");
    private Workspace _workspace;

    @Override
    public Workspace getWorkspace() {
        if (this._workspace != null) {
            return this._workspace;
        }
        this._workspace = WorkspaceFactory.newWorkspace();
        return this._workspace;
    }

    @Override
    public void run() {
        this.retirePreviousBuilds();
        if (this._allowConcurrentBuilds() || this._expirePreviousBuild()) {
            super.run();
            return;
        }
        Object buildData = this.getBuildData();
        if (this._previousBuildHasExistingInvocation()) {
            buildData.setBuildDescription("<strong>SKIPPED</strong> - Job was already invoked");
            super.updateBuildDescription();
            return;
        }
        if (this._previousBuildHasRunningInvocation()) {
            buildData.setBuildDescription("<strong>SKIPPED</strong> - Job is already running");
            super.updateBuildDescription();
            return;
        }
        this.invokeBuild();
        this.keepJenkinsBuild(true);
    }

    @Override
    public void tearDown() {
    }

    protected QAWebsitesControllerBuildRunner(BuildData buildData) {
        super(buildData);
    }

    protected String getJobInvocationURL() {
        Object buildData = this.getBuildData();
        String invocationMasterHostname = buildData.getBuildParameter("INVOCATION_MASTER_HOSTNAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(invocationMasterHostname)) {
            String cohortName = buildData.getCohortName();
            String mostAvailableMasterURL = JenkinsResultsParserUtil.getMostAvailableMasterURL("http://" + cohortName + ".liferay.com", 1);
            invocationMasterHostname = mostAvailableMasterURL.replaceAll("https?://([^\\.]+)(.liferay.com.*)?", "\u0001");
        }
        String jobName = buildData.getJobName();
        return JenkinsResultsParserUtil.combine("http://", invocationMasterHostname, "/job/", jobName.replaceAll("-controller\\(.*\\)", ""));
    }

    protected void invokeBuild() {
        StringBuilder sb = new StringBuilder();
        String jobInvocationURL = this.getJobInvocationURL();
        sb.append(jobInvocationURL);
        sb.append("/buildWithParameters?");
        sb.append("token=");
        try {
            sb.append(JenkinsResultsParserUtil.getBuildProperty("jenkins.authentication.token"));
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        Object buildData = this.getBuildData();
        HashMap<String, String> invocationParameters = new HashMap<String, String>();
        invocationParameters.put("CONTROLLER_BUILD_URL", buildData.getBuildURL());
        invocationParameters.put("JENKINS_GITHUB_BRANCH_NAME", this._getGitHubBranchName("JENKINS_GITHUB_URL"));
        invocationParameters.put("JENKINS_GITHUB_BRANCH_USERNAME", this._getGitHubBranchUsername("JENKINS_GITHUB_URL"));
        invocationParameters.put("TEST_QA_WEBSITES_BRANCH_NAME", this._getGitHubBranchName("QA_WEBSITES_GITHUB_URL"));
        invocationParameters.put("TEST_QA_WEBSITES_BRANCH_USERNAME", this._getGitHubBranchUsername("QA_WEBSITES_GITHUB_URL"));
        Map<String, String> buildParameters = buildData.getBuildParameters();
        for (Map.Entry<String, String> entry : buildParameters.entrySet()) {
            String buildParameterValue = entry.getValue();
            if (JenkinsResultsParserUtil.isNullOrEmpty(buildParameterValue)) continue;
            invocationParameters.put(entry.getKey(), buildParameterValue);
        }
        invocationParameters.putAll(buildData.getBuildParameters());
        for (Map.Entry<String, String> entry : invocationParameters.entrySet()) {
            String invocationParameterValue = entry.getValue();
            if (JenkinsResultsParserUtil.isNullOrEmpty(invocationParameterValue)) continue;
            sb.append("&");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(invocationParameterValue);
        }
        try {
            System.out.println(sb.toString());
            JenkinsResultsParserUtil.toString(sb.toString());
            sb = new StringBuilder();
            sb.append("<a href=\"");
            sb.append(JenkinsResultsParserUtil.getRemoteURL(jobInvocationURL));
            sb.append("\"><strong>IN QUEUE</strong></a>");
            buildData.setBuildDescription(sb.toString());
            this.updateBuildDescription();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private boolean _allowConcurrentBuilds() {
        String allowConcurrentBuildsString = System.getenv("ALLOW_CONCURRENT_BUILDS");
        if (allowConcurrentBuildsString == null) {
            return false;
        }
        allowConcurrentBuildsString = allowConcurrentBuildsString.toLowerCase();
        return (allowConcurrentBuildsString = allowConcurrentBuildsString.trim()).equals("true");
    }

    private boolean _expirePreviousBuild() {
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            long timestamp;
            String description = previousBuildJSONObject.optString("description", "");
            if (!description.contains("IN PROGRESS") && !description.contains("IN QUEUE") || (timestamp = previousBuildJSONObject.optLong("timestamp", 0L)) == 0L) continue;
            long inProgressBuildDuration = JenkinsResultsParserUtil.getCurrentTimeMillis() - timestamp;
            System.out.println(JenkinsResultsParserUtil.combine("In progress build started ", JenkinsResultsParserUtil.toDurationString(inProgressBuildDuration), " ago"));
            if (inProgressBuildDuration < this._getControllerBuildTimeout()) {
                return false;
            }
            Matcher matcher = _buildURLPattern.matcher(previousBuildJSONObject.getString("url"));
            if (!matcher.find()) {
                return false;
            }
            description = description.replace("IN PROGRESS", "EXPIRE");
            description = description.replace("IN QUEUE", "EXPIRE");
            JenkinsResultsParserUtil.updateBuildDescription(description, previousBuildJSONObject.getInt("number"), matcher.group("jobName"), matcher.group("masterHostname"));
            return true;
        }
        return false;
    }

    private long _getControllerBuildTimeout() {
        try {
            Object buildData = this.getBuildData();
            String controllerBuildTimeout = JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "controller.build.timeout", buildData.getJobName());
            if (!JenkinsResultsParserUtil.isNullOrEmpty(controllerBuildTimeout)) {
                return Long.parseLong(controllerBuildTimeout) * 1000L;
            }
            return _CONTROLLER_BUILD_TIMEOUT_DEFAULT.intValue();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private String _getGitHubBranchName(String parameterName) {
        Object buildData = this.getBuildData();
        String gitHubURL = buildData.getBuildParameter(parameterName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return null;
        }
        Matcher matcher = _gitHubURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("branch");
    }

    private String _getGitHubBranchUsername(String parameterName) {
        Object buildData = this.getBuildData();
        String gitHubURL = buildData.getBuildParameter(parameterName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            return null;
        }
        Matcher matcher = _gitHubURLPattern.matcher(gitHubURL);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group("username");
    }

    private boolean _previousBuildHasExistingInvocation() {
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            String description = previousBuildJSONObject.optString("description", "");
            if (!description.contains("IN QUEUE")) continue;
            return true;
        }
        return false;
    }

    private boolean _previousBuildHasRunningInvocation() {
        for (JSONObject previousBuildJSONObject : this.getPreviousBuildJSONObjects()) {
            Matcher buildURLMatcher;
            String description = previousBuildJSONObject.optString("description", "");
            if (!description.contains("IN PROGRESS") || !(buildURLMatcher = _buildDescriptionPattern.matcher(description)).find()) continue;
            String buildURL = buildURLMatcher.group("buildURL");
            try {
                JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "/api/json?tree=result"));
                Object result = jsonObject.get("result");
                if (result.equals(JSONObject.NULL)) {
                    return true;
                }
                JSONObject injectedEnvVarsJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(previousBuildJSONObject.getString("url") + "/injectedEnvVars/api/json"));
                JSONObject envMapJSONObject = injectedEnvVarsJSONObject.getJSONObject("envMap");
                StringBuilder sb = new StringBuilder();
                sb.append("<strong style=\"color: red\">FAILURE</strong> - ");
                sb.append(buildURLMatcher.group());
                JenkinsResultsParserUtil.updateBuildDescription(sb.toString(), Integer.valueOf(envMapJSONObject.getString("BUILD_NUMBER")), envMapJSONObject.getString("JOB_NAME"), envMapJSONObject.getString("HOSTNAME"));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        return false;
    }
}

