/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PullRequest;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;

public class PullRequestFactory {
    private static final int _MAX_CACHED_PULL_REQUESTS = 25;
    private static final Map<String, PullRequest> _pullRequests = new LinkedHashMap<String, PullRequest>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, PullRequest> eldest) {
            return this.size() > 25;
        }
    };

    public static PullRequest newPullRequest(JSONObject jsonObject) {
        String gitHubURL = jsonObject.optString("html_url");
        if (JenkinsResultsParserUtil.isNullOrEmpty(gitHubURL)) {
            throw new RuntimeException("Invalid Pull Request JSONObject");
        }
        PullRequest pullRequest = _pullRequests.get(gitHubURL);
        if (pullRequest != null) {
            return pullRequest;
        }
        pullRequest = new PullRequest(jsonObject);
        _pullRequests.put(gitHubURL, pullRequest);
        return pullRequest;
    }

    public static PullRequest newPullRequest(String gitHubURL) {
        return PullRequestFactory.newPullRequest(gitHubURL, null);
    }

    public static PullRequest newPullRequest(String gitHubURL, Build build) {
        PullRequest pullRequest = _pullRequests.get(gitHubURL);
        if (pullRequest != null) {
            return pullRequest;
        }
        BuildDatabase buildDatabase = null;
        if (build != null && (buildDatabase = BuildDatabaseUtil.getBuildDatabase(build)).hasPullRequest(gitHubURL)) {
            pullRequest = buildDatabase.getPullRequest(gitHubURL);
            _pullRequests.put(gitHubURL, pullRequest);
            return pullRequest;
        }
        pullRequest = new PullRequest(gitHubURL);
        _pullRequests.put(gitHubURL, pullRequest);
        if (buildDatabase != null) {
            buildDatabase.putPullRequest(gitHubURL, pullRequest);
        }
        return pullRequest;
    }
}

