/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseTopLevelBuildData;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalBuildData;
import org.json.JSONObject;

public class PortalTopLevelBuildData
extends BaseTopLevelBuildData
implements PortalBuildData {
    private static final String[] _REQUIRED_KEYS = new String[]{"portal_github_url", "portal_upstream_branch_name"};
    private static final String _TYPE = "portal_top_level";

    public static boolean isValidJSONObject(JSONObject jsonObject) {
        return PortalTopLevelBuildData.isValidJSONObject(jsonObject, _TYPE);
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        String portalUpstreamBranchName = this.getPortalUpstreamBranchName();
        if (portalUpstreamBranchName.equals("master") || portalUpstreamBranchName.startsWith("7")) {
            return Job.BuildProfile.DXP;
        }
        return Job.BuildProfile.PORTAL;
    }

    @Override
    public String getPortalBranchSHA() {
        return this.getString("portal_branch_sha");
    }

    @Override
    public String getPortalGitHubBranchName() {
        return this.getGitHubBranchName(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalGitHubRepositoryName() {
        return this.getGitHubRepositoryName(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalGitHubURL() {
        return this.getString("portal_github_url");
    }

    @Override
    public String getPortalGitHubUsername() {
        return this.getGitHubUsername(this.getPortalGitHubURL());
    }

    @Override
    public String getPortalUpstreamBranchName() {
        return this.getString("portal_upstream_branch_name");
    }

    @Override
    public void setPortalBranchSHA(String portalBranchSHA) {
        this.put("portal_branch_sha", portalBranchSHA);
    }

    @Override
    public void setPortalGitHubURL(String portalGitHubURL) {
        this.put("portal_github_url", portalGitHubURL);
    }

    @Override
    public void setPortalUpstreamBranchName(String portalUpstreamBranchName) {
        this.put("portal_upstream_branch_name", portalUpstreamBranchName);
    }

    protected PortalTopLevelBuildData(String runID, String jobName, String buildURL) {
        super(runID, jobName, buildURL);
        this.setPortalGitHubURL(this._getPortalGitHubURL());
        this.setPortalUpstreamBranchName(this._getPortalUpstreamBranchName());
        this.validateKeys(_REQUIRED_KEYS);
    }

    @Override
    protected String getType() {
        return _TYPE;
    }

    private String _getPortalGitHubURL() {
        String portalGitHubURL = this.optString("portal_github_url");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL)) {
            return portalGitHubURL;
        }
        return "https://github.com/liferay/liferay-portal/tree/master";
    }

    private String _getPortalUpstreamBranchName() {
        String portalUpstreamBranchName = this.optString("portal_upstream_branch_name");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
            return portalUpstreamBranchName;
        }
        return "master";
    }
}

