/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PortalReleasePortalTopLevelBuild
extends PortalTopLevelBuild
implements PortalWorkspaceBuild {
    private static final Pattern _pattern = Pattern.compile("(?<major>\\d)\\.(?<minor>\\d)\\.(?<fix>\\d+)");
    private PortalRelease _portalRelease;

    public PortalReleasePortalTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBaseGitRepositoryName() {
        String branchName = this.getBranchName();
        if (branchName.equals("master")) {
            return "liferay-portal";
        }
        return "liferay-portal-ee";
    }

    @Override
    public String getBranchName() {
        String portalBranchName = this.getParameterValue("TEST_PORTAL_BRANCH_NAME");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalBranchName)) {
            return portalBranchName;
        }
        PortalRelease portalRelease = this.getPortalRelease();
        String portalVersion = portalRelease.getPortalVersion();
        Matcher matcher = _pattern.matcher(portalVersion);
        if (!matcher.find()) {
            throw new RuntimeException("Invalid portal version: " + portalVersion);
        }
        return JenkinsResultsParserUtil.combine(matcher.group("major"), ".", matcher.group("minor"), ".x");
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this._portalRelease != null) {
            return this._portalRelease;
        }
        String tomcatURLString = this.getParameterValue("TEST_PORTAL_RELEASE_TOMCAT_URL");
        try {
            String toolsURLString;
            String sqlURLString;
            String portalWarURLString;
            String osgiURLString;
            if (JenkinsResultsParserUtil.isNullOrEmpty(tomcatURLString)) {
                try {
                    this._portalRelease = new PortalRelease(new URL(this.getUserContentURL() + "/bundles"), JenkinsResultsParserUtil.getProperty(JenkinsResultsParserUtil.getBuildProperties(), "portal.latest.bundle.version", this.getParameterValue("TEST_PORTAL_BRANCH_NAME")));
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            } else {
                URL portalReleaseTomcatURL = new URL(tomcatURLString);
                this._portalRelease = new PortalRelease(portalReleaseTomcatURL);
            }
            String dependenciesURLString = this.getParameterValue("TEST_PORTAL_RELEASE_DEPENDENCIES_URL");
            if (this._isURL(dependenciesURLString)) {
                this._portalRelease.setDependenciesURL(new URL(dependenciesURLString));
            }
            if (this._isURL(osgiURLString = this.getParameterValue("TEST_PORTAL_RELEASE_OSGI_URL"))) {
                this._portalRelease.setOSGiURL(new URL(osgiURLString));
            }
            if (this._isURL(portalWarURLString = this.getParameterValue("TEST_PORTAL_RELEASE_WAR_URL"))) {
                this._portalRelease.setPortalWarURL(new URL(portalWarURLString));
            }
            if (this._isURL(sqlURLString = this.getParameterValue("TEST_PORTAL_RELEASE_SQL_URL"))) {
                this._portalRelease.setSQLURL(new URL(sqlURLString));
            }
            if (this._isURL(toolsURLString = this.getParameterValue("TEST_PORTAL_RELEASE_TOOLS_URL"))) {
                this._portalRelease.setToolsURL(new URL(toolsURLString));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
        return this._portalRelease;
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public Workspace getWorkspace() {
        String portalGitCommit;
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        if (workspace instanceof PortalWorkspace) {
            PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
            portalWorkspace.setBuildProfile(this.getBuildProfile());
        }
        WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
        String portalGitHubURL = this._getPortalGitHubURL();
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL)) {
            workspaceGitRepository.setGitHubURL(portalGitHubURL);
        }
        if (JenkinsResultsParserUtil.isSHA(portalGitCommit = this._getPortalGitCommit())) {
            workspaceGitRepository.setSenderBranchSHA(portalGitCommit);
        }
        return workspace;
    }

    private String _getPortalGitCommit() {
        return this.getParameterValue("TEST_PORTAL_RELEASE_GIT_ID");
    }

    private String _getPortalGitHubURL() {
        String portalBranchName = this.getParameterValue("TEST_PORTAL_USER_BRANCH_NAME");
        String portalBranchUsername = this.getParameterValue("TEST_PORTAL_USER_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(portalBranchUsername)) {
            return null;
        }
        String branchName = this.getBranchName();
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(portalBranchUsername);
        sb.append("/liferay-portal");
        if (!branchName.equals("master")) {
            sb.append("-ee");
        }
        sb.append("/tree/");
        sb.append(portalBranchName);
        return sb.toString();
    }

    private boolean _isURL(String urlString) {
        return !JenkinsResultsParserUtil.isNullOrEmpty(urlString) && urlString.matches("https?://.+");
    }
}

