/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;

public class PortalRelease {
    private static final String[] _BASE_URL_STRINGS = new String[]{"http://mirrors.lax.liferay.com/releases.liferay.com/portal", "http://mirrors.lax.liferay.com/files.liferay.com/private/ee/portal", "https://releases.liferay.com/portal", "https://files.liferay.com/private/ee/portal"};
    private static final String _PORTAL_VERSION_REGEX = "(?<portalVersion>\\d\\.([u\\d\\.]+)(-ee)?(\\-(ep|ga|rc|sp)\\d+)?)";
    private static final Pattern _bundleFileNamePattern = Pattern.compile(".+\\-(?<portalVersion>\\d\\.([u\\d\\.]+)(-ee)?(\\-(ep|ga|rc|sp)\\d+)?).*\\.(7z|tar.gz|zip)");
    private static final Pattern _bundlesBaseURLPattern = Pattern.compile("https?://.+/(?<portalVersion>\\d\\.([u\\d\\.]+)(-ee)?(\\-(ep|ga|rc|sp)\\d+)?)");
    private static final Pattern _bundleURLPattern = Pattern.compile("(?<bundlesBaseURL>https?://.+)/(?<bundleFileName>[^\\/]+\\.(7z|tar.gz|zip))");
    private static final Pattern _dependenciesFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-dependencies-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _glassFishFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-glassfish-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private static final Pattern _jbossFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-jboss-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private static final Pattern _osgiFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-osgi-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _portalWarFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+\\.war)\\\"");
    private static final Pattern _sqlFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-sql-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _tomcatFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-tomcat-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private static final Pattern _toolsFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-tools-[^\\\"]+\\.zip)\\\"");
    private static final Pattern _wildFlyFileNamePattern = Pattern.compile("href=\\\"[^\\\"]*(?<fileName>liferay-[^\\\"]+-wildfly-[^\\\"]+\\.(7z|tar.gz|zip))\\\"");
    private final URL _bundlesBaseURL;
    private String _dependenciesURLString;
    private String _glassFishURLString;
    private String _jbossURLString;
    private String _osgiURLString;
    private final String _portalVersion;
    private String _portalWarURLString;
    private String _sqlURLString;
    private String _tomcatURLString;
    private String _toolsURLString;
    private String _wildFlyURLString;

    public PortalRelease(String portalVersion) {
        URL bundlesBaseURL = null;
        for (String baseURLString : _BASE_URL_STRINGS) {
            String bundlesBaseURLString = baseURLString + "/" + portalVersion;
            String bundlesBaseURLContent = null;
            try {
                bundlesBaseURLContent = JenkinsResultsParserUtil.toString(bundlesBaseURLString + "/", true, 0, 5, 0);
                bundlesBaseURL = new URL(bundlesBaseURLString);
                break;
            }
            catch (IOException iOException) {
                try {
                    String xml = JenkinsResultsParserUtil.toString(baseURLString + "/");
                    xml = xml.substring(xml.indexOf("<html>"));
                    xml = xml.replaceAll("&nbsp;", "");
                    xml = xml.replaceAll("<img[^>]+>", "");
                    xml = xml.replaceAll("<hr>", "");
                    Document document = Dom4JUtil.parse(xml);
                    for (Node node : Dom4JUtil.getNodesByXPath(document, "//a")) {
                        String text = node.getText();
                        text = text.trim();
                        if (!(text = text.replace("/", "")).startsWith(portalVersion + "-")) continue;
                        bundlesBaseURLString = baseURLString + "/" + text;
                        try {
                            bundlesBaseURLContent = JenkinsResultsParserUtil.toString(bundlesBaseURLString + "/", true, 0, 5, 0);
                            portalVersion = text;
                            break;
                        }
                        catch (IOException iOException2) {
                        }
                    }
                    if (bundlesBaseURLContent == null) continue;
                    bundlesBaseURL = new URL(bundlesBaseURLString);
                    break;
                }
                catch (IOException | DocumentException exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        if (bundlesBaseURL == null) {
            throw new RuntimeException("Invalid portal version " + portalVersion);
        }
        this._portalVersion = portalVersion;
        this._bundlesBaseURL = this._getLocalURL(bundlesBaseURL.toString());
        this._initializeURLs();
    }

    public PortalRelease(URL bundleURL) {
        Matcher bundleURLMatcher = _bundleURLPattern.matcher(bundleURL.toString());
        if (!bundleURLMatcher.find()) {
            throw new RuntimeException("Invalid URL " + bundleURL);
        }
        String portalVersion = null;
        String bundleFileName = bundleURLMatcher.group("bundleFileName");
        Matcher bundleFileNameMatcher = _bundleFileNamePattern.matcher(bundleFileName);
        if (bundleFileNameMatcher.find()) {
            portalVersion = bundleFileNameMatcher.group("portalVersion");
        }
        String bundlesBaseURLString = bundleURLMatcher.group("bundlesBaseURL");
        if (portalVersion == null) {
            Matcher bundlesBaseURLMatcher = _bundlesBaseURLPattern.matcher(bundlesBaseURLString);
            if (!bundlesBaseURLMatcher.find()) {
                throw new RuntimeException("Invalid bundle file name " + bundleFileName);
            }
            portalVersion = bundlesBaseURLMatcher.group("portalVersion");
        }
        this._bundlesBaseURL = this._getLocalURL(bundlesBaseURLString);
        this._portalVersion = portalVersion;
        this._initializeURLs();
    }

    public PortalRelease(URL bundlesBaseURL, String portalVersion) {
        if (bundlesBaseURL == null) {
            throw new RuntimeException("Bundles base URL is null");
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalVersion)) {
            throw new RuntimeException("Portal version is null or empty");
        }
        this._portalVersion = portalVersion;
        String bundlesBaseURLString = bundlesBaseURL.toString();
        if (bundlesBaseURLString.endsWith("/")) {
            bundlesBaseURLString = bundlesBaseURLString.substring(0, bundlesBaseURLString.length() - 1);
        }
        this._bundlesBaseURL = this._getLocalURL(bundlesBaseURLString);
        this._initializeURLs();
    }

    public URL getBundlesBaseLocalURL() {
        return this._getLocalURL(this._bundlesBaseURL.toString());
    }

    public URL getBundlesBaseURL() {
        return this._getRemoteURL(this._bundlesBaseURL.toString());
    }

    public URL getDependenciesLocalURL() {
        return this._getLocalURL(this._dependenciesURLString);
    }

    public URL getDependenciesURL() {
        return this._getRemoteURL(this._dependenciesURLString);
    }

    public URL getGlassFishLocalURL() {
        return this._getLocalURL(this._glassFishURLString);
    }

    public URL getGlassFishURL() {
        return this._getRemoteURL(this._glassFishURLString);
    }

    public String getHTMLReport() {
        URL[] urls;
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (URL url : urls = new URL[]{this.getDependenciesURL(), this.getGlassFishURL(), this.getJBossURL(), this.getOSGiURL(), this.getPortalWarURL(), this.getSQLURL(), this.getTomcatURL(), this.getToolsURL(), this.getWildFlyURL()}) {
            if (url == null) continue;
            String urlString = url.toString();
            sb.append("<li><a href=\"");
            sb.append(urlString);
            sb.append("\">");
            sb.append(urlString.replaceAll(".+/([^/]+)", "$1"));
            sb.append("</a></li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public URL getJBossLocalURL() {
        return this._getLocalURL(this._jbossURLString);
    }

    public URL getJBossURL() {
        return this._getRemoteURL(this._jbossURLString);
    }

    public URL getOSGiLocalURL() {
        return this._getLocalURL(this._osgiURLString);
    }

    public URL getOSGiURL() {
        return this._getRemoteURL(this._osgiURLString);
    }

    public String getPortalVersion() {
        return this._portalVersion;
    }

    public URL getPortalWarLocalURL() {
        return this._getLocalURL(this._portalWarURLString);
    }

    public URL getPortalWarURL() {
        return this._getRemoteURL(this._portalWarURLString);
    }

    public URL getSQLLocalURL() {
        return this._getLocalURL(this._sqlURLString);
    }

    public URL getSQLURL() {
        return this._getRemoteURL(this._sqlURLString);
    }

    public URL getTomcatLocalURL() {
        return this._getLocalURL(this._tomcatURLString);
    }

    public URL getTomcatURL() {
        return this._getRemoteURL(this._tomcatURLString);
    }

    public URL getToolsLocalURL() {
        return this._getLocalURL(this._toolsURLString);
    }

    public URL getToolsURL() {
        return this._getRemoteURL(this._toolsURLString);
    }

    public URL getWildFlyLocalURL() {
        return this._getLocalURL(this._wildFlyURLString);
    }

    public URL getWildFlyURL() {
        return this._getRemoteURL(this._wildFlyURLString);
    }

    public void setDependenciesURL(URL dependenciesURL) {
        if (dependenciesURL == null) {
            this._dependenciesURLString = null;
            return;
        }
        this._dependenciesURLString = JenkinsResultsParserUtil.getLocalURL(dependenciesURL.toString());
    }

    public void setGlassFishURL(URL glassFishURL) {
        if (glassFishURL == null) {
            this._glassFishURLString = null;
            return;
        }
        this._glassFishURLString = JenkinsResultsParserUtil.getLocalURL(glassFishURL.toString());
    }

    public void setJBossURL(URL jbossURL) {
        if (jbossURL == null) {
            this._jbossURLString = null;
            return;
        }
        this._jbossURLString = JenkinsResultsParserUtil.getLocalURL(jbossURL.toString());
    }

    public void setOSGiURL(URL osgiURL) {
        if (osgiURL == null) {
            this._osgiURLString = null;
            return;
        }
        this._osgiURLString = JenkinsResultsParserUtil.getLocalURL(osgiURL.toString());
    }

    public void setPortalWarURL(URL portalWarURL) {
        if (portalWarURL == null) {
            this._portalWarURLString = null;
            return;
        }
        this._portalWarURLString = JenkinsResultsParserUtil.getLocalURL(portalWarURL.toString());
    }

    public void setSQLURL(URL sqlURL) {
        if (sqlURL == null) {
            this._sqlURLString = null;
            return;
        }
        this._sqlURLString = JenkinsResultsParserUtil.getLocalURL(sqlURL.toString());
    }

    public void setTomcatURL(URL tomcatURL) {
        if (tomcatURL == null) {
            this._tomcatURLString = null;
            return;
        }
        this._tomcatURLString = JenkinsResultsParserUtil.getLocalURL(tomcatURL.toString());
    }

    public void setToolsURL(URL toolsURL) {
        if (toolsURL == null) {
            this._toolsURLString = null;
            return;
        }
        this._toolsURLString = JenkinsResultsParserUtil.getLocalURL(toolsURL.toString());
    }

    public void setWildFlyURL(URL wildFlyURL) {
        if (wildFlyURL == null) {
            this._wildFlyURLString = null;
            return;
        }
        this._wildFlyURLString = JenkinsResultsParserUtil.getLocalURL(wildFlyURL.toString());
    }

    private URL _getLocalURL(String urlString) {
        if (urlString == null) {
            return null;
        }
        try {
            return new URL(JenkinsResultsParserUtil.getLocalURL(urlString.replaceAll("([^:])//", "$1/")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private URL _getRemoteURL(String urlString) {
        if (urlString == null) {
            return null;
        }
        try {
            return new URL(JenkinsResultsParserUtil.getRemoteURL(urlString.replaceAll("([^:])//", "$1/")));
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private String _getURLString(String bundlesBaseURLContent, Pattern pattern) {
        Matcher matcher = pattern.matcher(bundlesBaseURLContent);
        if (!matcher.find()) {
            return null;
        }
        return this.getBundlesBaseLocalURL() + "/" + matcher.group("fileName");
    }

    private void _initializeURLs() {
        String bundlesBaseURLContent = null;
        try {
            bundlesBaseURLContent = JenkinsResultsParserUtil.toString(this.getBundlesBaseLocalURL() + "/", false, 0, 5, 0);
        }
        catch (IOException ioException) {
            return;
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(bundlesBaseURLContent)) {
            return;
        }
        this._dependenciesURLString = this._getURLString(bundlesBaseURLContent, _dependenciesFileNamePattern);
        this._glassFishURLString = this._getURLString(bundlesBaseURLContent, _glassFishFileNamePattern);
        this._jbossURLString = this._getURLString(bundlesBaseURLContent, _jbossFileNamePattern);
        this._osgiURLString = this._getURLString(bundlesBaseURLContent, _osgiFileNamePattern);
        this._portalWarURLString = this._getURLString(bundlesBaseURLContent, _portalWarFileNamePattern);
        this._sqlURLString = this._getURLString(bundlesBaseURLContent, _sqlFileNamePattern);
        this._tomcatURLString = this._getURLString(bundlesBaseURLContent, _tomcatFileNamePattern);
        this._toolsURLString = this._getURLString(bundlesBaseURLContent, _toolsFileNamePattern);
        this._wildFlyURLString = this._getURLString(bundlesBaseURLContent, _wildFlyFileNamePattern);
    }
}

