/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import java.io.File;
import org.json.JSONObject;

public abstract class PortalGitRepositoryJob
extends GitRepositoryJob
implements PortalTestClassJob {
    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        GitWorkingDirectory gitWorkingDirectory = this.getGitWorkingDirectory();
        if (!(gitWorkingDirectory instanceof PortalGitWorkingDirectory)) {
            throw new RuntimeException("Invalid portal Git working directory");
        }
        return (PortalGitWorkingDirectory)gitWorkingDirectory;
    }

    protected PortalGitRepositoryJob(Job.BuildProfile buildProfile, String jobName) {
        this(buildProfile, jobName, null, null);
    }

    protected PortalGitRepositoryJob(Job.BuildProfile buildProfile, String jobName, PortalGitWorkingDirectory portalGitWorkingDirectory, String upstreamBranchName) {
        super(buildProfile, jobName, upstreamBranchName);
        this._initialize(portalGitWorkingDirectory);
    }

    protected PortalGitRepositoryJob(JSONObject jsonObject) {
        super(jsonObject);
        this._initialize(null);
    }

    private void _initialize(PortalGitWorkingDirectory portalGitWorkingDirectory) {
        this.gitWorkingDirectory = portalGitWorkingDirectory != null ? portalGitWorkingDirectory : GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this.getUpstreamBranchName());
        this.setGitRepositoryDir(this.gitWorkingDirectory.getWorkingDirectory());
        this.checkGitRepositoryDir();
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "tools/sdk/build.properties"));
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "build.properties"));
        this.jobPropertiesFiles.add(new File(this.gitRepositoryDir, "test.properties"));
    }
}

