/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

public class PortalEnvironmentJob
extends BaseJob
implements PortalTestClassJob {
    private final String _portalUpstreamBranchName;

    @Override
    public Set<String> getDistTypes() {
        return new HashSet<String>();
    }

    @Override
    public List<String> getJobPropertyOptions() {
        List<String> jobPropertyOptions = super.getJobPropertyOptions();
        jobPropertyOptions.add(this._portalUpstreamBranchName);
        return jobPropertyOptions;
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("portal_upstream_branch_name", (Object)this._portalUpstreamBranchName);
        return this.jsonObject;
    }

    @Override
    public PortalGitWorkingDirectory getPortalGitWorkingDirectory() {
        return GitWorkingDirectoryFactory.newPortalGitWorkingDirectory(this._portalUpstreamBranchName);
    }

    protected PortalEnvironmentJob(Job.BuildProfile buildProfile, String jobName, String portalUpstreamBranchName) {
        super(buildProfile, jobName);
        this._portalUpstreamBranchName = portalUpstreamBranchName;
        this._initialize();
    }

    protected PortalEnvironmentJob(JSONObject jsonObject) {
        super(jsonObject);
        this._portalUpstreamBranchName = jsonObject.getString("portal_upstream_branch_name");
        this._initialize();
    }

    @Override
    protected Set<String> getRawBatchNames() {
        JobProperty jobProperty = this.getJobProperty("environment.job.names");
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    private void _initialize() {
        PortalGitWorkingDirectory portalGitWorkingDirectory = this.getPortalGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(portalGitWorkingDirectory.getWorkingDirectory(), "test.properties"));
        GitWorkingDirectory jenkinsGitWorkingDirectory = GitWorkingDirectoryFactory.newJenkinsGitWorkingDirectory();
        this.jobPropertiesFiles.add(new File(jenkinsGitWorkingDirectory.getWorkingDirectory(), "commands/dependencies/test-environment.properties"));
    }
}

