/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PortalFixpackRelease;
import com.liferay.jenkins.results.parser.PortalRelease;
import com.liferay.jenkins.results.parser.PortalTopLevelBuild;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import com.liferay.jenkins.results.parser.Workspace;
import com.liferay.jenkins.results.parser.WorkspaceFactory;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import java.net.MalformedURLException;
import java.net.URL;

public class PortalAppReleaseTopLevelBuild
extends PortalTopLevelBuild
implements PortalWorkspaceBuild {
    public PortalAppReleaseTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getBranchName() {
        return this.getParameterValue("TEST_PORTAL_BRANCH_NAME");
    }

    public String getPortalAppName() {
        return this.getParameterValue("TEST_PORTAL_APP_NAME");
    }

    @Override
    public PortalFixpackRelease getPortalFixpackRelease() {
        if (this.portalFixpackRelease != null) {
            return this.portalFixpackRelease;
        }
        String portalFixPackZipURL = this.getParameterValue("TEST_PORTAL_FIX_PACK_ZIP_URL");
        if (portalFixPackZipURL != null) {
            try {
                this.portalFixpackRelease = new PortalFixpackRelease(new URL(portalFixPackZipURL));
                return this.portalFixpackRelease;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return null;
    }

    @Override
    public PortalRelease getPortalRelease() {
        if (this.portalRelease != null) {
            return this.portalRelease;
        }
        String portalBundleVersion = this.getParameterValue("TEST_PORTAL_BUNDLE_VERSION");
        if (portalBundleVersion != null) {
            this.portalRelease = new PortalRelease(portalBundleVersion);
            return this.portalRelease;
        }
        PortalFixpackRelease portalFixpackRelease = this.getPortalFixpackRelease();
        if (portalFixpackRelease != null) {
            this.portalRelease = portalFixpackRelease.getPortalRelease();
            return this.portalRelease;
        }
        return null;
    }

    @Override
    public PortalWorkspace getPortalWorkspace() {
        Workspace workspace = this.getWorkspace();
        if (!(workspace instanceof PortalWorkspace)) {
            return null;
        }
        return (PortalWorkspace)workspace;
    }

    @Override
    public Workspace getWorkspace() {
        String portalGitHubURL;
        Workspace workspace = WorkspaceFactory.newWorkspace(this.getBaseGitRepositoryName(), this.getBranchName(), this.getJobName());
        if (workspace instanceof PortalWorkspace) {
            PortalWorkspace portalWorkspace = (PortalWorkspace)workspace;
            portalWorkspace.setBuildProfile(this.getBuildProfile());
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalGitHubURL = this._getPortalGitHubURL())) {
            WorkspaceGitRepository workspaceGitRepository = workspace.getPrimaryWorkspaceGitRepository();
            workspaceGitRepository.setGitHubURL(portalGitHubURL);
        }
        return workspace;
    }

    private String _getPortalGitHubURL() {
        String portalBranchName = this.getParameterValue("TEST_PORTAL_RELEASE_TAG");
        String portalBranchUsername = this.getParameterValue("TEST_PORTAL_RELEASE_USERNAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalBranchName) || JenkinsResultsParserUtil.isNullOrEmpty(portalBranchUsername)) {
            return null;
        }
        String branchName = this.getBranchName();
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(portalBranchUsername);
        sb.append("/liferay-portal");
        if (!branchName.equals("master")) {
            sb.append("-ee");
        }
        sb.append("/tree/");
        sb.append(portalBranchName);
        return sb.toString();
    }
}

