/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PluginsWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.PortalWorkspace;
import com.liferay.jenkins.results.parser.PortalWorkspaceGitRepository;
import com.liferay.jenkins.results.parser.WorkspaceGitRepository;
import org.json.JSONObject;

public class PluginsWorkspace
extends PortalWorkspace {
    @Override
    public PluginsWorkspaceGitRepository getPluginsWorkspaceGitRepository() {
        WorkspaceGitRepository workspaceGitRepository = this.getPrimaryWorkspaceGitRepository();
        if (!(workspaceGitRepository instanceof PluginsWorkspaceGitRepository)) {
            return null;
        }
        return (PluginsWorkspaceGitRepository)workspaceGitRepository;
    }

    @Override
    public PortalWorkspaceGitRepository getPortalWorkspaceGitRepository() {
        String directoryName;
        WorkspaceGitRepository portalWorkspaceGitRepository;
        WorkspaceGitRepository workspaceGitRepository = this.getPrimaryWorkspaceGitRepository();
        String upstreamBranchName = workspaceGitRepository.getUpstreamBranchName();
        String repositoryName = "liferay-portal";
        if (!upstreamBranchName.equals("master")) {
            repositoryName = repositoryName + "-ee";
        }
        if (!((portalWorkspaceGitRepository = this.getWorkspaceGitRepository(directoryName = JenkinsResultsParserUtil.getGitDirectoryName(repositoryName, upstreamBranchName))) instanceof PortalWorkspaceGitRepository)) {
            throw new RuntimeException("The portal workspace Git repository is not set");
        }
        return (PortalWorkspaceGitRepository)portalWorkspaceGitRepository;
    }

    protected PluginsWorkspace(JSONObject jsonObject) {
        super(jsonObject);
    }

    protected PluginsWorkspace(String primaryRepositoryName, String upstreamBranchName) {
        super(primaryRepositoryName, upstreamBranchName);
    }

    protected PluginsWorkspace(String primaryRepositoryName, String upstreamBranchName, String jobName) {
        super(primaryRepositoryName, upstreamBranchName, jobName);
    }
}

