/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsGitRepositoryJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.json.JSONObject;

public abstract class PluginsTestSuiteJob
extends PluginsGitRepositoryJob
implements TestSuiteJob {
    private final String _pluginName;

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = super.getJSONObject();
        this.jsonObject.put("plugin_name", (Object)this._pluginName);
        return this.jsonObject;
    }

    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public List<File> getPluginsTestBaseDirs() {
        return Arrays.asList(this._getPluginTestBaseDir());
    }

    @Override
    public String getTestSuiteName() {
        return this.getPluginName();
    }

    protected PluginsTestSuiteJob(Job.BuildProfile buildProfile, String jobName, String pluginName, String upstreamBranchName) {
        super(buildProfile, jobName, upstreamBranchName);
        this._pluginName = pluginName;
        this._initialize();
    }

    protected PluginsTestSuiteJob(JSONObject jsonObject) {
        super(jsonObject);
        this._pluginName = jsonObject.getString("plugin_name");
        this._initialize();
    }

    private File _getPluginTestBaseDir() {
        GitWorkingDirectory pluginsGitWorkingDirectory = this.getGitWorkingDirectory();
        return new File(pluginsGitWorkingDirectory.getWorkingDirectory(), JenkinsResultsParserUtil.combine("portlets/", this.getPluginName(), "/test/functional"));
    }

    private void _initialize() {
        this.jobPropertiesFiles.add(new File(this._getPluginTestBaseDir(), "test.properties"));
    }
}

