/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ParallelExecutor<T> {
    private final Collection<Callable<T>> _callables;
    private final boolean _disposeExecutor;
    private boolean _excludeNulls;
    private ExecutorService _executorService;
    private ArrayList<Future<T>> _futures;

    public ParallelExecutor(Collection<Callable<T>> callables, boolean excludeNulls, ExecutorService executorService) {
        this._callables = callables;
        this._excludeNulls = excludeNulls;
        this._executorService = executorService;
        if (this._executorService == null) {
            this._disposeExecutor = true;
            this._executorService = Executors.newSingleThreadExecutor();
        } else {
            this._disposeExecutor = false;
        }
    }

    public ParallelExecutor(Collection<Callable<T>> callables, ExecutorService executorService) {
        this(callables, false, executorService);
    }

    public List<T> execute() {
        this.start();
        return this.waitFor();
    }

    public synchronized void start() {
        if (this._futures != null) {
            return;
        }
        this._futures = new ArrayList(this._callables.size());
        for (Callable<T> callable : this._callables) {
            this._futures.add(this._executorService.submit(callable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> waitFor() {
        if (this._futures == null) {
            this.start();
        }
        try {
            ArrayList<T> results = new ArrayList<T>(this._callables.size());
            for (Future<T> future : this._futures) {
                try {
                    T result = future.get();
                    if (result == null && this._excludeNulls) continue;
                    results.add(result);
                }
                catch (InterruptedException | ExecutionException exception) {
                    throw new RuntimeException(exception);
                }
            }
            ArrayList<T> arrayList = results;
            return arrayList;
        }
        finally {
            if (this._disposeExecutor) {
                this._executorService.shutdown();
                while (!this._executorService.isShutdown()) {
                    JenkinsResultsParserUtil.sleep(100L);
                }
                this._executorService = null;
            }
        }
    }
}

