/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitCommit;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LegacyDataArchiveGroup;
import com.liferay.jenkins.results.parser.LegacyDataArchiveHelper;
import com.liferay.jenkins.results.parser.LocalGitCommit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;

public class LegacyDataArchivePortalVersion {
    private final List<String> _dataArchiveTypes;
    private final List<String> _databaseNames;
    private final LocalGitCommit _latestTestLocalGitCommit;
    private final List<LegacyDataArchiveGroup> _legacyDataArchiveGroups;
    private final LegacyDataArchiveHelper _legacyDataArchiveHelper;
    private final GitWorkingDirectory _legacyGitWorkingDirectory;
    private final String _portalVersion;
    private final File _portalVersionDirectory;
    private final File _portalVersionTestDirectory;

    public LegacyDataArchivePortalVersion(LegacyDataArchiveHelper legacyDataArchiveHelper, String portalVersion) {
        this._legacyDataArchiveHelper = legacyDataArchiveHelper;
        this._portalVersion = portalVersion;
        this._legacyGitWorkingDirectory = this._legacyDataArchiveHelper.getLegacyGitWorkingDirectory();
        this._portalVersionDirectory = new File(this._legacyGitWorkingDirectory.getWorkingDirectory(), this._portalVersion);
        this._portalVersionTestDirectory = new File(this._portalVersionDirectory, "test");
        if (!this._portalVersionTestDirectory.exists()) {
            throw new RuntimeException(this._portalVersionDirectory + " does not exist");
        }
        this._dataArchiveTypes = this._getDataArchiveTypes();
        this._databaseNames = this._getDatabaseNames();
        this._latestTestLocalGitCommit = this._getLatestTestLocalGitCommit();
        this._legacyDataArchiveGroups = this._getLegacyDataArchiveGroups();
    }

    public List<String> getDatabaseNames() {
        return this._databaseNames;
    }

    public LocalGitCommit getLatestTestLocalGitCommit() {
        return this._latestTestLocalGitCommit;
    }

    public List<LegacyDataArchiveGroup> getLegacyDataArchiveGroups() {
        return this._legacyDataArchiveGroups;
    }

    public LegacyDataArchiveHelper getLegacyDataArchiveHelper() {
        return this._legacyDataArchiveHelper;
    }

    public String getPortalVersion() {
        return this._portalVersion;
    }

    public File getPortalVersionTestDirectory() {
        return this._portalVersionTestDirectory;
    }

    private List<String> _getDataArchiveTypes() {
        Properties testProperties = JenkinsResultsParserUtil.getProperties(new File(this._portalVersionTestDirectory, "test.properties"));
        String dataArchiveTypesString = JenkinsResultsParserUtil.getProperty(testProperties, "data.archive.types");
        if (JenkinsResultsParserUtil.isNullOrEmpty(dataArchiveTypesString)) {
            dataArchiveTypesString = JenkinsResultsParserUtil.getProperty(testProperties, "test.case.available.property.values[data.archive.type]");
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(dataArchiveTypesString)) {
            return Collections.emptyList();
        }
        ArrayList<String> dataArchiveTypes = new ArrayList<String>(new HashSet<String>(Arrays.asList(dataArchiveTypesString.split(","))));
        Collections.sort(dataArchiveTypes);
        return dataArchiveTypes;
    }

    private List<String> _getDatabaseNames() {
        Properties buildProperties = this._legacyDataArchiveHelper.getBuildProperties();
        String legacyDataArchiveDatabaseNames = buildProperties.getProperty("legacy.data.archive.database.names");
        String databaseNamesPortalVersionKey = JenkinsResultsParserUtil.combine("legacy.data.archive.database.names[", this._portalVersion, "]");
        if (buildProperties.containsKey(databaseNamesPortalVersionKey)) {
            legacyDataArchiveDatabaseNames = buildProperties.getProperty(databaseNamesPortalVersionKey);
        }
        List<String> databaseNames = Arrays.asList(legacyDataArchiveDatabaseNames.split(","));
        Collections.sort(databaseNames);
        return databaseNames;
    }

    private LocalGitCommit _getLatestTestLocalGitCommit() {
        List<LocalGitCommit> localGitCommits = this._legacyGitWorkingDirectory.log(50, this._portalVersionTestDirectory);
        for (LocalGitCommit localGitCommit : localGitCommits) {
            if (localGitCommit.getType() != GitCommit.Type.MANUAL) continue;
            return localGitCommit;
        }
        return null;
    }

    private List<LegacyDataArchiveGroup> _getLegacyDataArchiveGroups() {
        ArrayList<LegacyDataArchiveGroup> legacyDataArchiveTypes = new ArrayList<LegacyDataArchiveGroup>();
        for (String dataArchiveType : this._dataArchiveTypes) {
            legacyDataArchiveTypes.add(new LegacyDataArchiveGroup(this, dataArchiveType));
        }
        return legacyDataArchiveTypes;
    }
}

