/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildData;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.BuildDatabaseUtil;
import com.liferay.jenkins.results.parser.DefaultPortalJob;
import com.liferay.jenkins.results.parser.FixPackBuilderGitRepositoryJob;
import com.liferay.jenkins.results.parser.GitRepositoryJob;
import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.GitWorkingDirectoryFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.PluginsAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PluginsExtraAppsJob;
import com.liferay.jenkins.results.parser.PluginsMarketplaceAppJob;
import com.liferay.jenkins.results.parser.PluginsReleaseJob;
import com.liferay.jenkins.results.parser.PluginsUpstreamJob;
import com.liferay.jenkins.results.parser.PortalAWSJob;
import com.liferay.jenkins.results.parser.PortalAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.PortalAcceptanceUpstreamJob;
import com.liferay.jenkins.results.parser.PortalAppReleaseJob;
import com.liferay.jenkins.results.parser.PortalBuildData;
import com.liferay.jenkins.results.parser.PortalEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalFixpackEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalFixpackReleaseJob;
import com.liferay.jenkins.results.parser.PortalGitWorkingDirectory;
import com.liferay.jenkins.results.parser.PortalHotfixReleaseJob;
import com.liferay.jenkins.results.parser.PortalReleaseEnvironmentJob;
import com.liferay.jenkins.results.parser.PortalReleaseJob;
import com.liferay.jenkins.results.parser.PortalTestClassJob;
import com.liferay.jenkins.results.parser.PortalTestSuiteUpstreamJob;
import com.liferay.jenkins.results.parser.QAWebsitesGitRepositoryJob;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolBatchJob;
import com.liferay.jenkins.results.parser.RootCauseAnalysisToolJob;
import com.liferay.jenkins.results.parser.SimpleJob;
import com.liferay.jenkins.results.parser.SubrepositoryAcceptancePullRequestJob;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class JobFactory {
    private static final Map<String, Job> _jobs = new HashMap<String, Job>();

    public static String getKey(Job job) {
        List<String> projectNames = null;
        if (job instanceof QAWebsitesGitRepositoryJob) {
            QAWebsitesGitRepositoryJob qaWebsitesGitRepositoryJob = (QAWebsitesGitRepositoryJob)job;
            projectNames = qaWebsitesGitRepositoryJob.getProjectNames();
        }
        String repositoryName = null;
        if (job instanceof GitRepositoryJob) {
            GitRepositoryJob gitRepositoryJob = (GitRepositoryJob)job;
            repositoryName = gitRepositoryJob.getRepositoryName();
        }
        String testSuiteName = "default";
        if (job instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)job;
            testSuiteName = testSuiteJob.getTestSuiteName();
        }
        String upstreamBranchName = null;
        if (job instanceof GitRepositoryJob) {
            GitRepositoryJob gitRepositoryJob = (GitRepositoryJob)job;
            upstreamBranchName = gitRepositoryJob.getUpstreamBranchName();
        }
        String portalUpstreamBranchName = null;
        if (job instanceof PortalTestClassJob) {
            PortalTestClassJob portalTestClassJob = (PortalTestClassJob)job;
            PortalGitWorkingDirectory portalGitWorkingDirectory = portalTestClassJob.getPortalGitWorkingDirectory();
            portalUpstreamBranchName = portalGitWorkingDirectory.getUpstreamBranchName();
            if (JenkinsResultsParserUtil.isNullOrEmpty(repositoryName)) {
                repositoryName = portalGitWorkingDirectory.getGitRepositoryName();
            }
            if (JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
                upstreamBranchName = portalUpstreamBranchName;
            }
        } else if (JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
            portalUpstreamBranchName = upstreamBranchName;
        }
        return JobFactory.getKey(job.getBuildProfile(), job.getJobName(), null, portalUpstreamBranchName, projectNames, repositoryName, testSuiteName, upstreamBranchName);
    }

    public static String getKey(Job.BuildProfile buildProfile, String jobName, PortalGitWorkingDirectory portalGitWorkingDirectory, String portalUpstreamBranchName, List<String> projectNames, String repositoryName, String testSuiteName, String upstreamBranchName) {
        StringBuilder sb = new StringBuilder();
        if (buildProfile == null) {
            buildProfile = Job.BuildProfile.DXP;
        }
        sb.append((Object)buildProfile);
        sb.append("_");
        sb.append(jobName);
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
            if (portalGitWorkingDirectory != null) {
                portalUpstreamBranchName = portalGitWorkingDirectory.getUpstreamBranchName();
            } else if (JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
                portalUpstreamBranchName = upstreamBranchName;
            }
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
            sb.append("_");
            sb.append(portalUpstreamBranchName);
        }
        if (projectNames != null && !projectNames.isEmpty()) {
            Collections.sort(projectNames);
            sb.append("_");
            sb.append(JenkinsResultsParserUtil.join("_", projectNames));
        }
        if (!JenkinsResultsParserUtil.isNullOrEmpty(repositoryName)) {
            sb.append("_");
            sb.append(repositoryName);
        }
        if (JenkinsResultsParserUtil.isNullOrEmpty(testSuiteName)) {
            testSuiteName = "default";
        }
        sb.append("_");
        sb.append(testSuiteName);
        if (!JenkinsResultsParserUtil.isNullOrEmpty(upstreamBranchName)) {
            sb.append("_");
            sb.append(upstreamBranchName);
        }
        return sb.toString();
    }

    public static String getKey(JSONObject jsonObject) {
        Job.BuildProfile buildProfile = Job.BuildProfile.DXP;
        if (jsonObject.has("build_profile")) {
            buildProfile = Job.BuildProfile.getByString(jsonObject.getString("build_profile"));
        }
        ArrayList<String> projectNames = null;
        JSONArray projectNamesJSONArray = jsonObject.optJSONArray("project_names");
        if (projectNamesJSONArray != null && !projectNamesJSONArray.isEmpty()) {
            projectNames = new ArrayList<String>();
            for (int i = 0; i < projectNamesJSONArray.length(); ++i) {
                projectNames.add(projectNamesJSONArray.getString(i));
            }
        }
        return JobFactory.getKey(buildProfile, jsonObject.getString("job_name"), null, jsonObject.optString("portal_upstream_branch_name"), projectNames, jsonObject.optString("repository_name"), jsonObject.optString("test_suite_name"), jsonObject.optString("upstream_branch_name"));
    }

    public static Job newJob(Build build) {
        TopLevelBuild topLevelBuild = build.getTopLevelBuild();
        String portalUpstreamBranchName = topLevelBuild.getParameterValue("PORTAL_UPSTREAM_BRANCH_NAME");
        if (JenkinsResultsParserUtil.isNullOrEmpty(portalUpstreamBranchName)) {
            portalUpstreamBranchName = topLevelBuild.getBranchName();
        }
        return JobFactory._newJob(topLevelBuild.getBuildProfile(), topLevelBuild.getJobName(), null, null, portalUpstreamBranchName, topLevelBuild.getProjectNames(), topLevelBuild.getBaseGitRepositoryName(), topLevelBuild.getTestSuiteName(), topLevelBuild.getBranchName());
    }

    public static Job newJob(BuildData buildData) {
        Job.BuildProfile buildProfile = null;
        String portalUpstreamBranchName = null;
        String repositoryName = null;
        String upstreamBranchName = null;
        if (buildData instanceof PortalBuildData) {
            PortalBuildData portalBuildData = (PortalBuildData)buildData;
            buildProfile = portalBuildData.getBuildProfile();
            portalUpstreamBranchName = portalBuildData.getPortalUpstreamBranchName();
            repositoryName = portalBuildData.getPortalGitHubRepositoryName();
            upstreamBranchName = portalBuildData.getPortalUpstreamBranchName();
        }
        return JobFactory._newJob(buildProfile, buildData.getJobName(), null, null, portalUpstreamBranchName, null, repositoryName, null, upstreamBranchName);
    }

    public static Job newJob(Job.BuildProfile buildProfile, String jobName, JSONObject jsonObject, PortalGitWorkingDirectory portalGitWorkingDirectory, String portalUpstreamBranchName, List<String> projectNames, String repositoryName, String testSuiteName, String upstreamBranchName) {
        return JobFactory._newJob(buildProfile, jobName, jsonObject, portalGitWorkingDirectory, portalUpstreamBranchName, projectNames, repositoryName, testSuiteName, upstreamBranchName);
    }

    public static Job newJob(JSONObject jsonObject) {
        return JobFactory._newJob(null, null, jsonObject, null, null, null, null, null, null);
    }

    public static Job newJob(String jobName) {
        return JobFactory._newJob(null, jobName, null, null, null, null, null, null, null);
    }

    public static Job newJob(String jobName, String testSuiteName, String upstreamBranchName) {
        return JobFactory._newJob(null, jobName, null, null, null, null, null, testSuiteName, upstreamBranchName);
    }

    public static Job newJob(String jobName, String testSuiteName, String upstreamBranchName, String repositoryName, Job.BuildProfile buildProfile) {
        return JobFactory._newJob(buildProfile, jobName, null, null, null, null, repositoryName, testSuiteName, upstreamBranchName);
    }

    public static Job newJob(String jobName, String testSuiteName, String upstreamBranchName, String repositoryName, Job.BuildProfile buildProfile, PortalGitWorkingDirectory portalGitWorkingDirectory) {
        return JobFactory._newJob(buildProfile, jobName, null, portalGitWorkingDirectory, null, null, repositoryName, testSuiteName, upstreamBranchName);
    }

    private static Job _newJob(Job.BuildProfile buildProfile, String jobName, JSONObject jsonObject, PortalGitWorkingDirectory portalGitWorkingDirectory, String portalUpstreamBranchName, List<String> projectNames, String repositoryName, String testSuiteName, String upstreamBranchName) {
        String key = null;
        if (jsonObject != null) {
            jobName = jsonObject.getString("job_name");
            key = JobFactory.getKey(jsonObject);
        } else {
            key = JobFactory.getKey(buildProfile, jobName, portalGitWorkingDirectory, portalUpstreamBranchName, projectNames, repositoryName, testSuiteName, upstreamBranchName);
        }
        BuildDatabase buildDatabase = BuildDatabaseUtil.getBuildDatabase();
        if (jsonObject == null && buildDatabase.hasJob(key)) {
            return buildDatabase.getJob(key);
        }
        Job job = _jobs.get(key);
        if (job != null) {
            return job;
        }
        if (jobName.equals("js-test-csv-report") || jobName.equals("junit-test-csv-report")) {
            if (portalGitWorkingDirectory == null) {
                GitWorkingDirectory gitWorkingDirectory;
                File gitWorkingDir = JenkinsResultsParserUtil.getGitWorkingDir(new File(System.getProperty("user.dir")));
                Properties buildProperties = JenkinsResultsParserUtil.getProperties(new File(gitWorkingDir, "build.properties"));
                String gitWorkingBranchName = JenkinsResultsParserUtil.getProperty(buildProperties, "git.working.branch.name");
                String gitRepositoryName = "liferay-portal";
                if (!gitWorkingBranchName.equals("master")) {
                    gitRepositoryName = gitRepositoryName + "-ee";
                }
                if ((gitWorkingDirectory = GitWorkingDirectoryFactory.newGitWorkingDirectory(gitWorkingBranchName, gitWorkingDir, gitRepositoryName)) instanceof PortalGitWorkingDirectory) {
                    portalGitWorkingDirectory = (PortalGitWorkingDirectory)gitWorkingDirectory;
                }
            }
            job = jsonObject != null ? new PortalAcceptancePullRequestJob(jsonObject) : new PortalAcceptancePullRequestJob(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        }
        if (jobName.equals("root-cause-analysis-tool")) {
            job = jsonObject != null ? new RootCauseAnalysisToolJob(jsonObject) : new RootCauseAnalysisToolJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.equals("root-cause-analysis-tool-batch")) {
            job = jsonObject != null ? new RootCauseAnalysisToolBatchJob(jsonObject) : new RootCauseAnalysisToolBatchJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.equals("test-fixpack-builder-pullrequest")) {
            job = jsonObject != null ? new FixPackBuilderGitRepositoryJob(jsonObject) : new FixPackBuilderGitRepositoryJob(buildProfile, jobName, testSuiteName, upstreamBranchName);
        }
        if (jobName.startsWith("test-plugins-acceptance-pullrequest(")) {
            job = jsonObject != null ? new PluginsAcceptancePullRequestJob(jsonObject) : new PluginsAcceptancePullRequestJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.equals("test-plugins-extraapps")) {
            job = jsonObject != null ? new PluginsExtraAppsJob(jsonObject) : new PluginsExtraAppsJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.equals("test-plugins-marketplaceapp")) {
            job = jsonObject != null ? new PluginsMarketplaceAppJob(jsonObject) : new PluginsMarketplaceAppJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.equals("test-plugins-release")) {
            job = jsonObject != null ? new PluginsReleaseJob(jsonObject) : new PluginsReleaseJob(buildProfile, jobName, testSuiteName, upstreamBranchName);
        }
        if (jobName.equals("test-plugins-upstream")) {
            job = jsonObject != null ? new PluginsUpstreamJob(jsonObject) : new PluginsUpstreamJob(buildProfile, jobName, testSuiteName, upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-acceptance-pullrequest(")) {
            job = jsonObject != null ? new PortalAcceptancePullRequestJob(jsonObject) : new PortalAcceptancePullRequestJob(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-acceptance-upstream")) {
            job = jsonObject != null ? new PortalAcceptanceUpstreamJob(jsonObject) : new PortalAcceptanceUpstreamJob(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        }
        if (jobName.equals("test-portal-app-release")) {
            job = jsonObject != null ? new PortalAppReleaseJob(jsonObject) : new PortalAppReleaseJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-aws(")) {
            job = jsonObject != null ? new PortalAWSJob(jsonObject) : new PortalAWSJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-environment(")) {
            job = jsonObject != null ? new PortalEnvironmentJob(jsonObject) : new PortalEnvironmentJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-environment-release(")) {
            job = jsonObject != null ? new PortalReleaseEnvironmentJob(jsonObject) : new PortalReleaseEnvironmentJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-fixpack-environment(")) {
            job = jsonObject != null ? new PortalFixpackEnvironmentJob(jsonObject) : new PortalFixpackEnvironmentJob(buildProfile, jobName, upstreamBranchName);
        }
        if (jobName.equals("test-portal-fixpack-release")) {
            job = jsonObject != null ? new PortalFixpackReleaseJob(jsonObject) : new PortalFixpackReleaseJob(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        }
        if (jobName.equals("test-portal-hotfix-release")) {
            job = jsonObject != null ? new PortalHotfixReleaseJob(jsonObject) : new PortalHotfixReleaseJob(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        }
        if (jobName.equals("test-portal-release")) {
            job = jsonObject != null ? new PortalReleaseJob(jsonObject) : new PortalReleaseJob(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        }
        if (jobName.equals("test-portal-source-format")) {
            job = jsonObject != null ? new PortalAcceptancePullRequestJob(jsonObject) : new PortalAcceptancePullRequestJob(buildProfile, jobName, portalGitWorkingDirectory, "sf", upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-testsuite-upstream(")) {
            job = jsonObject != null ? new PortalTestSuiteUpstreamJob(jsonObject) : new PortalTestSuiteUpstreamJob(buildProfile, jobName, portalGitWorkingDirectory, testSuiteName, upstreamBranchName);
        }
        if (jobName.startsWith("test-portal-testsuite-upstream-controller(") || jobName.equals("test-results-consistency-report-controller") || jobName.startsWith("test-qa-websites-functional-daily-controller(")) {
            job = jsonObject != null ? new SimpleJob(jsonObject) : new SimpleJob(buildProfile, jobName);
        }
        if (jobName.equals("test-qa-websites-functional-daily") || jobName.equals("test-qa-websites-functional-environment") || jobName.equals("test-qa-websites-functional-weekly")) {
            job = jsonObject != null ? new QAWebsitesGitRepositoryJob(jsonObject) : new QAWebsitesGitRepositoryJob(buildProfile, jobName, projectNames, testSuiteName, upstreamBranchName);
        }
        if (jobName.startsWith("test-subrepository-acceptance-pullrequest(")) {
            job = jsonObject != null ? new SubrepositoryAcceptancePullRequestJob(jsonObject) : new SubrepositoryAcceptancePullRequestJob(buildProfile, jobName, portalUpstreamBranchName, repositoryName, testSuiteName, upstreamBranchName);
        }
        if (job == null) {
            job = jsonObject != null ? new DefaultPortalJob(jsonObject) : new DefaultPortalJob(buildProfile, jobName, testSuiteName);
        }
        _jobs.put(key, job);
        return _jobs.get(key);
    }
}

