/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.NotificationUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class JenkinsConsoleTextLoader {
    protected String buildURL;
    protected String consoleLogFileKey;
    protected boolean hasMoreData = true;
    protected long serverLogSize;
    protected boolean truncated;
    private static final long _BYTES_MAX_SIZE_CONSOLE_LOG = 0x1400000L;
    private static final Pattern _anchorPattern = Pattern.compile("\\<a[^>]*\\>(?<text>[^<]*)\\</a\\>");

    public JenkinsConsoleTextLoader(String buildURL) {
        this.buildURL = JenkinsResultsParserUtil.getLocalURL(buildURL);
        this.consoleLogFileKey = JenkinsResultsParserUtil.combine("jenkins_console_log-", String.valueOf(buildURL.hashCode()), ".log");
        JenkinsResultsParserUtil.saveToCacheFile(this.consoleLogFileKey, "");
        this.serverLogSize = 0L;
    }

    public String getConsoleText() {
        if (this.buildURL.startsWith("file:") || this.buildURL.contains("mirrors")) {
            try {
                return JenkinsResultsParserUtil.toString(this.buildURL + "/consoleText", false, true);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
        this.update();
        String consoleText = JenkinsResultsParserUtil.getCachedText(this.consoleLogFileKey);
        if (this.truncated) {
            consoleText = consoleText + "\n[TRUNCATED]";
        }
        return consoleText;
    }

    public int getLineCount() {
        String consoleLog = this.getConsoleText();
        String[] consoleLogLines = consoleLog.split("\n");
        return consoleLogLines.length;
    }

    public boolean hasMoreData() {
        return this.hasMoreData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        boolean hasMoreData = true;
        long cacheFileSize = JenkinsResultsParserUtil.getCacheFileSize(this.consoleLogFileKey);
        while (hasMoreData && cacheFileSize < 0x1400000L) {
            String url = this.buildURL + "/logText/progressiveHtml?start=" + this.serverLogSize;
            try {
                URL urlObject = new URL(JenkinsResultsParserUtil.getLocalURL(url));
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlObject.openConnection();
                long latestServerLogSize = httpURLConnection.getHeaderFieldLong("X-Text-Size", this.serverLogSize);
                if (latestServerLogSize == this.serverLogSize) break;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                Throwable throwable = null;
                try {
                    String line = bufferedReader.readLine();
                    while (line != null) {
                        Matcher matcher = _anchorPattern.matcher(line);
                        line = matcher.replaceAll("$1") + "\n";
                        line = StringEscapeUtils.unescapeHtml((String)line);
                        JenkinsResultsParserUtil.appendToCacheFile(this.consoleLogFileKey, line);
                        cacheFileSize = JenkinsResultsParserUtil.getCacheFileSize(this.consoleLogFileKey);
                        if (cacheFileSize >= 0x1400000L) {
                            try {
                                this.truncated = true;
                            }
                            catch (Throwable throwable2) {
                                String message = JenkinsResultsParserUtil.combine("Jenkins console log for ", this.buildURL, " has exceeded ", String.valueOf(0x1400000L), " bytes.");
                                System.out.println(message);
                                NotificationUtil.sendEmail(message, "jenkins", "Large console log", "qa-slave-verify-fail@liferay.com");
                                throw throwable2;
                            }
                            String message = JenkinsResultsParserUtil.combine("Jenkins console log for ", this.buildURL, " has exceeded ", String.valueOf(0x1400000L), " bytes.");
                            System.out.println(message);
                            NotificationUtil.sendEmail(message, "jenkins", "Large console log", "qa-slave-verify-fail@liferay.com");
                            break;
                        }
                        line = bufferedReader.readLine();
                    }
                    hasMoreData = Boolean.parseBoolean(httpURLConnection.getHeaderField("X-More-Data"));
                    this.serverLogSize = latestServerLogSize;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (bufferedReader == null) continue;
                    if (throwable != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    bufferedReader.close();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Invalid buildURL " + this.buildURL, malformedURLException);
            }
            catch (IOException ioException) {
                System.out.println("Unable to update console log for build: " + this.buildURL);
                ioException.printStackTrace();
                return;
            }
        }
    }
}

