/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class GitHubGist {
    private final JSONObject _jsonObject;

    public GitHubGist(String gistID) {
        try {
            this._jsonObject = JenkinsResultsParserUtil.toJSONObject("https://api.github.com/gists/" + gistID);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Could not find gist https://gist.github.com/" + gistID, ioException);
        }
    }

    public String getContent() {
        JSONObject filesJSONObject = this._jsonObject.getJSONObject("files");
        Iterator iterator = filesJSONObject.keySet().iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            JSONObject fileJSONObject = filesJSONObject.getJSONObject(key);
            return fileJSONObject.getString("content");
        }
        return null;
    }

    public Map<String, String> getEnvironmentVariables() {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        String content = this.getContent();
        for (String line : content.split("\\n")) {
            if (JenkinsResultsParserUtil.isNullOrEmpty(line) || !line.contains("=")) continue;
            int x = line.indexOf("=");
            environmentVariables.put(line.substring(0, x), line.substring(x + 1));
        }
        return environmentVariables;
    }
}

