/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.XPath;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;

public class Dom4JUtil {
    public static void addRawXMLToElement(Element element, String xml) throws DocumentException {
        Document document = Dom4JUtil.parse("<div>" + xml + "</div>");
        Element rootElement = document.getRootElement();
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element childElement : rootElement.elements()) {
            rootElement.remove(childElement);
            elements.add(childElement);
        }
        Dom4JUtil.addToElement(element, elements.toArray());
    }

    public static void addToElement(Element element, Object ... items) {
        for (Object item : items) {
            if (item == null) continue;
            if (item instanceof Element) {
                element.add((Element)item);
                continue;
            }
            if (item instanceof Element[]) {
                for (Element itemElement : (Element[])item) {
                    element.add(itemElement);
                }
                continue;
            }
            if (item instanceof String) {
                element.addText((String)item);
                continue;
            }
            throw new IllegalArgumentException("Only elements and strings may be added");
        }
    }

    public static void detach(Object ... items) {
        for (Object item : items) {
            if (!(item instanceof Node)) continue;
            Node node = (Node)item;
            node.detach();
        }
    }

    public static String format(Element element) throws IOException {
        return Dom4JUtil.format(element, true);
    }

    public static String format(Element element, boolean pretty) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setTrimText(false);
        XMLWriter xmlWriter = null;
        xmlWriter = pretty ? new XMLWriter((Writer)writer, outputFormat) : new XMLWriter((Writer)writer);
        xmlWriter.write(element);
        return ((Object)writer).toString();
    }

    public static Element getNewAnchorElement(String href, Element parentElement, Object ... items) {
        if (items == null || items.length == 0) {
            return null;
        }
        Element anchorElement = Dom4JUtil.getNewElement("a", parentElement, items);
        anchorElement.addAttribute("href", href);
        return anchorElement;
    }

    public static Element getNewAnchorElement(String href, Object ... items) {
        return Dom4JUtil.getNewAnchorElement(href, null, items);
    }

    public static Element getNewElement(String childElementTag) {
        return Dom4JUtil.getNewElement(childElementTag, null, new Object[0]);
    }

    public static Element getNewElement(String childElementTag, Element parentElement, Object ... items) {
        DefaultElement childElement = new DefaultElement(childElementTag);
        if (parentElement != null) {
            parentElement.add((Element)childElement);
        }
        if (items != null && items.length > 0) {
            Dom4JUtil.addToElement((Element)childElement, items);
        }
        return childElement;
    }

    public static Node getNodeByXPath(Document document, String xpathString) {
        List<Node> nodes = Dom4JUtil.getNodesByXPath(document, xpathString);
        if (nodes.isEmpty()) {
            return null;
        }
        return nodes.get(0);
    }

    public static List<Node> getNodesByXPath(Document document, String xpathString) {
        XPath xPath = DocumentHelper.createXPath((String)xpathString);
        return xPath.selectNodes((Object)document);
    }

    public static Element getOrderedListElement(List<Element> itemElements, Element parentElement, int maxItems) {
        Element orderedListElement = Dom4JUtil.getNewElement("ol", parentElement, new Object[0]);
        int i = 0;
        for (Element itemElement : itemElements) {
            if (i < maxItems) {
                String itemElementName = itemElement.getName();
                if (itemElementName.equals("li")) {
                    orderedListElement.add(itemElement);
                } else {
                    Dom4JUtil.getNewElement("li", orderedListElement, itemElement);
                }
                ++i;
                continue;
            }
            Dom4JUtil.getNewElement("li", orderedListElement, "...");
            break;
        }
        return orderedListElement;
    }

    public static Element getOrderedListElement(List<Element> itemElements, int maxItems) {
        return Dom4JUtil.getOrderedListElement(itemElements, null, maxItems);
    }

    public static void insertElementAfter(Element parentElement, Element targetElement, Element newElement) {
        List elements = parentElement.elements();
        int targetElementIndex = -1;
        if (targetElement != null) {
            if (!elements.contains(targetElement)) {
                try {
                    throw new IllegalArgumentException("Invalid target element\n" + Dom4JUtil.format(targetElement));
                }
                catch (IOException ioException) {
                    throw new IllegalArgumentException("Invalid target element");
                }
            }
            targetElementIndex = elements.indexOf(targetElement);
        }
        elements.add(targetElementIndex + 1, newElement);
        Dom4JUtil.setElements(parentElement, elements);
    }

    public static void insertElementBefore(Element parentElement, Element targetElement, Element newElement) {
        List elements = parentElement.elements();
        int targetElementIndex = elements.size();
        if (targetElement != null) {
            if (!elements.contains(targetElement)) {
                try {
                    throw new IllegalArgumentException("Invalid target element\n" + Dom4JUtil.format(targetElement));
                }
                catch (IOException ioException) {
                    throw new IllegalArgumentException("Invalid target element");
                }
            }
            targetElementIndex = elements.indexOf(targetElement);
        }
        elements.add(targetElementIndex, newElement);
        Dom4JUtil.setElements(parentElement, elements);
    }

    public static Document parse(String xml) throws DocumentException {
        SAXReader saxReader = new SAXReader();
        return saxReader.read((Reader)new StringReader(xml));
    }

    public static void replace(Element element, boolean cascade, String replacementText, String targetText) {
        for (Attribute attribute : element.attributes()) {
            String text = attribute.getValue();
            attribute.setValue(text.replace(targetText, replacementText));
        }
        Iterator nodeIterator = element.nodeIterator();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            if (node instanceof Text) {
                Text textNode = (Text)node;
                String text = textNode.getText();
                if (!text.contains(targetText)) continue;
                text = text.replace(targetText, replacementText);
                textNode.setText(text);
                continue;
            }
            if (!(node instanceof Element) || !cascade) continue;
            Dom4JUtil.replace((Element)node, cascade, replacementText, targetText);
        }
    }

    public static void setElements(Element parentElement, List<Element> elements) {
        if (parentElement == null) {
            throw new IllegalArgumentException("Parent is null");
        }
        for (Element element : parentElement.elements()) {
            parentElement.remove(element);
        }
        for (Element element : elements) {
            parentElement.add(element);
        }
    }

    public static Element toCodeSnippetElement(String content) {
        content = content.replaceAll("\\t", "  ");
        return Dom4JUtil.getNewElement("pre", null, Dom4JUtil.getNewElement("code", null, JenkinsResultsParserUtil.redact(content)));
    }

    public static void truncateElement(Element element, int size) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        nodes.add(element);
        nodes.addAll(element.attributes());
        for (Node node : nodes) {
            String nodeText = node.getText();
            if (nodeText == null || nodeText.length() <= size) continue;
            node.setText(nodeText.substring(0, size));
        }
        Iterator iterator = element.elementIterator();
        while (iterator.hasNext()) {
            Dom4JUtil.truncateElement((Element)iterator.next(), size);
        }
    }
}

