/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildDatabase;
import com.liferay.jenkins.results.parser.DefaultBuildDatabase;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

public class BuildDatabaseUtil {
    private static final Map<File, BuildDatabase> _buildDatabases = new HashMap<File, BuildDatabase>();

    public static void clear() {
        File buildDir = BuildDatabaseUtil._getBuildDir(null);
        File buildDatabaseFile = new File(buildDir, "build-database.json");
        if (buildDatabaseFile.exists()) {
            buildDatabaseFile.delete();
        }
    }

    public static BuildDatabase getBuildDatabase() {
        return BuildDatabaseUtil.getBuildDatabase(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildDatabase getBuildDatabase(Build build) {
        TopLevelBuild topLevelBuild = null;
        if (build != null) {
            topLevelBuild = build.getTopLevelBuild();
        }
        if (build instanceof TopLevelBuild || topLevelBuild == null) {
            File buildDir = BuildDatabaseUtil._getBuildDir(build);
            Map<File, BuildDatabase> map = _buildDatabases;
            synchronized (map) {
                BuildDatabase buildDatabase = _buildDatabases.get(buildDir);
                if (buildDatabase != null) {
                    buildDatabase.readBuildDatabaseFile();
                    return buildDatabase;
                }
                BuildDatabaseUtil._downloadBuildDatabaseFile(buildDir, build);
                buildDatabase = new DefaultBuildDatabase(buildDir);
                _buildDatabases.put(buildDir, buildDatabase);
                return buildDatabase;
            }
        }
        return BuildDatabaseUtil.getBuildDatabase(topLevelBuild);
    }

    private static void _downloadBuildDatabaseFile(File buildDir, Build build) {
        File buildDatabaseFile;
        if (!buildDir.exists()) {
            buildDir.mkdirs();
        }
        if ((buildDatabaseFile = new File(buildDir, "build-database.json")).exists()) {
            return;
        }
        String distNodes = System.getenv("DIST_NODES");
        String distPath = System.getenv("DIST_PATH");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(distNodes) && !JenkinsResultsParserUtil.isNullOrEmpty(distPath)) {
            BuildDatabaseUtil._downloadBuildDatabaseFileFromDistNodes(buildDatabaseFile, distNodes, distPath);
        }
        if (buildDatabaseFile.exists() || build == null) {
            return;
        }
        if (build.isFromArchive()) {
            try {
                JenkinsResultsParserUtil.write(buildDatabaseFile, JenkinsResultsParserUtil.toString(build.getBuildURL() + "/build-database.json"));
            }
            catch (IOException ioException) {
                throw new RuntimeException("Unable to write build-database.json", ioException);
            }
            return;
        }
        if (build instanceof TopLevelBuild) {
            BuildDatabaseUtil._downloadBuildDatabaseFileFromTopLevelBuild(buildDatabaseFile, (TopLevelBuild)build);
            if (!JenkinsResultsParserUtil.isCINode()) {
                File defaultBuildDir = new File(JenkinsResultsParserUtil.getBuildDirPath());
                if (!defaultBuildDir.exists()) {
                    defaultBuildDir.mkdirs();
                }
                File defaultBuildDatabaseFile = new File(defaultBuildDir, "build-database.json");
                try {
                    Files.copy(buildDatabaseFile.toPath(), defaultBuildDatabaseFile.toPath(), new CopyOption[0]);
                }
                catch (IOException ioException) {
                    throw new RuntimeException(ioException);
                }
            }
        }
    }

    private static void _downloadBuildDatabaseFileFromDistNodes(File buildDatabaseFile, String distNodes, String distPath) {
        if (buildDatabaseFile.exists()) {
            return;
        }
        int maxRetries = 5;
        int retries = 0;
        while (retries < maxRetries) {
            try {
                ++retries;
                String distNode = JenkinsResultsParserUtil.getRandomString(Arrays.asList(distNodes.split(",")));
                String[] commands = new String[2];
                commands[0] = JenkinsResultsParserUtil.combine("mkdir -p ", JenkinsResultsParserUtil.escapeForBash(JenkinsResultsParserUtil.getCanonicalPath(buildDatabaseFile.getParentFile())));
                if (JenkinsResultsParserUtil.isOSX()) {
                    commands[1] = JenkinsResultsParserUtil.combine("rsync -Iq --timeout=1200 \"root@", distNode, ":", JenkinsResultsParserUtil.escapeForBash(distPath), "/", "build-database.json", "\" ", JenkinsResultsParserUtil.escapeForBash(JenkinsResultsParserUtil.getCanonicalPath(buildDatabaseFile)));
                } else if (JenkinsResultsParserUtil.isWindows()) {
                    commands[0] = JenkinsResultsParserUtil.combine("mkdir -p ", JenkinsResultsParserUtil.getCanonicalPath(buildDatabaseFile.getParentFile()));
                    distPath = distPath.replaceAll("C:.*TEMP/dist", "/tmp/dist");
                    File bashFile = new File("C:/tmp/jenkins/" + JenkinsResultsParserUtil.getCurrentTimeMillis() + ".sh");
                    JenkinsResultsParserUtil.write(bashFile, JenkinsResultsParserUtil.combine("#!/bin/sh\nscp \"", distNode, ":", JenkinsResultsParserUtil.escapeForBash(distPath), "/", "build-database.json", "\" ", JenkinsResultsParserUtil.escapeForBash(JenkinsResultsParserUtil.getCanonicalPath(buildDatabaseFile))));
                    commands[1] = "/bin/sh " + JenkinsResultsParserUtil.getCanonicalPath(bashFile);
                } else {
                    commands[1] = JenkinsResultsParserUtil.combine("rsync -Iq --timeout=1200 \"", distNode, ":", JenkinsResultsParserUtil.escapeForBash(distPath), "/", "build-database.json", "\" ", JenkinsResultsParserUtil.escapeForBash(JenkinsResultsParserUtil.getCanonicalPath(buildDatabaseFile)));
                }
                Process process = JenkinsResultsParserUtil.executeBashCommands(true, new File("."), 600000L, commands);
                if (process.exitValue() != 0) {
                    throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to download ", "build-database.json"));
                }
                break;
            }
            catch (IOException | RuntimeException | TimeoutException exception) {
                if (retries == maxRetries) {
                    throw new RuntimeException(JenkinsResultsParserUtil.combine("Unable to get ", "build-database.json", " file"), exception);
                }
                System.out.println("Unable to execute bash commands, retrying... ");
                exception.printStackTrace();
                JenkinsResultsParserUtil.sleep(3000L);
            }
        }
    }

    private static void _downloadBuildDatabaseFileFromTopLevelBuild(File buildDatabaseFile, TopLevelBuild topLevelBuild) {
        if (buildDatabaseFile.exists()) {
            return;
        }
        String buildDatabaseURL = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.getBuildArtifactURL(topLevelBuild.getBuildURL(), buildDatabaseFile.getName()));
        String buildDatabaseFilePath = buildDatabaseURL.replaceAll(".*/(userContent/.*)", "/opt/java/jenkins/$1");
        buildDatabaseFilePath = buildDatabaseFilePath.replace("%28", "(");
        buildDatabaseFilePath = buildDatabaseFilePath.replace("%29", ")");
        JenkinsMaster jenkinsMaster = topLevelBuild.getJenkinsMaster();
        try {
            Process process = JenkinsResultsParserUtil.executeBashCommands(JenkinsResultsParserUtil.combine("ssh ", jenkinsMaster.getName(), " ls \"", JenkinsResultsParserUtil.escapeForBash(buildDatabaseFilePath), "\""));
            if (process.exitValue() != 0) {
                return;
            }
        }
        catch (IOException | TimeoutException exception) {
            return;
        }
        try {
            BuildDatabaseUtil._downloadBuildDatabaseFileFromDistNodes(buildDatabaseFile, jenkinsMaster.getName(), buildDatabaseFilePath.replaceAll("(.*)/[^/]+", "$1"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                JenkinsResultsParserUtil.write(buildDatabaseFile, JenkinsResultsParserUtil.toString(buildDatabaseURL));
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            return;
        }
    }

    private static File _getBuildDir(Build build) {
        if (build != null) {
            return new File(build.getBuildDirPath());
        }
        String buildDir = System.getenv("BUILD_DIR");
        if (!JenkinsResultsParserUtil.isNullOrEmpty(buildDir)) {
            return new File(buildDir);
        }
        return new File(JenkinsResultsParserUtil.getBuildDirPath());
    }
}

