/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsMaster;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.JenkinsSlave;
import com.liferay.jenkins.results.parser.Job;
import com.liferay.jenkins.results.parser.ParallelExecutor;
import com.liferay.jenkins.results.parser.TestSuiteJob;
import com.liferay.jenkins.results.parser.job.property.JobProperty;
import com.liferay.jenkins.results.parser.job.property.JobPropertyFactory;
import com.liferay.jenkins.results.parser.test.clazz.group.AxisTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.BatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalBatchTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.FunctionalSegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.SegmentTestClassGroup;
import com.liferay.jenkins.results.parser.test.clazz.group.TestClassGroupFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseJob
implements Job {
    protected final List<File> jobPropertiesFiles = new ArrayList<File>();
    protected JSONObject jsonObject;
    private static final Integer _THREAD_COUNT = 20;
    private static final ExecutorService _executorService = JenkinsResultsParserUtil.getNewThreadPoolExecutor(_THREAD_COUNT, true);
    private List<BatchTestClassGroup> _batchTestClassGroups;
    private final Job.BuildProfile _buildProfile;
    private List<BatchTestClassGroup> _dependentBatchTestClassGroups;
    private boolean _initializeJobProperties;
    private final String _jobName;
    private final List<JobProperty> _jobProperties = new ArrayList<JobProperty>();

    @Override
    public int getAxisCount() {
        List<AxisTestClassGroup> axisTestClassGroups = this.getAxisTestClassGroups();
        if (axisTestClassGroups == null) {
            return 0;
        }
        return axisTestClassGroups.size();
    }

    @Override
    public List<AxisTestClassGroup> getAxisTestClassGroups() {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            axisTestClassGroups.addAll(batchTestClassGroup.getAxisTestClassGroups());
        }
        return axisTestClassGroups;
    }

    @Override
    public Set<String> getBatchNames() {
        TreeSet<String> batchNames = new TreeSet<String>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            batchNames.add(batchTestClassGroup.getBatchName());
        }
        return batchNames;
    }

    @Override
    public List<BatchTestClassGroup> getBatchTestClassGroups() {
        if (this._batchTestClassGroups != null) {
            return this._batchTestClassGroups;
        }
        if (this.jsonObject != null && this.jsonObject.has("batches")) {
            this._batchTestClassGroups = new ArrayList<BatchTestClassGroup>();
            JSONArray batchesJSONArray = this.jsonObject.getJSONArray("batches");
            for (int i = 0; i < batchesJSONArray.length(); ++i) {
                JSONObject batchJSONObject = batchesJSONArray.getJSONObject(i);
                if (batchJSONObject == null) continue;
                this._batchTestClassGroups.add(TestClassGroupFactory.newBatchTestClassGroup(this, batchJSONObject));
            }
            return this._batchTestClassGroups;
        }
        this._batchTestClassGroups = this.getBatchTestClassGroups(this.getRawBatchNames());
        if (this.jsonObject != null) {
            JSONArray batchesJSONArray = new JSONArray();
            for (BatchTestClassGroup batchTestClassGroup : this._batchTestClassGroups) {
                batchesJSONArray.put((Object)batchTestClassGroup.getJSONObject());
            }
            this.jsonObject.put("batches", (Object)batchesJSONArray);
        }
        return this._batchTestClassGroups;
    }

    @Override
    public List<Build> getBuildHistory(JenkinsMaster jenkinsMaster) {
        JSONObject jobJSONObject = this.getJobJSONObject(jenkinsMaster, "builds[number]");
        JSONArray buildsJSONArray = jobJSONObject.getJSONArray("builds");
        ArrayList<Build> builds = new ArrayList<Build>(buildsJSONArray.length());
        for (int i = 0; i < buildsJSONArray.length(); ++i) {
            JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
            builds.add(BuildFactory.newBuild(JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this.getJobName(), "/", String.valueOf(buildJSONObject.getInt("number"))), null));
        }
        return builds;
    }

    @Override
    public Job.BuildProfile getBuildProfile() {
        return this._buildProfile;
    }

    @Override
    public List<AxisTestClassGroup> getDependentAxisTestClassGroups() {
        ArrayList<AxisTestClassGroup> axisTestClassGroups = new ArrayList<AxisTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            axisTestClassGroups.addAll(batchTestClassGroup.getAxisTestClassGroups());
        }
        return axisTestClassGroups;
    }

    @Override
    public Set<String> getDependentBatchNames() {
        TreeSet<String> batchNames = new TreeSet<String>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            batchNames.add(batchTestClassGroup.getBatchName());
        }
        return batchNames;
    }

    @Override
    public List<BatchTestClassGroup> getDependentBatchTestClassGroups() {
        if (this._dependentBatchTestClassGroups != null) {
            return this._dependentBatchTestClassGroups;
        }
        if (this.jsonObject != null && this.jsonObject.has("smoke_batches")) {
            this._dependentBatchTestClassGroups = new ArrayList<BatchTestClassGroup>();
            JSONArray smokeBatchesJSONArray = this.jsonObject.getJSONArray("smoke_batches");
            for (int i = 0; i < smokeBatchesJSONArray.length(); ++i) {
                JSONObject smokeBatchJSONObject = smokeBatchesJSONArray.getJSONObject(i);
                if (smokeBatchJSONObject == null) continue;
                this._dependentBatchTestClassGroups.add(TestClassGroupFactory.newBatchTestClassGroup(this, smokeBatchJSONObject));
            }
            return this._dependentBatchTestClassGroups;
        }
        this._dependentBatchTestClassGroups = this.getBatchTestClassGroups(this.getRawDependentBatchNames());
        if (this.jsonObject != null) {
            JSONArray smokeBatchesJSONArray = new JSONArray();
            for (BatchTestClassGroup batchTestClassGroup : this._dependentBatchTestClassGroups) {
                smokeBatchesJSONArray.put((Object)batchTestClassGroup.getJSONObject());
            }
            this.jsonObject.put("smoke_batches", (Object)smokeBatchesJSONArray);
        }
        return this._dependentBatchTestClassGroups;
    }

    @Override
    public Set<String> getDependentSegmentNames() {
        TreeSet<String> segmentNames = new TreeSet<String>();
        for (SegmentTestClassGroup segmentTestClassGroup : this.getDependentSegmentTestClassGroups()) {
            segmentNames.add(segmentTestClassGroup.getSegmentName());
        }
        return segmentNames;
    }

    @Override
    public List<SegmentTestClassGroup> getDependentSegmentTestClassGroups() {
        ArrayList<SegmentTestClassGroup> segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getDependentBatchTestClassGroups()) {
            segmentTestClassGroups.addAll(batchTestClassGroup.getSegmentTestClassGroups());
        }
        return segmentTestClassGroups;
    }

    @Override
    public List<String> getDistNodes() {
        try {
            List<JenkinsMaster> jenkinsMasters = JenkinsResultsParserUtil.getJenkinsMasters(JenkinsResultsParserUtil.getBuildProperties(), this._getSlaveRAMMinimumDefault(), this._getSlavesPerHostDefault(), JenkinsResultsParserUtil.getCohortName());
            int axisCount = this.getAxisCount();
            int distNodeAxisCount = this._getDistNodeAxisCount();
            int distNodeCount = axisCount / distNodeAxisCount;
            if (axisCount % distNodeAxisCount > 0) {
                ++distNodeCount;
            }
            distNodeCount = Math.min(distNodeCount, jenkinsMasters.size());
            distNodeCount = Math.max(distNodeCount, this._getDistNodeCountMinimum());
            List<JenkinsSlave> jenkinsSlaves = JenkinsResultsParserUtil.getReachableJenkinsSlaves(jenkinsMasters, distNodeCount);
            ArrayList<String> distNodes = new ArrayList<String>();
            for (JenkinsSlave jenkinsSlave : jenkinsSlaves) {
                distNodes.add(jenkinsSlave.getName());
            }
            return distNodes;
        }
        catch (IOException ioException) {
            return new ArrayList<String>();
        }
    }

    @Override
    public Job.DistType getDistType() {
        return Job.DistType.CI;
    }

    @Override
    public Set<String> getDistTypes() {
        JobProperty jobProperty = this.getJobProperty("test.batch.dist.app.servers");
        return this.getSetFromString(jobProperty.getValue());
    }

    @Override
    public Set<String> getDistTypesExcludingTomcat() {
        TreeSet<String> distTypesExcludingTomcat = new TreeSet<String>(this.getDistTypes());
        distTypesExcludingTomcat.remove("tomcat");
        return distTypesExcludingTomcat;
    }

    @Override
    public String getJobName() {
        return this._jobName;
    }

    @Override
    public List<File> getJobPropertiesFiles() {
        return this.jobPropertiesFiles;
    }

    @Override
    public List<String> getJobPropertyOptions() {
        ArrayList<String> jobPropertyOptions = new ArrayList<String>();
        jobPropertyOptions.add(String.valueOf((Object)this.getBuildProfile()));
        String jobName = this.getJobName();
        jobPropertyOptions.add(jobName);
        if (jobName.contains("(")) {
            jobPropertyOptions.add(jobName.substring(0, jobName.indexOf("(")));
        }
        jobPropertyOptions.removeAll(Collections.singleton(null));
        return jobPropertyOptions;
    }

    @Override
    public String getJobURL(JenkinsMaster jenkinsMaster) {
        return JenkinsResultsParserUtil.combine(jenkinsMaster.getURL(), "/job/", this._jobName);
    }

    @Override
    public JSONObject getJSONObject() {
        if (this.jsonObject != null) {
            return this.jsonObject;
        }
        this.jsonObject = new JSONObject();
        List<BatchTestClassGroup> batchTestClassGroups = this.getBatchTestClassGroups();
        if (batchTestClassGroups != null && !batchTestClassGroups.isEmpty()) {
            JSONArray batchesJSONArray = new JSONArray();
            for (BatchTestClassGroup batchTestClassGroup : batchTestClassGroups) {
                batchesJSONArray.put((Object)batchTestClassGroup.getJSONObject());
            }
            this.jsonObject.put("batches", (Object)batchesJSONArray);
        }
        this.jsonObject.put("build_profile", (Object)String.valueOf((Object)this.getBuildProfile()));
        this.jsonObject.put("job_name", (Object)this.getJobName());
        this.jsonObject.put("job_properties", this._getJobPropertiesMap());
        this.jsonObject.put("job_property_options", this.getJobPropertyOptions());
        List<BatchTestClassGroup> dependentBatchTestClassGroups = this.getDependentBatchTestClassGroups();
        if (dependentBatchTestClassGroups != null && !dependentBatchTestClassGroups.isEmpty()) {
            JSONArray smokeBatchesJSONArray = new JSONArray();
            for (BatchTestClassGroup batchTestClassGroup : dependentBatchTestClassGroups) {
                smokeBatchesJSONArray.put((Object)batchTestClassGroup.getJSONObject());
            }
            this.jsonObject.put("smoke_batches", (Object)smokeBatchesJSONArray);
        }
        if (this instanceof TestSuiteJob) {
            TestSuiteJob testSuiteJob = (TestSuiteJob)((Object)this);
            this.jsonObject.put("test_suite_name", (Object)testSuiteJob.getTestSuiteName());
        }
        return this.jsonObject;
    }

    @Override
    public Set<String> getSegmentNames() {
        TreeSet<String> segmentNames = new TreeSet<String>();
        for (SegmentTestClassGroup segmentTestClassGroup : this.getSegmentTestClassGroups()) {
            segmentNames.add(segmentTestClassGroup.getSegmentName());
        }
        return segmentNames;
    }

    @Override
    public List<SegmentTestClassGroup> getSegmentTestClassGroups() {
        ArrayList<SegmentTestClassGroup> segmentTestClassGroups = new ArrayList<SegmentTestClassGroup>();
        for (BatchTestClassGroup batchTestClassGroup : this.getBatchTestClassGroups()) {
            segmentTestClassGroups.addAll(batchTestClassGroup.getSegmentTestClassGroups());
        }
        return segmentTestClassGroups;
    }

    @Override
    public String getTestPropertiesContent() {
        HashMap<String, Properties> propertiesMap = new HashMap<String, Properties>();
        ArrayList<BatchTestClassGroup> batchTestClassGroups = new ArrayList<BatchTestClassGroup>(this.getBatchTestClassGroups());
        batchTestClassGroups.addAll(this.getDependentBatchTestClassGroups());
        for (BatchTestClassGroup batchTestClassGroup : batchTestClassGroups) {
            Properties batchProperties = new Properties();
            batchProperties.setProperty("test.batch.cohort.name", batchTestClassGroup.getCohortName());
            batchProperties.setProperty("test.batch.job.name", batchTestClassGroup.getBatchJobName());
            batchProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(batchTestClassGroup.getMaximumSlavesPerHost()));
            batchProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(batchTestClassGroup.getMinimumSlaveRAM()));
            batchProperties.setProperty("test.batch.slave.label", batchTestClassGroup.getSlaveLabel());
            if (batchTestClassGroup instanceof FunctionalBatchTestClassGroup) {
                FunctionalBatchTestClassGroup functionalBatchTestClassGroup = (FunctionalBatchTestClassGroup)batchTestClassGroup;
                String testBatchRunPropertyQuery = functionalBatchTestClassGroup.getTestBatchRunPropertyQuery();
                if (testBatchRunPropertyQuery != null) {
                    batchProperties.setProperty("test.batch.run.property.query", testBatchRunPropertyQuery);
                }
            } else {
                batchProperties.setProperty("test.batch.size", String.valueOf(batchTestClassGroup.getAxisCount()));
            }
            propertiesMap.put(batchTestClassGroup.getBatchName(), batchProperties);
            for (int i = 0; i < batchTestClassGroup.getSegmentCount(); ++i) {
                Properties segmentProperties = new Properties();
                SegmentTestClassGroup segmentTestClassGroup = batchTestClassGroup.getSegmentTestClassGroup(i);
                segmentProperties.setProperty("test.batch.cohort.name", segmentTestClassGroup.getCohortName());
                segmentProperties.setProperty("test.batch.job.name", segmentTestClassGroup.getBatchJobName());
                segmentProperties.setProperty("test.batch.maximum.slaves.per.host", String.valueOf(segmentTestClassGroup.getMaximumSlavesPerHost()));
                segmentProperties.setProperty("test.batch.minimum.slave.ram", String.valueOf(segmentTestClassGroup.getMinimumSlaveRAM()));
                segmentProperties.setProperty("test.batch.name", segmentTestClassGroup.getBatchName());
                segmentProperties.setProperty("test.batch.size", String.valueOf(segmentTestClassGroup.getAxisCount()));
                segmentProperties.setProperty("test.batch.slave.label", segmentTestClassGroup.getSlaveLabel());
                String testCasePropertiesContent = segmentTestClassGroup.getTestCasePropertiesContent();
                if (testCasePropertiesContent != null) {
                    testCasePropertiesContent = testCasePropertiesContent.replaceAll("\n", "\\${line.separator}");
                    segmentProperties.setProperty("test.case.properties", testCasePropertiesContent);
                }
                if (segmentTestClassGroup instanceof FunctionalSegmentTestClassGroup) {
                    segmentProperties.setProperty("run.test.case.method.group", String.valueOf(i));
                }
                propertiesMap.put(segmentTestClassGroup.getSegmentName(), segmentProperties);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry propertiesEntry : propertiesMap.entrySet()) {
            Properties properties = (Properties)propertiesEntry.getValue();
            for (String propertyName : properties.stringPropertyNames()) {
                sb.append(propertyName);
                sb.append("[");
                sb.append((String)propertiesEntry.getKey());
                sb.append("]=");
                sb.append(properties.getProperty(propertyName));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isSegmentEnabled() {
        JobProperty jobProperty = this.getJobProperty("test.batch.segment.enabled");
        String segmentEnabled = jobProperty.getValue();
        return segmentEnabled != null && segmentEnabled.equals("true");
    }

    @Override
    public boolean isValidationRequired() {
        return false;
    }

    @Override
    public boolean testReleaseBundle() {
        JobProperty jobProperty = this.getJobProperty("test.release.bundle");
        if (jobProperty != null) {
            this.recordJobProperty(jobProperty);
            return Boolean.parseBoolean(jobProperty.getValue());
        }
        return false;
    }

    @Override
    public boolean testRelevantChanges() {
        JobProperty jobProperty = this.getJobProperty("test.relevant.changes");
        if (jobProperty != null) {
            this.recordJobProperty(jobProperty);
            return Boolean.parseBoolean(jobProperty.getValue());
        }
        return false;
    }

    protected BaseJob(Job.BuildProfile buildProfile, String jobName) {
        this._buildProfile = buildProfile;
        this._jobName = jobName;
    }

    protected BaseJob(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        this._buildProfile = Job.BuildProfile.getByString(jsonObject.getString("build_profile"));
        this._jobName = jsonObject.getString("job_name");
    }

    protected List<BatchTestClassGroup> getBatchTestClassGroups(Set<String> rawBatchNames) {
        if (rawBatchNames == null || rawBatchNames.isEmpty()) {
            return new ArrayList<BatchTestClassGroup>();
        }
        long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
        System.out.println(JenkinsResultsParserUtil.combine("Started creating ", String.valueOf(rawBatchNames.size()), " batch test class groups at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
        ArrayList callables = new ArrayList();
        final BaseJob job = this;
        for (final String batchName : rawBatchNames) {
            callables.add(new Callable<BatchTestClassGroup>(){
                private final Integer _pauseRetryCount = 2;
                private final Integer _pauseRetryDuration = 5000;

                @Override
                public BatchTestClassGroup call() throws Exception {
                    for (int i = 0; i < this._pauseRetryCount; ++i) {
                        try {
                            return this._call();
                        }
                        catch (Exception exception) {
                            System.out.println(JenkinsResultsParserUtil.combine("Retry creating a test class group in ", String.valueOf(this._pauseRetryDuration / 1000), " seconds."));
                            JenkinsResultsParserUtil.sleep(this._pauseRetryDuration.intValue());
                            continue;
                        }
                    }
                    return this._call();
                }

                private BatchTestClassGroup _call() throws Exception {
                    long start = JenkinsResultsParserUtil.getCurrentTimeMillis();
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Started batch test class ", "group at ", JenkinsResultsParserUtil.toDateString(new Date(start))));
                    BatchTestClassGroup batchTestClassGroup = TestClassGroupFactory.newBatchTestClassGroup(batchName, job);
                    long duration = JenkinsResultsParserUtil.getCurrentTimeMillis() - start;
                    System.out.println(JenkinsResultsParserUtil.combine("[", batchName, "] Completed batch test class ", "group in ", JenkinsResultsParserUtil.toDurationString(duration), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
                    if (batchTestClassGroup.getAxisCount() <= 0) {
                        return null;
                    }
                    return batchTestClassGroup;
                }
            });
        }
        ParallelExecutor parallelExecutor = new ParallelExecutor(callables, _executorService);
        List<BatchTestClassGroup> batchTestClassGroups = parallelExecutor.execute();
        batchTestClassGroups.removeAll(Collections.singleton(null));
        System.out.println(JenkinsResultsParserUtil.combine("Completed creating ", String.valueOf(batchTestClassGroups.size()), " batch test class groups in ", JenkinsResultsParserUtil.toDurationString(JenkinsResultsParserUtil.getCurrentTimeMillis() - start), " at ", JenkinsResultsParserUtil.toDateString(new Date())));
        return batchTestClassGroups;
    }

    protected JSONObject getJobJSONObject(JenkinsMaster jenkinsMaster, String tree) {
        if (this.getJobURL(jenkinsMaster) == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(this.getJobURL(jenkinsMaster)));
        sb.append("/api/json?pretty");
        if (tree != null) {
            sb.append("&tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Unable to get job JSON", ioException);
        }
    }

    protected JobProperty getJobProperty(String basePropertyName) {
        return JobPropertyFactory.newJobProperty(basePropertyName, null, null, this, null, null, true);
    }

    protected JobProperty getJobProperty(String basePropertyName, boolean useBasePropertyName) {
        return JobPropertyFactory.newJobProperty(basePropertyName, null, null, this, null, null, useBasePropertyName);
    }

    protected Set<String> getRawBatchNames() {
        JobProperty jobProperty = this.getJobProperty("test.batch.names");
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    protected Set<String> getRawDependentBatchNames() {
        JobProperty jobProperty = this.getJobProperty("test.batch.names.smoke");
        this.recordJobProperty(jobProperty);
        return this.getSetFromString(jobProperty.getValue());
    }

    protected Set<String> getSetFromString(String string) {
        TreeSet<String> set = new TreeSet<String>();
        if (JenkinsResultsParserUtil.isNullOrEmpty(string)) {
            return set;
        }
        for (String item : StringUtils.split((String)string, (String)",")) {
            if (item.startsWith("#")) continue;
            set.add(item.trim());
        }
        return set;
    }

    protected void recordJobProperty(JobProperty jobProperty) {
        if (jobProperty == null || this._jobProperties.contains(jobProperty)) {
            return;
        }
        this._jobProperties.add(jobProperty);
    }

    private int _getDistNodeAxisCount() {
        try {
            String distNodeAxisCount = JenkinsResultsParserUtil.getBuildProperty("dist.node.axis.count");
            if (JenkinsResultsParserUtil.isInteger(distNodeAxisCount)) {
                return Integer.parseInt(distNodeAxisCount);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 25;
    }

    private int _getDistNodeCountMinimum() {
        try {
            String distNodeCountMinimum = JenkinsResultsParserUtil.getBuildProperty("dist.node.count.minimum");
            if (JenkinsResultsParserUtil.isInteger(distNodeCountMinimum)) {
                return Integer.parseInt(distNodeCountMinimum);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Properties> _getJobPropertiesMap() {
        List<JobProperty> list = this._jobProperties;
        synchronized (list) {
            if (!this._initializeJobProperties) {
                this.getBatchTestClassGroups();
                this.getDependentBatchTestClassGroups();
                this._initializeJobProperties = true;
            }
        }
        TreeMap<String, Properties> jobPropertiesMap = new TreeMap<String, Properties>();
        for (JobProperty jobProperty : this._jobProperties) {
            String jobPropertyValue;
            if (jobProperty == null || (jobPropertyValue = jobProperty.getValue()) == null) continue;
            String propertiesFilePath = jobProperty.getPropertiesFilePath();
            Properties properties = (Properties)jobPropertiesMap.get(propertiesFilePath);
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty(jobProperty.getName(), jobPropertyValue);
            jobPropertiesMap.put(propertiesFilePath, properties);
        }
        return jobPropertiesMap;
    }

    private int _getSlaveRAMMinimumDefault() {
        try {
            String slaveRAMMinimumDefault = JenkinsResultsParserUtil.getBuildProperty("slave.ram.minimum.default");
            if (JenkinsResultsParserUtil.isInteger(slaveRAMMinimumDefault)) {
                return Integer.parseInt(slaveRAMMinimumDefault);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 16;
    }

    private int _getSlavesPerHostDefault() {
        try {
            String slavesPerHostDefault = JenkinsResultsParserUtil.getBuildProperty("slaves.per.host.default");
            if (JenkinsResultsParserUtil.isInteger(slavesPerHostDefault)) {
                return Integer.parseInt(slavesPerHostDefault);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 2;
    }
}

