/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Host;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class BaseHost
implements Host {
    private final List<Host.HostService> _hostServices = new ArrayList<Host.HostService>();
    private final String _name;

    @Override
    public void cleanUpServices() {
        for (Host.HostService hostService : this._hostServices) {
            try {
                hostService.cleanUpService();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    protected BaseHost(String name) {
        this._name = name;
        try {
            Properties jenkinsProperties = JenkinsResultsParserUtil.getJenkinsProperties();
            if (!jenkinsProperties.containsKey(name)) {
                return;
            }
            String serviceNames = jenkinsProperties.getProperty(name);
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties(false);
            for (String serviceID : serviceNames.split(",")) {
                String serviceCleanCommand = buildProperties.getProperty("service.clean.command[" + serviceID + "]", "");
                String serviceName = buildProperties.getProperty("service.name[" + serviceID + "]", "");
                if (serviceCleanCommand.isEmpty() || serviceName.isEmpty()) continue;
                this._hostServices.add(new Host.HostService(serviceName, serviceCleanCommand));
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

