/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitRepository;
import java.io.File;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseGitRepository
implements GitRepository {
    private static final String[] _KEYS_REQUIRED = new String[]{"name"};
    private final JSONObject _jsonObject;

    @Override
    public JSONObject getJSONObject() {
        return this._jsonObject;
    }

    @Override
    public String getName() {
        return this.getString("name");
    }

    @Override
    public boolean isSubrepository() {
        String name = this.getName();
        return name.startsWith("com-liferay-");
    }

    protected BaseGitRepository(JSONObject jsonObject) {
        this._jsonObject = jsonObject;
        this.validateKeys(_KEYS_REQUIRED);
    }

    protected BaseGitRepository(String name) {
        this._jsonObject = new JSONObject();
        this._setName(name);
        this.validateKeys(_KEYS_REQUIRED);
    }

    protected File getFile(String key) {
        return new File(this.getString(key));
    }

    protected JSONArray getJSONArray(String key) {
        return this._jsonObject.getJSONArray(key);
    }

    protected String getString(String key) {
        return this._jsonObject.getString(key);
    }

    protected boolean has(String key) {
        return this._jsonObject.has(key);
    }

    protected String optString(String key) {
        return this._jsonObject.optString(key);
    }

    protected String optString(String key, String defaultValue) {
        return this._jsonObject.optString(key, defaultValue);
    }

    protected void put(String key, Object value) {
        this._jsonObject.put(key, value);
    }

    protected void validateKeys(String[] requiredKeys) {
        for (String requiredKey : requiredKeys) {
            if (this.has(requiredKey)) continue;
            throw new RuntimeException("Missing " + requiredKey);
        }
    }

    private void _setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name is null");
        }
        this.put("name", name);
    }
}

