/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuildData;
import com.liferay.jenkins.results.parser.BatchBuildData;
import com.liferay.jenkins.results.parser.BuildDataFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuildData;
import java.util.List;
import java.util.Map;

public abstract class BaseBatchBuildData
extends BaseBuildData
implements BatchBuildData {
    private static final String[] _KEYS_REQUIRED = new String[]{"batch_name", "top_level_run_id", "test_list"};
    private TopLevelBuildData _topLevelBuildData;

    @Override
    public String getBatchName() {
        return this.getString("batch_name");
    }

    @Override
    public List<String> getTestList() {
        return this.getList("test_list");
    }

    @Override
    public TopLevelBuildData getTopLevelBuildData() {
        TopLevelBuildData topLevelBuildData;
        if (this._topLevelBuildData != null) {
            return this._topLevelBuildData;
        }
        String topLevelJobName = this.getJobName();
        topLevelJobName = topLevelJobName.replace("-batch", "");
        this._topLevelBuildData = topLevelBuildData = BuildDataFactory.newTopLevelBuildData(this.getTopLevelRunID(), topLevelJobName, null);
        return this._topLevelBuildData;
    }

    @Override
    public Integer getTopLevelBuildNumber() {
        TopLevelBuildData topLevelBuildData = this.getTopLevelBuildData();
        return topLevelBuildData.getBuildNumber();
    }

    @Override
    public Map<String, String> getTopLevelBuildParameters() {
        TopLevelBuildData topLevelBuildData = this.getTopLevelBuildData();
        return topLevelBuildData.getBuildParameters();
    }

    @Override
    public String getTopLevelJobName() {
        TopLevelBuildData topLevelBuildData = this.getTopLevelBuildData();
        return topLevelBuildData.getJobName();
    }

    @Override
    public String getTopLevelMasterHostname() {
        TopLevelBuildData topLevelBuildData = this.getTopLevelBuildData();
        return topLevelBuildData.getMasterHostname();
    }

    @Override
    public String getTopLevelRunID() {
        return this.optString("top_level_run_id");
    }

    @Override
    public void setBatchName(String batchName) {
        this.put("batch_name", batchName);
    }

    @Override
    public void setTestList(List<String> testList) {
        this.put("test_list", testList);
    }

    protected BaseBatchBuildData(String runID, String jobName, String buildURL) {
        super(BaseBatchBuildData._getDefaultRunID(runID), jobName, buildURL);
        if (buildURL == null) {
            return;
        }
        this._setTopLevelRunID();
        this.validateKeys(_KEYS_REQUIRED);
    }

    private static String _getDefaultRunID(String runID) {
        if (runID != null) {
            return runID;
        }
        return "batch_" + JenkinsResultsParserUtil.getDistinctTimeStamp();
    }

    private void _setTopLevelRunID() {
        String topLevelRunID = System.getenv("TOP_LEVEL_RUN_ID");
        if (topLevelRunID == null) {
            throw new RuntimeException("Please set TOP_LEVEL_RUN_ID");
        }
        this.put("top_level_run_id", topLevelRunID);
    }
}

