/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.Project;

public class AppServer {
    private final Project _project;

    public AppServer(Project project) {
        this._project = project;
    }

    public String getType() {
        return this._project.getProperty("app.server.type");
    }

    public void startService() {
        JenkinsResultsParserUtil.executeBashCommandService(this._getStartCommand(), this._getBinDir(), this._getEnvironments(), this._getMaxLogSize());
        String type = this.getType();
        if (type.contains("websphere")) {
            JenkinsResultsParserUtil.executeBashCommandService(this._getReadLiferayLogCommand(), this._getAppServerParentDir(), this._getEnvironments(), this._getMaxLogSize());
        }
    }

    public void stopService() {
        JenkinsResultsParserUtil.executeBashCommandService(this._getStopCommand(), this._getBinDir(), this._getEnvironments(), this._getMaxLogSize());
    }

    private File _getAppServerParentDir() {
        String appServerParentDirString = this._project.getProperty("test.app.server.parent.dir");
        if (appServerParentDirString == null) {
            appServerParentDirString = this._project.getProperty("app.server.parent.dir");
        }
        return new File(appServerParentDirString);
    }

    private File _getBinDir() {
        String binDirString = this._project.getProperty("test.app.server.bin.dir");
        if (binDirString == null) {
            binDirString = this._project.getProperty("app.server.bin.dir");
        }
        if (binDirString == null) {
            binDirString = this._project.getProperty(JenkinsResultsParserUtil.combine("app.server.", this.getType(), ".bin.dir"));
        }
        return new File(binDirString);
    }

    private Map<String, String> _getEnvironments() {
        HashMap<String, String> environments = new HashMap<String, String>();
        environments.put("JAVA_HOME", this._getJavaHome());
        environments.put("JAVA_OPTS", this._getJavaOpts());
        environments.put("PATH", this._getPath());
        for (Map.Entry environment : environments.entrySet()) {
            if (environment.getValue() != null) continue;
            environments.remove(environment.getKey());
        }
        return environments;
    }

    private String _getJavaHome() {
        String javaHome = this._project.getProperty("java.jdk.home");
        if (javaHome == null) {
            javaHome = this._project.getProperty("env.JAVA_HOME");
        }
        if (javaHome == null) {
            javaHome = System.getenv("JAVA_HOME");
        }
        return javaHome;
    }

    private String _getJavaOpts() {
        String javaOpts = this._project.getProperty("java.jdk.opts");
        if (javaOpts == null) {
            javaOpts = this._project.getProperty("env.JAVA_OPTS");
        }
        if (javaOpts == null) {
            javaOpts = System.getenv("JAVA_OPTS");
        }
        return javaOpts;
    }

    private long _getMaxLogSize() {
        String appServerMaxLogSizeInMB = this._project.getProperty("app.server.max.log.size.in.mb");
        if (appServerMaxLogSizeInMB == null) {
            appServerMaxLogSizeInMB = "5";
        }
        return Long.valueOf(appServerMaxLogSizeInMB) * 1024L * 1024L;
    }

    private String _getPath() {
        String javaHome;
        String path = this._project.getProperty("env.PATH");
        if (path == null) {
            path = System.getenv("PATH");
        }
        if ((javaHome = this._getJavaHome()) == null || javaHome.isEmpty()) {
            return path;
        }
        if (JenkinsResultsParserUtil.isWindows()) {
            return path.replaceAll("[^;]+\\\\jdk[^\\\\]*\\\\[^;]*bin", javaHome.replaceAll("\\\\", "\\\\\\\\") + "\\\\bin");
        }
        return path.replaceAll("[^:]+/jdk[^/]*/[^:]*bin", javaHome + "/bin");
    }

    private String _getReadLiferayLogCommand() {
        StringBuilder sb = new StringBuilder();
        sb.append("#!/bin/bash\n");
        sb.append("while [ ! -f logs/liferay.*.log ]\n");
        sb.append("do\n");
        sb.append("sleep 1;\n");
        sb.append("done\n");
        sb.append("tail -f logs/liferay.*.log;");
        File file = new File(this._getAppServerParentDir(), "read_liferay_log.sh");
        try {
            JenkinsResultsParserUtil.write(file, sb.toString());
            return file.getCanonicalPath();
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private String _getStartCommand() {
        return JenkinsResultsParserUtil.combine(this._getStartExecutable(), " ", this._getStartExecutableArgLine());
    }

    private String _getStartExecutable() {
        String startExecutable = this._project.getProperty("app.server.start.executable");
        if (startExecutable == null || startExecutable.isEmpty()) {
            startExecutable = this._project.getProperty(JenkinsResultsParserUtil.combine("app.server.", this.getType(), ".start.executable"));
        }
        return startExecutable.replace(".bat", ".sh");
    }

    private String _getStartExecutableArgLine() {
        String startExecutableArgLine = this._project.getProperty("app.server.start.executable.arg.line");
        if (startExecutableArgLine == null || startExecutableArgLine.isEmpty()) {
            startExecutableArgLine = this._project.getProperty(JenkinsResultsParserUtil.combine("app.server.", this.getType(), ".start.executable.arg.line"));
        }
        return startExecutableArgLine;
    }

    private String _getStopCommand() {
        return JenkinsResultsParserUtil.combine(this._getStopExecutable(), " ", this._getStopExecutableArgLine());
    }

    private String _getStopExecutable() {
        String stopExecutable = this._project.getProperty("app.server.stop.executable");
        if (stopExecutable == null || stopExecutable.isEmpty()) {
            stopExecutable = this._project.getProperty(JenkinsResultsParserUtil.combine("app.server.", this.getType(), ".stop.executable"));
        }
        return stopExecutable.replace(".bat", ".sh");
    }

    private String _getStopExecutableArgLine() {
        String stopExecutableArgLine = this._project.getProperty("app.server.stop.executable.arg.line");
        if (stopExecutableArgLine == null || stopExecutableArgLine.isEmpty()) {
            stopExecutableArgLine = this._project.getProperty(JenkinsResultsParserUtil.combine("app.server.", this.getType(), ".stop.executable.arg.line"));
        }
        return stopExecutableArgLine;
    }
}

