/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.text.Collator;
import java.util.Locale;

public class GroupDescriptiveNameComparator
extends OrderByComparator<Group> {
    public static final String ORDER_BY_ASC = "groupName ASC";
    public static final String ORDER_BY_DESC = "groupName DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"groupName"};
    private static final Log _log = LogFactoryUtil.getLog(GroupDescriptiveNameComparator.class);
    private final boolean _ascending;
    private final Collator _collator;
    private final Locale _locale;

    public GroupDescriptiveNameComparator() {
        this(false);
    }

    public GroupDescriptiveNameComparator(boolean ascending) {
        this(ascending, LocaleUtil.getDefault());
    }

    public GroupDescriptiveNameComparator(boolean ascending, Locale locale) {
        this._ascending = ascending;
        this._collator = CollatorUtil.getInstance(locale);
        this._locale = locale;
    }

    @Override
    public int compare(Group group1, Group group2) {
        String name2;
        String name1;
        block3: {
            name1 = "";
            name2 = "";
            try {
                name1 = group1.getDescriptiveName(this._locale);
                name2 = group2.getDescriptiveName(this._locale);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)portalException, portalException);
            }
        }
        int value = this._collator.compare(name1, name2);
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

