/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.javadoc.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaExecutable;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class JavadocFormatterUtil {
    private static final Pattern _deprecatedVersionPattern = Pattern.compile("As of (\\w+ \\([\\w.]+\\))");
    private static final Pattern _packagePattern = Pattern.compile("(\n|^)\\s*package (.*);\n");

    public static Document getDeprecationsDocument(String dirName) throws Exception {
        Document document = DocumentHelper.createDocument();
        Element rootElement = document.addElement("deprecations");
        String[] excludes = new String[]{"**/.git/**", "**/.gradle/**", "**/bin/**", "**/build/**", "**/classes/**", "**/node_modules/**", "**/node_modules_cache/**", "**/portal-client/**", "**/tmp/**"};
        List<String> fileNames = JavadocFormatterUtil.scanForFiles(dirName, excludes, new String[]{"**/*.java"});
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            File file = new File(dirName + fileName);
            String content = JavadocFormatterUtil.read(file);
            JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder();
            try {
                javaProjectBuilder.addSource((Reader)new UnsyncStringReader(content));
            }
            catch (Exception e) {
                continue;
            }
            String fullyQualifiedName = JavadocFormatterUtil._getFullyQualifiedName(fileName, content);
            JavaClass javaClass = javaProjectBuilder.getClassByName(fullyQualifiedName);
            JavadocFormatterUtil._parseClass(rootElement, javaClass, fullyQualifiedName);
        }
        return document;
    }

    public static String read(File file) throws IOException {
        String s = new String(Files.readAllBytes(file.toPath()), "UTF-8");
        return StringUtil.replace(s, "\r\n", "\n");
    }

    public static List<String> scanForFiles(String dirName, String[] excludes, String[] includes) throws Exception {
        final ArrayList<String> fileNames = new ArrayList<String>();
        FileSystem fileSystem = FileSystems.getDefault();
        final ArrayList<PathMatcher> excludeDirPathMatchers = new ArrayList<PathMatcher>();
        for (String exclude : excludes) {
            if (exclude.endsWith("/**")) {
                exclude = exclude.substring(0, exclude.length() - 3);
            }
            excludeDirPathMatchers.add(fileSystem.getPathMatcher("glob:" + exclude));
        }
        final ArrayList<PathMatcher> includeFilePathMatchers = new ArrayList<PathMatcher>();
        for (String include : includes) {
            includeFilePathMatchers.add(fileSystem.getPathMatcher("glob:" + include));
        }
        Files.walkFileTree(Paths.get(dirName, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                for (PathMatcher pathMatcher : excludeDirPathMatchers) {
                    if (!pathMatcher.matches(JavadocFormatterUtil._getCanonicalPath(dirPath))) continue;
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                for (PathMatcher pathMatcher : includeFilePathMatchers) {
                    if (!pathMatcher.matches(JavadocFormatterUtil._getCanonicalPath(filePath))) continue;
                    fileNames.add(filePath.toString());
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return fileNames;
    }

    public static String syncDeprecatedVersion(String value, JavaAnnotatedElement javaAnnotatedElement, String annotatedElementName, String fullyQualifiedName, Document deprecationsDocument) {
        Element rootElement = deprecationsDocument.getRootElement();
        if (rootElement == null) {
            return value;
        }
        String version = JavadocFormatterUtil._getDeprecatedVersion(value);
        if (version == null) {
            return value;
        }
        String expectedVersion = JavadocFormatterUtil._getExpectedVersion(rootElement, javaAnnotatedElement, annotatedElementName, fullyQualifiedName);
        if (expectedVersion == null) {
            return value;
        }
        if (!expectedVersion.equals(version)) {
            return StringUtil.replaceFirst(value, version, expectedVersion);
        }
        return value;
    }

    private static void _addDeprecation(Element rootElement, String name, JavaAnnotatedElement javaAnnotatedElement, String fullyQualifiedName) {
        List docletTags = javaAnnotatedElement.getTagsByName("deprecated");
        if (docletTags.isEmpty()) {
            return;
        }
        DocletTag docletTag = (DocletTag)docletTags.get(0);
        String version = JavadocFormatterUtil._getDeprecatedVersion(docletTag.getValue());
        if (version == null) {
            return;
        }
        Element deprecatedElement = rootElement.addElement("deprecated");
        deprecatedElement.addAttribute("fullyQualifiedName", fullyQualifiedName);
        deprecatedElement.addAttribute("name", name);
        Class<?> clazz = javaAnnotatedElement.getClass();
        deprecatedElement.addAttribute("type", clazz.getSimpleName());
        deprecatedElement.addAttribute("version", version);
        if (javaAnnotatedElement instanceof JavaExecutable) {
            JavaExecutable javaExecutable = (JavaExecutable)javaAnnotatedElement;
            List javaTypes = javaExecutable.getParameterTypes();
            deprecatedElement.addAttribute("signature", javaTypes.toString());
        }
    }

    private static Path _getCanonicalPath(Path path) {
        try {
            File file = path.toFile();
            File canonicalFile = file.getCanonicalFile();
            return canonicalFile.toPath();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static String _getDeprecatedVersion(String value) {
        Matcher matcher = _deprecatedVersionPattern.matcher(value);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static String _getExpectedVersion(Element rootElement, JavaAnnotatedElement javaAnnotatedElement, String annotatedElementName, String fullyQualifiedName) {
        for (Element deprecatedElement : rootElement.elements("deprecated")) {
            JavaExecutable javaExecutable;
            List javaTypes;
            String signature;
            Class<?> clazz;
            String type;
            if (!annotatedElementName.equals(deprecatedElement.attributeValue("name")) || !fullyQualifiedName.equals(deprecatedElement.attributeValue("fullyQualifiedName")) || !(type = (clazz = javaAnnotatedElement.getClass()).getSimpleName()).equals(deprecatedElement.attributeValue("type")) || javaAnnotatedElement instanceof JavaExecutable && !(signature = (javaTypes = (javaExecutable = (JavaExecutable)javaAnnotatedElement).getParameterTypes()).toString()).equals(deprecatedElement.attributeValue("signature"))) continue;
            return deprecatedElement.attributeValue("version");
        }
        return null;
    }

    private static String _getFullyQualifiedName(String fileName, String content) {
        Matcher matcher = _packagePattern.matcher(content);
        if (!matcher.find()) {
            return "";
        }
        int x = fileName.lastIndexOf(47);
        int y = fileName.lastIndexOf(46);
        return StringBundler.concat((String[])new String[]{matcher.group(2), ".", fileName.substring(x + 1, y)});
    }

    private static void _parseClass(Element rootElement, JavaClass javaClass, String fullyQualifiedName) {
        JavadocFormatterUtil._addDeprecation(rootElement, javaClass.getName(), (JavaAnnotatedElement)javaClass, fullyQualifiedName);
        for (JavaConstructor javaConstructor : javaClass.getConstructors()) {
            JavadocFormatterUtil._addDeprecation(rootElement, javaConstructor.getName(), (JavaAnnotatedElement)javaConstructor, fullyQualifiedName);
        }
        for (JavaMethod javaMethod : javaClass.getMethods()) {
            JavadocFormatterUtil._addDeprecation(rootElement, javaMethod.getName(), (JavaAnnotatedElement)javaMethod, fullyQualifiedName);
        }
        for (JavaField javaField : javaClass.getFields()) {
            JavadocFormatterUtil._addDeprecation(rootElement, javaField.getName(), (JavaAnnotatedElement)javaField, fullyQualifiedName);
        }
        for (JavaClass nestedJavaClass : javaClass.getNestedClasses()) {
            JavadocFormatterUtil._parseClass(rootElement, nestedJavaClass, fullyQualifiedName);
        }
    }
}

