/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.javadoc.formatter;

import com.liferay.javadoc.formatter.util.JavadocFormatterUtil;
import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.util.xml.Dom4jDocUtil;
import com.liferay.util.xml.XMLSafeReader;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaExecutable;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMember;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaModel;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class JavadocFormatter {
    private static final Pattern _paragraphTagPattern = Pattern.compile("(^.*?(?=\n\n|$)+|(?<=<p>\n).*?(?=\n</p>))", 32);
    private final String _author;
    private Document _deprecationsDocument;
    private final String _deprecationSyncDirName;
    private String _fullyQualifiedName;
    private final boolean _generateXml;
    private String _imports;
    private final boolean _initializeMissingJavadocs;
    private final String _inputDirName;
    private final Map<String, Tuple> _javadocxXmlTuples = new HashMap<String, Tuple>();
    private JavaProjectBuilder _javaProjectBuilder;
    private final Properties _languageProperties;
    private final File _languagePropertiesFile;
    private final Set<String> _modifiedFileNames = new HashSet<String>();
    private final String _outputFilePrefix;
    private String _packagePath;
    private final boolean _updateJavadocs;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            new JavadocFormatter(arguments);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public JavadocFormatter(Map<String, String> arguments) throws Exception {
        String outputFilePrefix;
        File languagePropertiesFile;
        String author;
        this._author = author = ArgumentsUtil.getString(arguments, "javadoc.author", "Brian Wing Shun Chan");
        this._deprecationSyncDirName = ArgumentsUtil.getString(arguments, "javadoc.deprecation.sync.dir", null);
        this._generateXml = GetterUtil.getBoolean(arguments.get("javadoc.generate.xml"));
        String init = arguments.get("javadoc.init");
        this._initializeMissingJavadocs = GetterUtil.getBoolean(init);
        String inputDirName = ArgumentsUtil.getString(arguments, "javadoc.input.dir", "./");
        if (!inputDirName.endsWith("/")) {
            inputDirName = inputDirName + "/";
        }
        this._inputDirName = inputDirName;
        System.out.println("Input directory is " + this._inputDirName);
        String[] limits = StringUtil.split(arguments.get("javadoc.limit"), ",");
        if (limits.length == 0) {
            limits = new String[]{""};
        }
        if (!(languagePropertiesFile = new File("src/content/Language.properties")).exists()) {
            languagePropertiesFile = new File("src/main/resources/content/Language.properties");
        }
        if (languagePropertiesFile.exists()) {
            this._languageProperties = new Properties();
            this._languagePropertiesFile = languagePropertiesFile;
            this._languageProperties.load(new FileInputStream(this._languagePropertiesFile.getAbsolutePath()));
        } else {
            this._languageProperties = null;
            this._languagePropertiesFile = null;
        }
        this._outputFilePrefix = outputFilePrefix = ArgumentsUtil.getString(arguments, "javadoc.output.file.prefix", "javadocs");
        this._updateJavadocs = GetterUtil.getBoolean(arguments.get("javadoc.update"));
        String[] excludes = new String[]{"**/.git/**", "**/.gradle/**", "**/bin/**", "**/build/**", "**/classes/**", "**/node_modules/**", "**/node_modules_cache/**", "**/portal-client/**", "**/tmp/**"};
        for (String limit : limits) {
            ArrayList<String> includes = new ArrayList<String>();
            if (Validator.isNotNull(limit) && !limit.startsWith("$")) {
                String[] limitArray;
                System.out.println("Limit on " + limit);
                for (String curLimit : limitArray = StringUtil.split(limit, '/')) {
                    includes.add("**/" + StringUtil.replace(curLimit, '.', '/') + "/**/*.java");
                    includes.add("**/" + curLimit + ".java");
                }
            } else {
                includes.add("**/*.java");
            }
            List<String> fileNames = JavadocFormatterUtil.scanForFiles(this._inputDirName, excludes, includes.toArray(new String[0]));
            if (fileNames.isEmpty() && Validator.isNotNull(limit) && !limit.startsWith("$")) {
                StringBundler sb = new StringBundler("Limit file not found: ");
                sb.append(limit);
                if (limit.contains(".")) {
                    sb.append(" Specify limit filename without package path ");
                    sb.append("or file type suffix.");
                }
                System.out.println(sb.toString());
            }
            for (String fileName : fileNames) {
                fileName = StringUtil.replace(fileName, '\\', '/');
                try {
                    this._format(fileName);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to format file " + fileName, e);
                }
            }
        }
        if (this._generateXml) {
            for (Map.Entry entry : this._javadocxXmlTuples.entrySet()) {
                String newJavadocsRuntimeXmlContent;
                Tuple tuple = (Tuple)entry.getValue();
                File javadocsXmlFile = (File)tuple.getObject(1);
                String oldJavadocsXmlContent = (String)tuple.getObject(2);
                Document javadocsXmlDocument = (Document)tuple.getObject(3);
                Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
                this._sortElementsByChildElement(javadocsXmlRootElement, "javadoc", "type");
                String newJavadocsXmlContent = this._formattedString((Node)javadocsXmlDocument);
                if (!oldJavadocsXmlContent.equals(newJavadocsXmlContent)) {
                    this._write(javadocsXmlFile, newJavadocsXmlContent);
                    this._modifiedFileNames.add(javadocsXmlFile.getAbsolutePath());
                }
                this._detachUnnecessaryTypes(javadocsXmlRootElement);
                File javadocsRuntimeXmlFile = new File(StringUtil.replaceLast(javadocsXmlFile.toString(), "-all.xml", "-rt.xml"));
                String oldJavadocsRuntimeXmlContent = "";
                if (javadocsRuntimeXmlFile.exists()) {
                    oldJavadocsRuntimeXmlContent = JavadocFormatterUtil.read(javadocsRuntimeXmlFile);
                }
                if (oldJavadocsRuntimeXmlContent.equals(newJavadocsRuntimeXmlContent = this._compactString((Node)javadocsXmlDocument))) continue;
                this._write(javadocsRuntimeXmlFile, newJavadocsRuntimeXmlContent);
                this._modifiedFileNames.add(javadocsRuntimeXmlFile.getAbsolutePath());
            }
        }
    }

    public Set<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    private void _addClassCommentElement(Element rootElement, JavaClass javaClass) {
        String comment = this._getCDATA((JavaAnnotatedElement)javaClass);
        if (comment.startsWith("Copyright (c)")) {
            comment = "";
        }
        if (Validator.isNull(comment)) {
            return;
        }
        Element commentElement = rootElement.addElement("comment");
        commentElement.addCDATA(comment);
    }

    private void _addClassDocletElements(Element parentElement, JavaClass javaClass, boolean nestedClass) throws Exception {
        Dom4jDocUtil.add(parentElement, "name", javaClass.getName());
        Dom4jDocUtil.add(parentElement, "type", javaClass.getFullyQualifiedName());
        this._addClassCommentElement(parentElement, javaClass);
        if (!nestedClass) {
            this._addDocletElements(parentElement, (JavaAnnotatedElement)javaClass, "author");
        }
        this._addParamElements(parentElement, javaClass, (List<DocletTag>)javaClass.getTagsByName("param"));
        this._addDocletElements(parentElement, (JavaAnnotatedElement)javaClass, "version");
        this._addDocletElements(parentElement, (JavaAnnotatedElement)javaClass, "see");
        this._addDocletElements(parentElement, (JavaAnnotatedElement)javaClass, "since");
        this._addDocletElements(parentElement, (JavaAnnotatedElement)javaClass, "serial");
        this._addDocletElements(parentElement, (JavaAnnotatedElement)javaClass, "deprecated");
        this._addDocletElements(parentElement, (JavaAnnotatedElement)javaClass, "review");
    }

    private void _addClassElement(Element parentElement, JavaClass javaClass, boolean nestedClass) throws Exception {
        Element classElement = null;
        classElement = nestedClass ? parentElement.addElement("class") : parentElement;
        this._addClassDocletElements(classElement, javaClass, nestedClass);
        List javaConstructors = javaClass.getConstructors();
        for (Object javaConstructor : javaConstructors) {
            this._addConstructorElement(classElement, (JavaConstructor)javaConstructor);
        }
        List javaMethods = javaClass.getMethods();
        for (Object javaMethod : javaMethods) {
            this._addMethodElement(classElement, (JavaMethod)javaMethod);
        }
        List javaFields = javaClass.getFields();
        for (JavaField javaField : javaFields) {
            this._addFieldElement(classElement, javaField);
        }
        List nestedJavaClasses = javaClass.getNestedClasses();
        for (JavaClass nestedJavaClass : nestedJavaClasses) {
            this._addClassElement(classElement, nestedJavaClass, true);
        }
    }

    private Map<Integer, String> _addComments(Map<Integer, String> commentsMap, Element classElement, JavaClass javaClass, String content, String[] lines) throws Exception {
        int lineNumber = this._getJavaModelLineNumber((JavaModel)javaClass, content);
        if (lineNumber == -1) {
            return commentsMap;
        }
        String indent = this._getIndent(lines, lineNumber);
        String javaClassComment = this._getJavaClassComment(classElement, javaClass, indent);
        javaClassComment = this._addDeprecatedTag(javaClassComment, (JavaAnnotatedElement)javaClass, indent);
        commentsMap.put(this._getJavaModelLineNumber((JavaModel)javaClass, content), javaClassComment);
        HashMap<String, Element> constructorElementsMap = new HashMap<String, Element>();
        List constructorElements = classElement.elements("constructor");
        for (Object constructorElement : constructorElements) {
            String constructorKey = this._getExecutableKey((Element)constructorElement);
            constructorElementsMap.put(constructorKey, (Element)constructorElement);
        }
        List javaConstructors = javaClass.getConstructors();
        for (JavaConstructor javaConstructor : javaConstructors) {
            lineNumber = this._getJavaModelLineNumber((JavaModel)javaConstructor, content);
            if (lineNumber == -1 || commentsMap.containsKey(lineNumber)) continue;
            indent = this._getIndent(lines, lineNumber);
            Object javaConstructorComment = this._getJavaExecutableComment(constructorElementsMap, (JavaExecutable)javaConstructor, indent);
            javaConstructorComment = this._addDeprecatedTag((String)javaConstructorComment, (JavaAnnotatedElement)javaConstructor, indent);
            commentsMap.put(lineNumber, (String)javaConstructorComment);
        }
        HashMap<String, Element> methodElementsMap = new HashMap<String, Element>();
        List methodElements = classElement.elements("method");
        for (Object methodElement : methodElements) {
            String methodKey = this._getExecutableKey((Element)methodElement);
            methodElementsMap.put(methodKey, (Element)methodElement);
        }
        List javaMethods = javaClass.getMethods();
        for (JavaMethod javaMethod : javaMethods) {
            lineNumber = this._getJavaModelLineNumber((JavaModel)javaMethod, content);
            if (lineNumber == -1 || commentsMap.containsKey(lineNumber)) continue;
            indent = this._getIndent(lines, lineNumber);
            Object javaMethodComment = this._getJavaExecutableComment(methodElementsMap, (JavaExecutable)javaMethod, indent);
            javaMethodComment = this._addDeprecatedTag((String)javaMethodComment, (JavaAnnotatedElement)javaMethod, indent);
            commentsMap.put(lineNumber, (String)javaMethodComment);
        }
        HashMap<String, Element> fieldElementsMap = new HashMap<String, Element>();
        List fieldElements = classElement.elements("field");
        for (Object fieldElement : fieldElements) {
            String fieldKey = this._getFieldKey((Element)fieldElement);
            fieldElementsMap.put(fieldKey, (Element)fieldElement);
        }
        List javaFields = javaClass.getFields();
        for (JavaField javaField : javaFields) {
            lineNumber = this._getJavaModelLineNumber((JavaModel)javaField, content);
            if (lineNumber == -1 || commentsMap.containsKey(lineNumber)) continue;
            indent = this._getIndent(lines, lineNumber);
            Object javaFieldComment = this._getJavaFieldComment(fieldElementsMap, javaField, indent);
            javaFieldComment = this._addDeprecatedTag((String)javaFieldComment, (JavaAnnotatedElement)javaField, indent);
            commentsMap.put(lineNumber, (String)javaFieldComment);
        }
        HashMap<String, Element> nestedClassElementsMap = new HashMap<String, Element>();
        List nestedClassElements = classElement.elements("class");
        for (Element nestedClassElement : nestedClassElements) {
            String nestedClassKey = this._getClassKey(nestedClassElement);
            nestedClassElementsMap.put(nestedClassKey, nestedClassElement);
        }
        List nestedClasses = javaClass.getNestedClasses();
        for (JavaClass nestedClass : nestedClasses) {
            String nestedClassKey = this._getClassKey(nestedClass);
            Element nestedClassElement = (Element)nestedClassElementsMap.get(nestedClassKey);
            commentsMap = this._addComments(commentsMap, nestedClassElement, nestedClass, content, lines);
        }
        return commentsMap;
    }

    private void _addConstructorElement(Element parentElement, JavaConstructor javaConstructor) throws Exception {
        Element constructorElement = parentElement.addElement("constructor");
        Dom4jDocUtil.add(constructorElement, "name", javaConstructor.getName());
        String comment = this._getCDATA((JavaAnnotatedElement)javaConstructor);
        if (Validator.isNotNull(comment)) {
            Element commentElement = constructorElement.addElement("comment");
            commentElement.addCDATA(this._getCDATA((JavaAnnotatedElement)javaConstructor));
        }
        this._addDocletElements(constructorElement, (JavaAnnotatedElement)javaConstructor, "version");
        this._addParamElements(constructorElement, (JavaExecutable)javaConstructor, (List<DocletTag>)javaConstructor.getTagsByName("param"));
        this._addThrowsElements(constructorElement, (JavaExecutable)javaConstructor, javaConstructor.getTagsByName("throws"));
        this._addDocletElements(constructorElement, (JavaAnnotatedElement)javaConstructor, "see");
        this._addDocletElements(constructorElement, (JavaAnnotatedElement)javaConstructor, "since");
        this._addDocletElements(constructorElement, (JavaAnnotatedElement)javaConstructor, "deprecated");
        this._addDocletElements(constructorElement, (JavaAnnotatedElement)javaConstructor, "review");
    }

    private String _addDeprecatedTag(String comment, JavaAnnotatedElement javaAnnotatedElement, String indent) throws Exception {
        if (comment == null) {
            return null;
        }
        if (!(comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath)).contains("* @deprecated ") || this._hasAnnotation(javaAnnotatedElement, "Deprecated")) {
            return comment;
        }
        return comment + indent + "@Deprecated\n";
    }

    private void _addDocletElements(Element parentElement, JavaAnnotatedElement javaAnnotatedElement, String name) throws Exception {
        List docletTags = javaAnnotatedElement.getTagsByName(name);
        for (DocletTag docletTag : docletTags) {
            String value = docletTag.getValue();
            value = ToolsUtil.stripFullyQualifiedClassNames(value, this._imports, this._packagePath);
            if (name.equals("deprecated") && this._deprecationSyncDirName != null) {
                Element nameElement = parentElement.element("name");
                value = JavadocFormatterUtil.syncDeprecatedVersion(value, javaAnnotatedElement, nameElement.getText(), this._fullyQualifiedName, this._getDeprecationsDocument());
            }
            value = this._trimMultilineText(value);
            value = StringUtil.replace(value, " </", "</");
            Element element = parentElement.addElement(name);
            element.addCDATA(value);
        }
        if (docletTags.isEmpty() && name.equals("author")) {
            Element element = parentElement.addElement(name);
            element.addCDATA(this._author);
        }
    }

    private String _addDocletTags(Element parentElement, String[] tagNames, String indent, boolean publicAccess) {
        ArrayList<String> allTagNames = new ArrayList<String>();
        ArrayList<String> customTagNames = new ArrayList<String>();
        ArrayList<String> requiredTagNames = new ArrayList<String>();
        for (String tagName : tagNames) {
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                if (tagName.equals("param") || tagName.equals("return") || tagName.equals("throws")) {
                    if (Validator.isNotNull(comment)) {
                        requiredTagNames.add(tagName);
                    } else if (tagName.equals("param")) {
                        if (GetterUtil.getBoolean(element.elementText("required"))) {
                            requiredTagNames.add(tagName);
                        }
                    } else if (tagName.equals("throws") && GetterUtil.getBoolean(element.elementText("required"))) {
                        requiredTagNames.add(tagName);
                    }
                } else {
                    customTagNames.add(tagName);
                }
                allTagNames.add(tagName);
            }
        }
        int maxTagNameLength = 0;
        ArrayList<String> maxTagNameLengthTags = new ArrayList<String>();
        if (this._initializeMissingJavadocs) {
            maxTagNameLengthTags.addAll(allTagNames);
        } else if (this._updateJavadocs) {
            if (!requiredTagNames.isEmpty()) {
                maxTagNameLengthTags.addAll(allTagNames);
            } else {
                maxTagNameLengthTags.addAll(customTagNames);
                maxTagNameLengthTags.addAll(requiredTagNames);
            }
        } else {
            maxTagNameLengthTags.addAll(customTagNames);
            maxTagNameLengthTags.addAll(requiredTagNames);
        }
        for (String name : maxTagNameLengthTags) {
            if (name.length() <= maxTagNameLength) continue;
            maxTagNameLength = name.length();
        }
        String tagNameIndent = this._getSpacesIndent(maxTagNameLength += 2);
        StringBundler sb = new StringBundler();
        for (String tagName : tagNames) {
            List elements = parentElement.elements(tagName);
            for (Element element : elements) {
                Element commentElement = element.element("comment");
                String comment = null;
                comment = commentElement != null ? commentElement.getText() : element.getText();
                String elementName = element.elementText("name");
                if (Validator.isNotNull(comment)) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._initializeMissingJavadocs && publicAccess) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (this._updateJavadocs && publicAccess) {
                    if (!(tagName.equals("param") || tagName.equals("return") || tagName.equals("throws"))) {
                        comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                        sb.append(comment);
                        continue;
                    }
                    if (requiredTagNames.isEmpty()) continue;
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (!(tagName.equals("param") || tagName.equals("return") || tagName.equals("throws"))) {
                    comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                    sb.append(comment);
                    continue;
                }
                if (!tagName.equals("param") && !tagName.equals("return") && !tagName.equals("throws") || !GetterUtil.getBoolean(element.elementText("required"))) continue;
                elementName = element.elementText("name");
                comment = this._assembleTagComment(tagName, elementName, comment, indent, tagNameIndent);
                sb.append(comment);
            }
        }
        return sb.toString();
    }

    private void _addFieldElement(Element parentElement, JavaField javaField) throws Exception {
        Element fieldElement = parentElement.addElement("field");
        Dom4jDocUtil.add(fieldElement, "name", javaField.getName());
        String comment = this._getCDATA((JavaAnnotatedElement)javaField);
        if (Validator.isNotNull(comment)) {
            Element commentElement = fieldElement.addElement("comment");
            commentElement.addCDATA(comment);
        }
        this._addDocletElements(fieldElement, (JavaAnnotatedElement)javaField, "version");
        this._addDocletElements(fieldElement, (JavaAnnotatedElement)javaField, "see");
        this._addDocletElements(fieldElement, (JavaAnnotatedElement)javaField, "since");
        this._addDocletElements(fieldElement, (JavaAnnotatedElement)javaField, "deprecated");
        this._addDocletElements(fieldElement, (JavaAnnotatedElement)javaField, "review");
    }

    private void _addMethodElement(Element parentElement, JavaMethod javaMethod) throws Exception {
        Element methodElement = parentElement.addElement("method");
        Dom4jDocUtil.add(methodElement, "name", javaMethod.getName());
        String comment = this._getCDATA((JavaAnnotatedElement)javaMethod);
        if (Validator.isNotNull(comment)) {
            Element commentElement = methodElement.addElement("comment");
            commentElement.addCDATA(this._getCDATA((JavaAnnotatedElement)javaMethod));
        }
        this._addDocletElements(methodElement, (JavaAnnotatedElement)javaMethod, "version");
        this._addParamElements(methodElement, (JavaExecutable)javaMethod, (List<DocletTag>)javaMethod.getTagsByName("param"));
        this._addReturnElement(methodElement, javaMethod);
        this._addThrowsElements(methodElement, (JavaExecutable)javaMethod, javaMethod.getTagsByName("throws"));
        this._addDocletElements(methodElement, (JavaAnnotatedElement)javaMethod, "see");
        this._addDocletElements(methodElement, (JavaAnnotatedElement)javaMethod, "since");
        this._addDocletElements(methodElement, (JavaAnnotatedElement)javaMethod, "deprecated");
        this._addDocletElements(methodElement, (JavaAnnotatedElement)javaMethod, "review");
    }

    private void _addParamElement(Element executableElement, String parameterName, String parameterValue, List<DocletTag> paramDocletTags) throws Exception {
        String value = null;
        for (DocletTag paramDocletTag : paramDocletTags) {
            String curValue = paramDocletTag.getValue();
            if (!curValue.equals(parameterName) && !curValue.startsWith(parameterName + " ")) continue;
            value = curValue;
            break;
        }
        Element paramElement = executableElement.addElement("param");
        Dom4jDocUtil.add(paramElement, "name", parameterName);
        if (parameterValue != null) {
            Dom4jDocUtil.add(paramElement, "type", parameterValue);
        }
        if (value != null) {
            value = value.substring(parameterName.length());
            Dom4jDocUtil.add(paramElement, "required", true);
        }
        value = ToolsUtil.stripFullyQualifiedClassNames(value, this._imports, this._packagePath);
        value = this._trimMultilineText(value);
        Element commentElement = paramElement.addElement("comment");
        commentElement.addCDATA(value);
    }

    private void _addParamElements(Element classElement, JavaClass javaClass, List<DocletTag> paramDocletTags) throws Exception {
        for (JavaTypeVariable typeParameter : javaClass.getTypeParameters()) {
            this._addParamElement(classElement, "<" + typeParameter.getName() + ">", null, paramDocletTags);
        }
    }

    private void _addParamElements(Element executableElement, JavaExecutable javaExecutable, List<DocletTag> paramDocletTags) throws Exception {
        List javaParameters = javaExecutable.getParameters();
        for (JavaParameter javaParameter : javaParameters) {
            this._addParamElement(executableElement, javaParameter.getName(), this._getTypeValue(javaParameter), paramDocletTags);
        }
    }

    private void _addReturnElement(Element methodElement, JavaMethod javaMethod) throws Exception {
        JavaType returnType = javaMethod.getReturnType();
        if (returnType == null) {
            return;
        }
        String returnTypeValue = returnType.getValue();
        if (returnTypeValue.equals("void")) {
            return;
        }
        Element returnElement = methodElement.addElement("return");
        List returnDocletTags = javaMethod.getTagsByName("return");
        String comment = "";
        if (!returnDocletTags.isEmpty()) {
            DocletTag returnDocletTag = (DocletTag)returnDocletTags.get(0);
            comment = GetterUtil.getString(returnDocletTag.getValue());
            Dom4jDocUtil.add(returnElement, "required", true);
        }
        comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
        comment = this._trimMultilineText(comment);
        Element commentElement = returnElement.addElement("comment");
        commentElement.addCDATA(comment);
    }

    private void _addThrowsElement(Element executableElement, JavaClass exceptionJavaClass, List<DocletTag> throwsDocletTags) throws Exception {
        String name = exceptionJavaClass.getName();
        int pos = name.lastIndexOf(".");
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        String value = null;
        for (DocletTag throwsDocletTag : throwsDocletTags) {
            String curValue = throwsDocletTag.getValue();
            if (!curValue.startsWith(name)) continue;
            value = curValue;
            break;
        }
        Element throwsElement = executableElement.addElement("throws");
        Dom4jDocUtil.add(throwsElement, "name", name);
        Dom4jDocUtil.add(throwsElement, "type", exceptionJavaClass.getValue());
        if (value != null) {
            value = value.substring(name.length());
            Dom4jDocUtil.add(throwsElement, "required", true);
        }
        value = ToolsUtil.stripFullyQualifiedClassNames(value, this._imports, this._packagePath);
        value = this._trimMultilineText(value);
        Element commentElement = throwsElement.addElement("comment");
        commentElement.addCDATA(this._getCDATA(value));
    }

    private void _addThrowsElements(Element executableElement, JavaExecutable javaExecutable, List<DocletTag> throwsDocletTags) throws Exception {
        List exceptionJavaClasses = javaExecutable.getExceptions();
        for (JavaClass exceptionJavaClass : exceptionJavaClasses) {
            this._addThrowsElement(executableElement, exceptionJavaClass, throwsDocletTags);
        }
    }

    private String _assembleTagComment(String tagName, String elementName, String comment, String indent, String tagNameIndent) {
        String indentAndTagName = indent + "@" + tagName;
        if (Validator.isNotNull(elementName)) {
            comment = Validator.isNotNull(comment) ? elementName + " " + comment : elementName;
            comment = this._wrapText(comment, indent + tagNameIndent);
            comment = indentAndTagName + comment.substring(indentAndTagName.length());
        } else if (Validator.isNotNull(comment)) {
            comment = this._wrapText(comment, indent + tagNameIndent);
            comment = indentAndTagName + comment.substring(indentAndTagName.length());
        } else {
            comment = indentAndTagName + "\n";
        }
        return comment;
    }

    private String _compactString(Node node) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        OutputFormat outputFormat = OutputFormat.createCompactFormat();
        XMLWriter xmlWriter = new XMLWriter((OutputStream)unsyncByteArrayOutputStream, outputFormat);
        xmlWriter.write(node);
        return unsyncByteArrayOutputStream.toString("UTF-8");
    }

    private void _detachUnnecessaryTypes(Element rootElement) {
        List elements = rootElement.elements();
        for (Element element : elements) {
            String type = element.elementText("type");
            if (type.contains(".service.") && type.endsWith("ServiceImpl")) continue;
            element.detach();
        }
    }

    private void _format(String fileName) throws Exception {
        String newContent;
        if (fileName.endsWith("JavadocFormatter.java") || fileName.endsWith("Mojo.java") || fileName.endsWith("package-info.java") || fileName.endsWith("SourceFormatter.java") || fileName.endsWith("WebProxyPortlet.java")) {
            return;
        }
        this._packagePath = ToolsUtil.getPackagePath(fileName);
        if (!this._packagePath.startsWith("com.liferay")) {
            return;
        }
        File file = new File(this._inputDirName, fileName);
        String originalContent = JavadocFormatterUtil.read(file);
        if (this._hasGeneratedTag(originalContent)) {
            return;
        }
        this._imports = JavaImportsFormatter.getImports(originalContent);
        JavaClass javaClass = null;
        try {
            javaClass = this._getJavaClass(fileName, new UnsyncStringReader(originalContent));
        }
        catch (Exception e) {
            if (!fileName.contains("__")) {
                System.out.println("Qdox parsing error while formatting file " + fileName);
            }
            return;
        }
        this._fullyQualifiedName = javaClass.getFullyQualifiedName();
        String javadocLessContent = this._removeJavadocFromJava(javaClass, originalContent);
        Document document = this._getJavadocDocument(javaClass);
        if (this._generateXml) {
            this._updateJavadocsXmlFile(fileName, javaClass, document);
        }
        if (!originalContent.equals(newContent = this._getUpdateJavaFromDocument(fileName, javadocLessContent, document))) {
            this._write(file, newContent);
            this._modifiedFileNames.add(file.getAbsolutePath());
            System.out.println("Writing " + file);
        }
    }

    private String _formatCDATA(String cdata) {
        cdata = cdata.replaceAll("(?s)\\s*<(p|[ou]l)>\\s*(.*?)\\s*</\\1>\\s*", "\n\n<$1>\n$2\n</$1>\n\n");
        cdata = cdata.replaceAll("(?s)\\s*<li>\\s*(.*?)\\s*</li>\\s*", "\n<li>\n$1\n</li>\n");
        cdata = StringUtil.replace(cdata, "</li>\n\n<li>", "</li>\n<li>");
        cdata = cdata.replaceAll("\n\\s+\n", "\n\n");
        cdata = cdata.replaceAll(" +", " ");
        Matcher matcher = _paragraphTagPattern.matcher(cdata);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String trimmed = this._trimMultilineText(matcher.group());
            trimmed = StringUtil.replace(trimmed, '$', "\\$");
            matcher.appendReplacement(sb, trimmed);
        }
        matcher.appendTail(sb);
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _formatInlines(String text) {
        text = text.replaceAll("(?i)(?<!@link) id(s)?\\b", " ID$1");
        text = text.replaceAll("(?i)(?<!<code>|\\{@code |[\\w\"])(null|false|true)(?![\\w\"])", "<code>$1</code>");
        return text;
    }

    private String _formattedString(Node node) throws IOException {
        return Dom4jUtil.toString(node);
    }

    private int _getAdjustedLineNumber(int lineNumber, JavaModel javaModel) {
        JavaAnnotatedElement javaAnnotatedElement = (JavaAnnotatedElement)javaModel;
        List annotations = javaAnnotatedElement.getAnnotations();
        if (annotations.isEmpty()) {
            return lineNumber;
        }
        for (JavaAnnotation annotation : annotations) {
            int annotationLineNumber = annotation.getLineNumber();
            Map propertyMap = annotation.getPropertyMap();
            if (propertyMap.isEmpty()) {
                --annotationLineNumber;
            }
            if (annotationLineNumber >= lineNumber) continue;
            lineNumber = annotationLineNumber;
        }
        return lineNumber;
    }

    private String _getCDATA(JavaAnnotatedElement javaAnnotatedElement) {
        return this._getCDATA(javaAnnotatedElement.getComment());
    }

    private String _getCDATA(String cdata) {
        if (cdata == null || cdata.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler();
        int cdataBeginIndex = 0;
        while (!cdata.isEmpty()) {
            int preTagIndex = cdata.indexOf("<pre>");
            int tableTagIndex = cdata.indexOf("<table>");
            boolean hasPreTag = false;
            if (preTagIndex != -1) {
                hasPreTag = true;
            }
            boolean hasTableTag = false;
            if (tableTagIndex != -1) {
                hasTableTag = true;
            }
            if (!hasPreTag && !hasTableTag) {
                sb.append(this._formatCDATA(cdata));
                break;
            }
            boolean startsWithPreTag = false;
            if (preTagIndex == 0) {
                startsWithPreTag = true;
            }
            boolean startsWithTableTag = false;
            if (tableTagIndex == 0) {
                startsWithTableTag = true;
            }
            if (startsWithPreTag || startsWithTableTag) {
                sb.append("\n");
                String tagName = null;
                tagName = preTagIndex == 0 ? "pre" : "table";
                String startTag = "<" + tagName + ">";
                String endTag = "</" + tagName + ">";
                int startTagLength = startTag.length();
                int endTagLength = endTag.length();
                int endTagIndex = cdata.indexOf(endTag, startTagLength - 1);
                sb.append(cdata.substring(0, endTagIndex + endTagLength));
                sb.append("\n");
                cdataBeginIndex = endTagIndex + endTagLength;
            } else {
                int startTagIndex = 0;
                startTagIndex = hasPreTag && hasTableTag ? (preTagIndex < tableTagIndex ? preTagIndex : tableTagIndex) : (hasPreTag && !hasTableTag ? preTagIndex : tableTagIndex);
                sb.append(this._formatCDATA(cdata.substring(0, startTagIndex)));
                cdataBeginIndex = startTagIndex;
            }
            cdata = cdata.substring(cdataBeginIndex);
        }
        cdata = sb.toString();
        return cdata.trim();
    }

    private String _getClassKey(Element classElement) {
        return classElement.elementText("name");
    }

    private String _getClassKey(JavaClass javaClass) {
        return javaClass.getName();
    }

    private String _getClassName(String fileName) {
        int pos = fileName.lastIndexOf("/");
        return fileName.substring(pos + 1, fileName.length() - 5);
    }

    private Document _getDeprecationsDocument() {
        if (this._deprecationsDocument != null) {
            return this._deprecationsDocument;
        }
        try {
            this._deprecationsDocument = JavadocFormatterUtil.getDeprecationsDocument(this._deprecationSyncDirName);
        }
        catch (Exception e) {
            this._deprecationsDocument = DocumentHelper.createDocument();
        }
        return this._deprecationsDocument;
    }

    private String _getExecutableKey(Element executableElement) {
        StringBundler sb = new StringBundler();
        sb.append(executableElement.elementText("name"));
        sb.append("(");
        List paramElements = executableElement.elements("param");
        for (Element paramElement : paramElements) {
            sb.append(paramElement.elementText("name"));
            sb.append("|");
            sb.append(paramElement.elementText("type"));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getExecutableKey(JavaExecutable javaExecutable) {
        StringBundler sb = new StringBundler();
        sb.append(javaExecutable.getName());
        sb.append("(");
        List javaParameters = javaExecutable.getParameters();
        for (JavaParameter javaParameter : javaParameters) {
            sb.append(javaParameter.getName());
            sb.append("|");
            sb.append(this._getTypeValue(javaParameter));
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getFieldKey(Element fieldElement) {
        return fieldElement.elementText("name");
    }

    private String _getFieldKey(JavaField javaField) {
        return javaField.getName();
    }

    private String _getIndent(String[] lines, int lineNumber) {
        String line = lines[lineNumber - 1];
        String indent = "";
        for (char c : line.toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            indent = indent + c;
        }
        return indent;
    }

    private int _getIndentLength(String indent) {
        int indentLength = 0;
        for (char c : indent.toCharArray()) {
            if (c == '\t') {
                indentLength += 4;
                continue;
            }
            ++indentLength;
        }
        return indentLength;
    }

    private JavaClass _getJavaClass(String fileName, Reader reader) {
        if (reader != null) {
            this._javaProjectBuilder = new JavaProjectBuilder();
            this._javaProjectBuilder.addSource(reader);
        }
        return this._javaProjectBuilder.getClassByName(this._packagePath + "." + this._getClassName(fileName));
    }

    private String _getJavaClassComment(Element rootElement, JavaClass javaClass, String indent) throws Exception {
        String docletTags;
        StringBundler sb = new StringBundler(8);
        sb.append(indent);
        sb.append("/**\n");
        String comment = rootElement.elementText("comment");
        if (Validator.isNotNull(comment)) {
            comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull(docletTags = this._addDocletTags(rootElement, new String[]{"author", "version", "param", "see", "since", "serial", "deprecated", "review"}, indent + " * ", this._hasPublicModifier(javaClass)))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull(comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier(javaClass) && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private Document _getJavadocDocument(JavaClass javaClass) throws Exception {
        Element rootElement = DocumentHelper.createElement((String)"javadoc");
        Document document = DocumentHelper.createDocument((Element)rootElement);
        this._addClassElement(rootElement, javaClass, false);
        return document;
    }

    private Tuple _getJavadocsXmlTuple(String fileName) throws Exception {
        File file = new File(this._inputDirName + fileName);
        String absolutePath = file.getAbsolutePath();
        absolutePath = StringUtil.replace(absolutePath, '\\', '/');
        absolutePath = StringUtil.replace(absolutePath, "/./", "/");
        int pos = absolutePath.indexOf("/portal-impl/src/");
        String srcDirName = null;
        if (pos != -1) {
            srcDirName = absolutePath.substring(0, pos + 17);
        }
        if (srcDirName == null) {
            pos = absolutePath.indexOf("/portal-kernel/src/");
            if (pos == -1) {
                pos = absolutePath.indexOf("/portal-kernel/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-bridges/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-java/src/");
            }
            if (pos == -1) {
                pos = absolutePath.indexOf("/util-taglib/src/");
            }
            if (pos != -1) {
                srcDirName = absolutePath.substring(0, pos) + "/portal-impl/src/";
            }
        }
        if (srcDirName == null && (pos = absolutePath.indexOf("/WEB-INF/src/")) != -1) {
            srcDirName = absolutePath.substring(0, pos + 13);
        }
        if (srcDirName == null && (pos = absolutePath.indexOf("/src/main/java/")) != -1) {
            srcDirName = absolutePath.substring(0, pos) + "/src/main/resources";
        }
        if (srcDirName == null) {
            return null;
        }
        Tuple tuple = this._javadocxXmlTuples.get(srcDirName);
        if (tuple != null) {
            return tuple;
        }
        File metaInfDir = new File(srcDirName, "META-INF");
        if (!metaInfDir.exists()) {
            metaInfDir.mkdirs();
        }
        File javadocsXmlFile = new File(metaInfDir, this._outputFilePrefix + "-all.xml");
        String javadocsXmlContent = null;
        if (!javadocsXmlFile.exists()) {
            javadocsXmlContent = "<?xml version=\"1.0\"?>\n\n<javadocs>\n</javadocs>";
            this._write(javadocsXmlFile, javadocsXmlContent);
            this._modifiedFileNames.add(javadocsXmlFile.getAbsolutePath());
        }
        javadocsXmlContent = JavadocFormatterUtil.read(javadocsXmlFile);
        SAXReader saxReader = this._getSAXReader();
        Document javadocsXmlDocument = saxReader.read((Reader)new XMLSafeReader(javadocsXmlContent));
        tuple = new Tuple(srcDirName, javadocsXmlFile, javadocsXmlContent, javadocsXmlDocument);
        this._javadocxXmlTuples.put(srcDirName, tuple);
        return tuple;
    }

    private String _getJavaExecutableComment(Map<String, Element> executableElementsMap, JavaExecutable javaExecutable, String indent) throws Exception {
        String executableKey = this._getExecutableKey(javaExecutable);
        Element executableElement = executableElementsMap.get(executableKey);
        if (executableElement == null) {
            return null;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(indent);
        sb.append("/**\n");
        String comment = executableElement.elementText("comment");
        if (Validator.isNotNull(comment)) {
            comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
            sb.append(this._wrapText(comment, indent + " * "));
        }
        String[] tags = null;
        tags = javaExecutable instanceof JavaMethod ? new String[]{"version", "param", "return", "throws", "see", "since", "deprecated", "review"} : new String[]{"version", "param", "throws", "see", "since", "deprecated", "review"};
        String docletTags = this._addDocletTags(executableElement, tags, indent + " * ", this._hasPublicModifier((JavaMember)javaExecutable));
        if (Validator.isNotNull(docletTags)) {
            if (this._initializeMissingJavadocs || Validator.isNotNull(comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((JavaMember)javaExecutable) && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private String _getJavaFieldComment(Map<String, Element> fieldElementsMap, JavaField javaField, String indent) throws Exception {
        String docletTags;
        String fieldKey = this._getFieldKey(javaField);
        Element fieldElement = fieldElementsMap.get(fieldKey);
        if (fieldElement == null) {
            return null;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(indent);
        sb.append("/**\n");
        String comment = fieldElement.elementText("comment");
        if (Validator.isNotNull(comment)) {
            comment = ToolsUtil.stripFullyQualifiedClassNames(comment, this._imports, this._packagePath);
            sb.append(this._wrapText(comment, indent + " * "));
        }
        if (Validator.isNotNull(docletTags = this._addDocletTags(fieldElement, new String[]{"version", "see", "since", "deprecated", "review"}, indent + " * ", this._hasPublicModifier((JavaMember)javaField)))) {
            if (this._initializeMissingJavadocs || Validator.isNotNull(comment)) {
                sb.append(indent);
                sb.append(" *\n");
            }
            sb.append(docletTags);
        }
        sb.append(indent);
        sb.append(" */\n");
        if (!this._initializeMissingJavadocs && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        if (!this._hasPublicModifier((JavaMember)javaField) && Validator.isNull(comment) && Validator.isNull(docletTags)) {
            return null;
        }
        return sb.toString();
    }

    private int _getJavaModelLineNumber(JavaModel javaModel, String content) {
        if (javaModel.getLineNumber() == 0) {
            return -1;
        }
        String[] lines = StringUtil.splitLines(content);
        if (javaModel instanceof JavaClass) {
            JavaClass javaClass = (JavaClass)javaModel;
            List modifiers = javaClass.getModifiers();
            if (modifiers.isEmpty()) {
                return this._getAdjustedLineNumber(javaModel.getLineNumber(), javaModel);
            }
            String modifier = (String)modifiers.get(0);
            for (int i = javaClass.getLineNumber() - 1; i < lines.length; ++i) {
                String line = StringUtil.trim(lines[i - 1]);
                if (!line.startsWith(modifier + " ")) continue;
                return this._getAdjustedLineNumber(i, javaModel);
            }
            return -1;
        }
        if (javaModel instanceof JavaField) {
            JavaField javaField = (JavaField)javaModel;
            if (javaField.isEnumConstant()) {
                for (int i = javaModel.getLineNumber(); i < lines.length; ++i) {
                    String line = lines[i - 1];
                    if (StringUtil.startsWith(StringUtil.trim(line), '*') || !line.matches(".*\\W" + javaField.getName() + "(\\W.*)?")) continue;
                    return this._getAdjustedLineNumber(i, javaModel);
                }
            }
            return this._getAdjustedLineNumber(javaModel.getLineNumber(), javaModel);
        }
        JavaMember javaMember = (JavaMember)javaModel;
        List modifiers = javaMember.getModifiers();
        if (modifiers.isEmpty()) {
            return this._getAdjustedLineNumber(javaModel.getLineNumber(), javaModel);
        }
        String modifier = (String)modifiers.get(0);
        for (int i = javaModel.getLineNumber(); i > 0; --i) {
            String line = StringUtil.trim(lines[i - 1]);
            if (!line.equals(modifier) && !line.startsWith(modifier + " ")) continue;
            return this._getAdjustedLineNumber(i, javaModel);
        }
        return -1;
    }

    private Set<Integer> _getJavaTermLineNumbers(Set<Integer> lineNumbers, JavaClass javaClass, String content) {
        lineNumbers.add(this._getJavaModelLineNumber((JavaModel)javaClass, content));
        List javaConstructors = javaClass.getConstructors();
        for (Object javaConstructor : javaConstructors) {
            lineNumbers.add(this._getJavaModelLineNumber((JavaModel)javaConstructor, content));
        }
        List javaMethods = javaClass.getMethods();
        for (Object javaMethod : javaMethods) {
            lineNumbers.add(this._getJavaModelLineNumber((JavaModel)javaMethod, content));
        }
        List javaFields = javaClass.getFields();
        for (JavaField javaField : javaFields) {
            lineNumbers.add(this._getJavaModelLineNumber((JavaModel)javaField, content));
        }
        List nestedClasses = javaClass.getNestedClasses();
        for (JavaClass nestedClass : nestedClasses) {
            lineNumbers = this._getJavaTermLineNumbers(lineNumbers, nestedClass, content);
        }
        return lineNumbers;
    }

    private SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }

    private String _getSpacesIndent(int length) {
        String indent = "";
        for (int i = 0; i < length; ++i) {
            indent = indent + " ";
        }
        return indent;
    }

    private String _getTypeValue(JavaParameter javaParameter) {
        JavaType type = javaParameter.getType();
        return type.getValue();
    }

    private String _getUpdateJavaFromDocument(String fileName, String javadocLessContent, Document document) throws Exception {
        String[] lines = StringUtil.splitLines(javadocLessContent);
        JavaClass javaClass = this._getJavaClass(fileName, new UnsyncStringReader(javadocLessContent));
        this._updateLanguageProperties(document, javaClass.getName());
        Element rootElement = document.getRootElement();
        Map<Integer, String> commentsMap = this._addComments(new TreeMap<Integer, String>(), rootElement, javaClass, javadocLessContent, lines);
        StringBundler sb = new StringBundler(javadocLessContent.length());
        for (int lineNumber = 1; lineNumber <= lines.length; ++lineNumber) {
            String line = lines[lineNumber - 1];
            String comments = commentsMap.get(lineNumber);
            if (comments != null) {
                sb.append(comments);
            }
            sb.append(line);
            sb.append("\n");
        }
        String formattedContent = sb.toString();
        return formattedContent.trim();
    }

    private boolean _hasAnnotation(JavaAnnotatedElement javaAnnotatedElement, String annotationName) {
        List annotations = javaAnnotatedElement.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (JavaAnnotation javaAnnotation : annotations) {
            JavaClass javaClass = javaAnnotation.getType();
            if (!annotationName.equals(javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean _hasGeneratedTag(String content) {
        return (content.contains("* @generated") || content.contains("$ANTLR") || content.contains("auto-generated from WSDL")) && !content.contains("hasGeneratedTag");
    }

    private boolean _hasPublicModifier(JavaClass javaClass) {
        return this._hasPublicModifier(javaClass.getModifiers());
    }

    private boolean _hasPublicModifier(JavaMember javaMember) {
        return this._hasPublicModifier(javaMember.getModifiers());
    }

    private boolean _hasPublicModifier(List<String> modifiers) {
        if (modifiers == null) {
            return false;
        }
        for (String modifier : modifiers) {
            if (!modifier.equals("public")) continue;
            return true;
        }
        return false;
    }

    private String _removeJavadocFromJava(JavaClass javaClass, String content) {
        Set<Integer> lineNumbers = this._getJavaTermLineNumbers(new HashSet<Integer>(), javaClass, content);
        String[] lines = StringUtil.splitLines(content);
        for (int lineNumber : lineNumbers) {
            int pos;
            String line;
            if (lineNumber == -1 || (line = lines[pos = lineNumber - 2]) == null) continue;
            int blankLines = 0;
            while (line.equals("")) {
                line = lines[--pos];
                ++blankLines;
            }
            if (!(line = line.trim()).endsWith("*/")) continue;
            while (true) {
                lines[pos] = null;
                if (line.startsWith("/**") || line.startsWith("/*")) break;
                line = lines[--pos].trim();
            }
            for (int i = 0; i < blankLines; ++i) {
                lines[lineNumber - i - 2] = null;
            }
        }
        StringBundler sb = new StringBundler(content.length());
        for (String line : lines) {
            if (line == null) continue;
            sb.append(line);
            sb.append("\n");
        }
        content = sb.toString();
        return content.trim();
    }

    /*
     * WARNING - void declaration
     */
    private void _sortElementsByChildElement(Element element, String elementName, String childElementName) {
        void var7_14;
        Element curElement;
        Element element2;
        TreeMap<String, Element> elementsMap = new TreeMap<String, Element>();
        List elements = element.elements();
        for (Element element3 : elements) {
            element3.detach();
            if (!elementName.equals(element3.getName())) continue;
            String childElementValue = element3.elementText(childElementName);
            elementsMap.put(childElementValue, element3);
        }
        Iterator<Object> iterator = elements.iterator();
        while (iterator.hasNext() && !elementName.equals((element2 = (Element)iterator.next()).getName())) {
            element.add(element2);
        }
        for (Map.Entry entry : elementsMap.entrySet()) {
            curElement = (Element)entry.getValue();
            element.add(curElement);
        }
        boolean foundLastElementWithElementName = false;
        boolean bl = false;
        while (var7_14 < elements.size()) {
            curElement = (Element)elements.get((int)var7_14);
            if (!foundLastElementWithElementName) {
                Element nextElement;
                if (elementName.equals(curElement.getName()) && var7_14 + true < elements.size() && !elementName.equals((nextElement = (Element)elements.get((int)(var7_14 + true))).getName())) {
                    foundLastElementWithElementName = true;
                }
            } else {
                element.add(curElement);
            }
            ++var7_14;
        }
    }

    private String _trimMultilineText(String text) {
        String[] lines = StringUtil.splitLines(text);
        StringBundler sb = new StringBundler();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            sb.append(line);
            if (line.endsWith("(") || i >= lines.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private void _updateJavadocsXmlFile(String fileName, JavaClass javaClass, Document javaClassDocument) throws Exception {
        Tuple javadocsXmlTuple = this._getJavadocsXmlTuple(fileName);
        if (javadocsXmlTuple == null) {
            return;
        }
        String javaClassFullyQualifiedName = javaClass.getFullyQualifiedName();
        Document javadocsXmlDocument = (Document)javadocsXmlTuple.getObject(3);
        Element javadocsXmlRootElement = javadocsXmlDocument.getRootElement();
        List javadocElements = javadocsXmlRootElement.elements("javadoc");
        for (Element javadocElement : javadocElements) {
            String type = javadocElement.elementText("type");
            if (!type.equals(javaClassFullyQualifiedName)) continue;
            Element javaClassRootElement = javaClassDocument.getRootElement();
            if (Objects.equals(this._formattedString((Node)javadocElement), this._formattedString((Node)javaClassRootElement))) {
                return;
            }
            javadocElement.detach();
            break;
        }
        javadocsXmlRootElement.add(javaClassDocument.getRootElement());
    }

    private void _updateLanguageProperties(Document document, String className) throws IOException {
        if (this._languageProperties == null) {
            return;
        }
        int index = className.indexOf("ServiceImpl");
        if (index <= 0) {
            return;
        }
        StringBundler sb = new StringBundler();
        sb.append(Character.toLowerCase(className.charAt(0)));
        for (int i = 1; i < index; ++i) {
            char c = className.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i + 1 < index && Character.isLowerCase(className.charAt(i + 1))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        sb.append("-service-help");
        String key = sb.toString();
        String value = this._languageProperties.getProperty(key);
        if (value == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        String comment = rootElement.elementText("comment");
        if (comment == null || value.equals(comment)) {
            return;
        }
        index = comment.indexOf("\n\n");
        value = index != -1 ? comment.substring(0, index) : comment;
        this._updateLanguageProperties(key, value);
    }

    private void _updateLanguageProperties(String key, String value) throws IOException {
        StringBundler sb = new StringBundler();
        try (BufferedReader bufferedReader = Files.newBufferedReader(this._languagePropertiesFile.toPath(), StandardCharsets.UTF_8);){
            boolean begin = false;
            boolean firstLine = true;
            String linePrefix = key + "=";
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.equals("")) {
                    boolean bl = begin = !begin;
                }
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append("\n");
                }
                if (line.startsWith(linePrefix)) {
                    sb.append(linePrefix);
                    sb.append(value);
                    continue;
                }
                sb.append(line);
            }
        }
        var5_5 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this._languagePropertiesFile, false), StandardCharsets.UTF_8);){
            sb.writeTo(writer);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        System.out.println(StringBundler.concat("Updating ", String.valueOf(this._languagePropertiesFile), " key ", key));
    }

    private String _wrap(String text, int width) {
        if (text == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        for (String line : StringUtil.splitLines(text)) {
            if (line.isEmpty()) {
                sb.append("\n");
                continue;
            }
            int lineLength = 0;
            for (String token : StringUtil.split(line, ' ')) {
                if (lineLength + token.length() + 1 > width) {
                    if (lineLength > 0) {
                        sb.append("\n");
                    }
                    if (token.length() > width) {
                        int pos = token.indexOf(40);
                        if (pos != -1) {
                            sb.append(token.substring(0, pos + 1));
                            sb.append("\n");
                            token = token.substring(pos + 1);
                            sb.append(token);
                            lineLength = token.length();
                            continue;
                        }
                        sb.append(token);
                        lineLength = token.length();
                        continue;
                    }
                    sb.append(token);
                    lineLength = token.length();
                    continue;
                }
                if (lineLength > 0) {
                    sb.append(" ");
                    ++lineLength;
                }
                sb.append(token);
                lineLength += token.length();
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String _wrapText(String text, int indentLength, String exclude) {
        StringBuffer sb = new StringBuffer();
        StringBundler regexSB = new StringBundler("(?<=^|</");
        regexSB.append(exclude);
        regexSB.append(">).+?(?=$|<");
        regexSB.append(exclude);
        regexSB.append(">)");
        Pattern pattern = Pattern.compile(regexSB.toString(), 32);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String wrapped = this._formatInlines(matcher.group());
            wrapped = this._wrap(wrapped, 80 - indentLength);
            matcher.appendReplacement(sb, wrapped);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String _wrapText(String text, String indent) {
        int indentLength = this._getIndentLength(indent);
        if (text.contains("<pre>")) {
            text = this._wrapText(text, indentLength, "pre");
        } else if (text.contains("<table>")) {
            text = this._wrapText(text, indentLength, "table");
        } else {
            text = this._formatInlines(text);
            text = this._wrap(text, 80 - indentLength);
        }
        text = text.replaceAll("(?m)^", indent);
        text = text.replaceAll("(?m) +$", "");
        return text;
    }

    private void _write(File file, String s) throws IOException {
        Files.write(file.toPath(), s.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

