/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.item.selector.internal.provider;

import com.liferay.item.selector.provider.GroupItemSelectorProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.GuestOrUserUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={GroupItemSelectorProvider.class})
public class GroupItemSelectorProviderImpl
implements GroupItemSelectorProvider {
    private static final Log _log = LogFactoryUtil.getLog(GroupItemSelectorProviderImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private Language _language;

    @Deprecated
    public String getEmptyResultsMessage() {
        return "no-sites-were-found";
    }

    public String getEmptyResultsMessage(Locale locale) {
        return this._language.get(locale, "no-sites-were-found");
    }

    public List<Group> getGroups(long companyId, long groupId, String keywords, int start, int end) {
        LinkedHashMap groupParams = LinkedHashMapBuilder.put((Object)"site", (Object)Boolean.TRUE).build();
        try {
            long[] classNameIds = this._getClassNameIds();
            List groups = this._groupLocalService.search(companyId, classNameIds, keywords, groupParams, start, end, null);
            return ListUtil.filter((List)groups, (startIndex, endIndex) -> this._groupLocalService.search(companyId, classNameIds, keywords, groupParams, startIndex.intValue(), endIndex.intValue(), null), () -> this.getGroupsCount(companyId, groupId, keywords), group -> this._hasViewPermission((Group)group), (int)start, (int)end);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return Collections.emptyList();
        }
    }

    public int getGroupsCount(long companyId, long groupId, String keywords) {
        return this._groupService.searchCount(companyId, this._getClassNameIds(), keywords, LinkedHashMapBuilder.put((Object)"actionId", (Object)"VIEW").put((Object)"site", (Object)Boolean.TRUE).build());
    }

    public String getGroupType() {
        return "site";
    }

    public String getIcon() {
        return "sites";
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "site");
    }

    private long[] _getClassNameIds() {
        return new long[]{this._classNameLocalService.getClassNameId(Company.class), this._classNameLocalService.getClassNameId(Group.class), this._classNameLocalService.getClassNameId(Organization.class)};
    }

    private boolean _hasViewPermission(Group group) {
        try {
            PermissionChecker permissionChecker = GuestOrUserUtil.getPermissionChecker();
            return group.isCompany() || permissionChecker.isGroupAdmin(group.getGroupId()) || GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"VIEW");
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
            return false;
        }
    }
}

