/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.item.selector;

import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorCriterionHandler;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.ItemSelectorView;
import com.liferay.item.selector.ItemSelectorViewReturnTypeProviderHandler;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public abstract class BaseItemSelectorCriterionHandler<T extends ItemSelectorCriterion>
implements ItemSelectorCriterionHandler {
    private ServiceTracker<ItemSelectorViewReturnTypeProviderHandler, ItemSelectorViewReturnTypeProviderHandler> _serviceTracker;
    private ServiceTrackerMap<Class<?>, List<ItemSelectorView<T>>> _serviceTrackerMap;

    public List<ItemSelectorView<T>> getItemSelectorViews(ItemSelectorCriterion itemSelectorCriterion) {
        List itemSelectorViews = (List)this._serviceTrackerMap.getService(itemSelectorCriterion.getClass());
        if (itemSelectorViews == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemSelectorView> filteredItemSelectedViews = new ArrayList<ItemSelectorView>();
        block0: for (ItemSelectorView itemSelectorView : itemSelectorViews) {
            List<ItemSelectorReturnType> desiredItemSelectorReturnTypes = itemSelectorCriterion.getDesiredItemSelectorReturnTypes();
            for (ItemSelectorReturnType desiredItemSelectorReturnType : desiredItemSelectorReturnTypes) {
                if (!this._isItemSelectorViewSupported(itemSelectorView, desiredItemSelectorReturnType)) continue;
                filteredItemSelectedViews.add(itemSelectorView);
                continue block0;
            }
        }
        return Collections.unmodifiableList(filteredItemSelectedViews);
    }

    protected void activate(BundleContext bundleContext) {
        this._serviceTracker = ServiceTrackerFactory.open((BundleContext)bundleContext, ItemSelectorViewReturnTypeProviderHandler.class, null);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, ItemSelectorView.class, null, (ServiceReferenceMapper)new ItemSelectorViewServiceReferenceMapper(bundleContext), Collections.reverseOrder(new PropertyServiceReferenceComparator("item.selector.view.order")));
    }

    protected void deactivate() {
        this._serviceTracker.close();
        this._serviceTrackerMap.close();
    }

    private boolean _isItemSelectorViewSupported(ItemSelectorView<T> itemSelectorView, ItemSelectorReturnType itemSelectorReturnType) {
        String itemSelectorReturnTypeClassName = ClassUtil.getClassName((Object)itemSelectorReturnType);
        List<ItemSelectorReturnType> supportedItemSelectorReturnTypes = null;
        ItemSelectorViewReturnTypeProviderHandler itemSelectorViewReturnTypeProviderHandler = (ItemSelectorViewReturnTypeProviderHandler)this._serviceTracker.getService();
        supportedItemSelectorReturnTypes = itemSelectorViewReturnTypeProviderHandler != null ? itemSelectorViewReturnTypeProviderHandler.getSupportedItemSelectorReturnTypes(itemSelectorView) : itemSelectorView.getSupportedItemSelectorReturnTypes();
        for (ItemSelectorReturnType supportedItemSelectorReturnType : supportedItemSelectorReturnTypes) {
            String supportedItemSelectorReturnTypeClassName = ClassUtil.getClassName((Object)supportedItemSelectorReturnType);
            if (!itemSelectorReturnTypeClassName.equals(supportedItemSelectorReturnTypeClassName)) continue;
            return true;
        }
        return false;
    }

    private class ItemSelectorViewServiceReferenceMapper
    implements ServiceReferenceMapper<Class<?>, ItemSelectorView<T>> {
        private final BundleContext _bundleContext;

        public ItemSelectorViewServiceReferenceMapper(BundleContext bundleContext) {
            this._bundleContext = bundleContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void map(ServiceReference<ItemSelectorView<T>> serviceReference, ServiceReferenceMapper.Emitter<Class<?>> emitter) {
            ItemSelectorView itemSelectorView = (ItemSelectorView)this._bundleContext.getService(serviceReference);
            try {
                Class itemSelectorCriterionClass = itemSelectorView.getItemSelectorCriterionClass();
                if (itemSelectorCriterionClass.isAssignableFrom(BaseItemSelectorCriterionHandler.this.getItemSelectorCriterionClass())) {
                    emitter.emit(itemSelectorView.getItemSelectorCriterionClass());
                }
            }
            finally {
                this._bundleContext.ungetService(serviceReference);
            }
        }
    }
}

