/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.invitation.invite.members.web.internal.portlet;

import com.liferay.invitation.invite.members.service.MemberRequestLocalService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.CustomSQLParam;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.comparator.UserFirstNameComparator;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.css-class-wrapper=so-portlet-invite-members", "com.liferay.portlet.display-category=category.collaboration", "com.liferay.portlet.header-portlet-css=/invite_members/css/main.css", "com.liferay.portlet.icon=/icons/invite_members.png", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=Invite Members", "javax.portlet.expiration-cache=0", "javax.portlet.init-param.template-path=/META-INF/resources/", "javax.portlet.init-param.view-template=/invite_members/view.jsp", "javax.portlet.name=com_liferay_invitation_invite_members_web_portlet_InviteMembersPortlet", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=guest,power-user,user", "javax.portlet.supported-public-render-parameter=invitedMembersCount", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class InviteMembersPortlet
extends MVCPortlet {
    private static final Log _log = LogFactoryUtil.getLog(InviteMembersPortlet.class);
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private MemberRequestLocalService _memberRequestLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void getAvailableUsers(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        int end = ParamUtil.getInteger((PortletRequest)resourceRequest, (String)"end");
        String keywords = ParamUtil.getString((PortletRequest)resourceRequest, (String)"keywords");
        int start = ParamUtil.getInteger((PortletRequest)resourceRequest, (String)"start");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("count", this._getAvailableUsersCount(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), keywords));
        JSONObject optionsJSONObject = JSONFactoryUtil.createJSONObject();
        optionsJSONObject.put("end", end);
        optionsJSONObject.put("keywords", keywords);
        optionsJSONObject.put("start", start);
        jsonObject.put("options", optionsJSONObject);
        List<User> users = this._getAvailableUsers(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), keywords, start, end);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (User user : users) {
            JSONObject userJSONObject = JSONFactoryUtil.createJSONObject();
            userJSONObject.put("hasPendingMemberRequest", this._memberRequestLocalService.hasPendingMemberRequest(themeDisplay.getScopeGroupId(), user.getUserId()));
            userJSONObject.put("userEmailAddress", user.getEmailAddress());
            userJSONObject.put("userFullName", user.getFullName());
            userJSONObject.put("userId", user.getUserId());
            jsonArray.put(userJSONObject);
        }
        jsonObject.put("users", jsonArray);
        this.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, jsonObject);
    }

    public void sendInvites(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        block2: {
            try {
                this.doSendInvite(actionRequest);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException {
        try {
            String resourceID = resourceRequest.getResourceID();
            if (resourceID.equals("getAvailableUsers")) {
                this.getAvailableUsers(resourceRequest, resourceResponse);
            } else {
                super.serveResource(resourceRequest, resourceResponse);
            }
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void updateMemberRequest(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long memberRequestId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"memberRequestId");
        int status = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"status");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        try {
            this._memberRequestLocalService.updateMemberRequest(themeDisplay.getUserId(), memberRequestId, status);
            jsonObject.put("success", (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            jsonObject.put("success", (Object)Boolean.FALSE);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, jsonObject);
    }

    protected void doSendInvite(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay;
        long groupId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"groupId");
        if (!this._userLocalService.hasGroupUser(groupId, (themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")).getUserId())) {
            return;
        }
        long invitedTeamId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"invitedTeamId");
        long[] receiverUserIds = this.getLongArray((PortletRequest)actionRequest, "receiverUserIds");
        long invitedRoleId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"invitedRoleId");
        String[] receiverEmailAddresses = this.getStringArray((PortletRequest)actionRequest, "receiverEmailAddresses");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((PortletRequest)actionRequest);
        Group group = this._groupLocalService.getGroup(groupId);
        PortletURL portletURL = PortletProviderUtil.getPortletURL((PortletRequest)actionRequest, (Group)group, (String)UserNotificationEvent.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        serviceContext.setAttribute("redirectURL", (Serializable)((Object)portletURL.toString()));
        HttpServletRequest request = this._portal.getHttpServletRequest((PortletRequest)actionRequest);
        String createAccountURL = this._portal.getCreateAccountURL(request, themeDisplay);
        serviceContext.setAttribute("createAccountURL", (Serializable)((Object)createAccountURL));
        serviceContext.setAttribute("loginURL", (Serializable)((Object)themeDisplay.getURLSignIn()));
        this._memberRequestLocalService.addMemberRequests(themeDisplay.getUserId(), groupId, receiverUserIds, invitedRoleId, invitedTeamId, serviceContext);
        this._memberRequestLocalService.addMemberRequests(themeDisplay.getUserId(), groupId, receiverEmailAddresses, invitedRoleId, invitedTeamId, serviceContext);
    }

    protected long[] getLongArray(PortletRequest portletRequest, String name) {
        String value = portletRequest.getParameter(name);
        if (value == null) {
            return null;
        }
        return StringUtil.split((String)GetterUtil.getString((String)value), (long)0L);
    }

    protected String[] getStringArray(PortletRequest portletRequest, String name) {
        String value = portletRequest.getParameter(name);
        if (value == null) {
            return null;
        }
        return StringUtil.split((String)GetterUtil.getString((String)value));
    }

    @Reference(target="(&(release.bundle.symbolic.name=com.liferay.invitation.invite.members.service)(release.schema.version=1.0.1))", unbind="-")
    protected void setRelease(Release release) {
    }

    private List<User> _getAvailableUsers(long companyId, long groupId, String keywords, int start, int end) throws Exception {
        LinkedHashMap<String, CustomSQLParam> usersParams = new LinkedHashMap<String, CustomSQLParam>();
        usersParams.put("usersInvited", new CustomSQLParam(this._customSQL.get(((Object)((Object)this)).getClass(), "com.liferay.portal.service.persistence.UserFinder.filterByUsersGroupsGroupId"), (Object)groupId));
        return this._userLocalService.search(companyId, keywords, 0, usersParams, start, end, (OrderByComparator)new UserFirstNameComparator(true));
    }

    private int _getAvailableUsersCount(long companyId, long groupId, String keywords) throws Exception {
        LinkedHashMap<String, CustomSQLParam> usersParams = new LinkedHashMap<String, CustomSQLParam>();
        usersParams.put("usersInvited", new CustomSQLParam(this._customSQL.get(((Object)((Object)this)).getClass(), "com.liferay.portal.service.persistence.UserFinder.filterByUsersGroupsGroupId"), (Object)groupId));
        return this._userLocalService.searchCount(companyId, keywords, 0, usersParams);
    }
}

