/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.invitation.invite.members.web.internal.notifications;

import com.liferay.invitation.invite.members.model.MemberRequest;
import com.liferay.invitation.invite.members.service.MemberRequestLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_invitation_invite_members_web_portlet_InviteMembersPortlet"}, service={UserNotificationHandler.class})
public class InviteMembersUserNotificationHandler
extends BaseUserNotificationHandler {
    private GroupLocalService _groupLocalService;
    private MemberRequestLocalService _memberRequestLocalService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public InviteMembersUserNotificationHandler() {
        this.setActionable(true);
        this.setPortletId("com_liferay_invitation_invite_members_web_portlet_InviteMembersPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)userNotificationEvent.getPayload());
        long memberRequestId = jsonObject.getLong("classPK");
        MemberRequest memberRequest = this._memberRequestLocalService.fetchMemberRequest(memberRequestId);
        if (memberRequest.getStatus() != 0) {
            return "";
        }
        Group group = null;
        if (memberRequest != null) {
            group = this._groupLocalService.fetchGroup(memberRequest.getGroupId());
        }
        if (group == null || memberRequest == null) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)serviceContext.getLocale(), InviteMembersUserNotificationHandler.class);
        String title = ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"x-invited-you-to-join-x", (Object[])new Object[]{this.getUserNameLink(memberRequest.getUserId(), serviceContext), this.getSiteDescriptiveName(memberRequest.getGroupId(), serviceContext)});
        LiferayPortletResponse liferayPortletResponse = serviceContext.getLiferayPortletResponse();
        LiferayPortletURL confirmURL = liferayPortletResponse.createActionURL("com_liferay_invitation_invite_members_web_portlet_InviteMembersPortlet");
        confirmURL.setParameter("javax.portlet.action", "updateMemberRequest");
        confirmURL.setParameter("memberRequestId", String.valueOf(memberRequestId));
        confirmURL.setParameter("status", String.valueOf(1));
        confirmURL.setParameter("userNotificationEventId", String.valueOf(userNotificationEvent.getUserNotificationEventId()));
        confirmURL.setWindowState(WindowState.NORMAL);
        LiferayPortletURL ignoreURL = liferayPortletResponse.createActionURL("com_liferay_invitation_invite_members_web_portlet_InviteMembersPortlet");
        ignoreURL.setParameter("javax.portlet.action", "updateMemberRequest");
        ignoreURL.setParameter("memberRequestId", String.valueOf(memberRequestId));
        ignoreURL.setParameter("status", String.valueOf(2));
        ignoreURL.setParameter("userNotificationEventId", String.valueOf(userNotificationEvent.getUserNotificationEventId()));
        ignoreURL.setWindowState(WindowState.NORMAL);
        return StringUtil.replace((String)this.getBodyTemplate(), (String[])new String[]{"[$CONFIRM$]", "[$CONFIRM_URL$]", "[$IGNORE$]", "[$IGNORE_URL$]", "[$TITLE$]"}, (String[])new String[]{serviceContext.translate("confirm", new Object[0]), confirmURL.toString(), serviceContext.translate("ignore", new Object[0]), ignoreURL.toString(), title});
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return "";
    }

    protected String getSiteDescriptiveName(long groupId, ServiceContext serviceContext) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        StringBundler sb = new StringBundler(6);
        sb.append("<a");
        if (group.hasPublicLayouts()) {
            sb.append(" href=\"");
            String groupFriendlyURL = this._portal.getGroupFriendlyURL(group.getPublicLayoutSet(), serviceContext.getThemeDisplay());
            sb.append(groupFriendlyURL);
            sb.append("\">");
        } else {
            sb.append(">");
        }
        sb.append(HtmlUtil.escape((String)group.getDescriptiveName(serviceContext.getLocale())));
        sb.append("</a>");
        return sb.toString();
    }

    protected String getUserNameLink(long userId, ServiceContext serviceContext) {
        try {
            if (userId <= 0L) {
                return "";
            }
            User user = this._userLocalService.getUserById(userId);
            String userName = user.getFullName();
            String userDisplayURL = user.getDisplayURL(serviceContext.getThemeDisplay());
            return StringBundler.concat((String[])new String[]{"<a href=\"", userDisplayURL, "\">", HtmlUtil.escape((String)userName), "</a>"});
        }
        catch (Exception e) {
            return "";
        }
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setMemberRequestLocalService(MemberRequestLocalService memberRequestLocalService) {
        this._memberRequestLocalService = memberRequestLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    @Reference(unbind="-")
    protected void setUserNotificationEventLocalService(UserNotificationEventLocalService userNotificationEventLocalService) {
        this._userNotificationEventLocalService = userNotificationEventLocalService;
    }
}

