/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.image.uploader.web.internal.portlet.action;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.exception.FileExtensionException;
import com.liferay.document.library.kernel.exception.FileSizeException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.image.uploader.web.internal.util.UploadImageUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadRequestSizeException;
import com.liferay.portal.kernel.upload.UploadServletRequestConfigurationHelper;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_image_uploader_web_portlet_ImageUploaderPortlet", "mvc.command.name=/image_uploader/view"}, service={MVCActionCommand.class})
public class UploadImageMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(UploadImageMVCActionCommand.class);
    private volatile DLConfiguration _dlConfiguration;
    @Reference
    private Portal _portal;
    @Reference
    private UploadServletRequestConfigurationHelper _uploadServletRequestConfigurationHelper;

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
    }

    protected FileEntry addTempImageFileEntry(PortletRequest portletRequest) throws Exception {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest(portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String contentType = uploadPortletRequest.getContentType("fileName");
        String fileName = uploadPortletRequest.getFileName("fileName");
        File file = uploadPortletRequest.getFile("fileName");
        String mimeType = MimeTypesUtil.getContentType((File)file, (String)fileName);
        if (!StringUtil.equalsIgnoreCase((String)"application/octet-stream", (String)mimeType)) {
            contentType = mimeType;
        }
        if (!MimeTypesUtil.isWebImage((String)contentType)) {
            throw new ImageTypeException();
        }
        try {
            TempFileEntryUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)UploadImageUtil.getTempImageFolderName(), (String)fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)UploadImageUtil.getTempImageFolderName(), (String)fileName, (File)file, (String)contentType);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        long maxFileSize = ParamUtil.getLong((PortletRequest)actionRequest, (String)"maxFileSize");
        try {
            UploadException uploadException = (UploadException)actionRequest.getAttribute("UPLOAD_EXCEPTION");
            if (uploadException != null) {
                Throwable cause = uploadException.getCause();
                if (uploadException.isExceededFileSizeLimit()) {
                    throw new FileSizeException(cause);
                }
                if (uploadException.isExceededUploadRequestSizeLimit()) {
                    throw new UploadRequestSizeException(cause);
                }
                throw new PortalException(cause);
            }
            if (cmd.equals("add_temp")) {
                FileEntry tempImageFileEntry = this.addTempImageFileEntry((PortletRequest)actionRequest);
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("tempImageFileName", tempImageFileEntry.getTitle());
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            } else {
                FileEntry fileEntry = null;
                boolean imageUploaded = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"imageUploaded");
                if (imageUploaded && (fileEntry = this.saveTempImageFileEntry(actionRequest)).getSize() > maxFileSize) {
                    throw new FileSizeException();
                }
                SessionMessages.add((PortletRequest)actionRequest, (String)"imageUploaded", (Object)fileEntry);
                this.sendRedirect(actionRequest, actionResponse);
            }
        }
        catch (Exception e) {
            this.handleUploadException(actionRequest, actionResponse, cmd, maxFileSize, e);
        }
    }

    protected String getTempImageFileName(PortletRequest portletRequest) {
        return ParamUtil.getString((PortletRequest)portletRequest, (String)"tempImageFileName");
    }

    protected void handleUploadException(ActionRequest actionRequest, ActionResponse actionResponse, String cmd, long maxFileSize, Exception e) throws Exception {
        if (e instanceof PrincipalException) {
            SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            actionResponse.setRenderParameter("mvcPath", "/error.jsp");
        } else if (e instanceof AntivirusScannerException || e instanceof FileExtensionException || e instanceof FileSizeException || e instanceof ImageTypeException || e instanceof NoSuchFileException || e instanceof UploadException || e instanceof UploadRequestSizeException) {
            if (cmd.equals("add_temp")) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                String errorMessage = "";
                if (e instanceof AntivirusScannerException) {
                    AntivirusScannerException ase = (AntivirusScannerException)e;
                    errorMessage = themeDisplay.translate(ase.getMessageKey());
                } else if (e instanceof FileExtensionException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-extension-x", new Object[]{StringUtil.merge((Object[])this._dlConfiguration.fileExtensions())});
                } else if (e instanceof FileSizeException) {
                    if (maxFileSize == 0L) {
                        maxFileSize = this._uploadServletRequestConfigurationHelper.getMaxSize();
                    }
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-size-no-larger-than-x", new Object[]{TextFormatter.formatStorageSize((double)maxFileSize, (Locale)themeDisplay.getLocale())});
                } else if (e instanceof ImageTypeException) {
                    errorMessage = themeDisplay.translate("please-enter-a-file-with-a-valid-file-type");
                } else if (e instanceof NoSuchFileException || e instanceof UploadException) {
                    errorMessage = themeDisplay.translate("an-unexpected-error-occurred-while-uploading-your-file");
                }
                JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                jsonObject.put("errorMessage", errorMessage);
                JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
            } else {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass(), (Object)e);
            }
        } else {
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FileEntry saveTempImageFileEntry(ActionRequest actionRequest) throws Exception {
        try {
            FileEntry tempFileEntry = UploadImageUtil.getTempImageFileEntry((PortletRequest)actionRequest);
            try (InputStream tempImageStream = tempFileEntry.getContentStream();){
                ImageBag imageBag = ImageToolUtil.read((InputStream)tempImageStream);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                String cropRegionJSON = ParamUtil.getString((PortletRequest)actionRequest, (String)"cropRegion");
                if (Validator.isNotNull((String)cropRegionJSON)) {
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)cropRegionJSON);
                    int height = jsonObject.getInt("height");
                    int width = jsonObject.getInt("width");
                    int x = jsonObject.getInt("x");
                    int y = jsonObject.getInt("y");
                    if (x == 0 && y == 0 && renderedImage.getHeight() == height && renderedImage.getWidth() == width) {
                        FileEntry fileEntry = tempFileEntry;
                        return fileEntry;
                    }
                    if (height + y > renderedImage.getHeight()) {
                        height = renderedImage.getHeight() - y;
                    }
                    if (width + x > renderedImage.getWidth()) {
                        width = renderedImage.getWidth() - x;
                    }
                    renderedImage = ImageToolUtil.crop((RenderedImage)renderedImage, (int)height, (int)width, (int)x, (int)y);
                }
                byte[] bytes = ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)imageBag.getType());
                ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                File file = FileUtil.createTempFile((byte[])bytes);
                try {
                    TempFileEntryUtil.deleteTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)UploadImageUtil.getTempImageFolderName(), (String)this.getTempImageFileName((PortletRequest)actionRequest));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileEntry fileEntry = TempFileEntryUtil.addTempFileEntry((long)themeDisplay.getScopeGroupId(), (long)themeDisplay.getUserId(), (String)UploadImageUtil.getTempImageFolderName(), (String)this.getTempImageFileName((PortletRequest)actionRequest), (File)file, (String)tempFileEntry.getMimeType());
                return fileEntry;
            }
        }
        catch (NoSuchFileEntryException nsfee) {
            throw new UploadException((Throwable)nsfee);
        }
        catch (NoSuchRepositoryException nsre) {
            throw new UploadException((Throwable)nsre);
        }
    }
}

