/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.html.preview.processor.image.impl;

import com.liferay.html.preview.processor.HtmlPreviewProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.File;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.osgi.service.component.annotations.Component;
import org.xhtmlrenderer.swing.Java2DRenderer;
import org.xhtmlrenderer.util.FSImageWriter;

@Component(immediate=true, service={HtmlPreviewProcessor.class})
public class ImageHtmlPreviewProcessor
implements HtmlPreviewProcessor {
    private static final Log _log = LogFactoryUtil.getLog(ImageHtmlPreviewProcessor.class);

    public File generateContentHtmlPreview(String content) {
        return this.generateContentHtmlPreview(content, 1024);
    }

    public File generateContentHtmlPreview(String content, int width) {
        try {
            File tempFile = FileUtil.createTempFile();
            Document document = Jsoup.parse((String)content);
            Document.OutputSettings outputSettings = document.outputSettings();
            outputSettings.syntax(Document.OutputSettings.Syntax.xml);
            outputSettings.escapeMode(Entities.EscapeMode.xhtml);
            FileUtil.write((File)tempFile, (String)document.html());
            return this._getFile(new Java2DRenderer(tempFile, width));
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to generate HTML preview", (Throwable)e);
            }
            return null;
        }
    }

    public File generateURLHtmlPreview(String url) {
        return this.generateURLHtmlPreview(url, 1024);
    }

    public File generateURLHtmlPreview(String url, int width) {
        try {
            return this._getFile(new Java2DRenderer(url, width));
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.error((Object)"Unable to generate HTML preview", (Throwable)e);
            }
            return null;
        }
    }

    public String getMimeType() {
        return "image/png";
    }

    private File _getFile(Java2DRenderer renderer) throws Exception {
        renderer.setBufferedImageType(1);
        File outputFile = FileUtil.createTempFile((String)"png");
        FSImageWriter imageWriter = new FSImageWriter();
        imageWriter.write(renderer.getImage(), outputFile.getAbsolutePath());
        return outputFile;
    }
}

