/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.user.notification.internal.resource.v1_0;

import com.liferay.headless.user.notification.dto.v1_0.UserNotification;
import com.liferay.headless.user.notification.internal.odata.entity.v1_0.UserNotificationEntityModel;
import com.liferay.headless.user.notification.internal.resource.v1_0.BaseUserNotificationResourceImpl;
import com.liferay.headless.user.notification.resource.v1_0.UserNotificationResource;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.UserNotificationEventService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user-notification.properties"}, scope=ServiceScope.PROTOTYPE, service={UserNotificationResource.class})
public class UserNotificationResourceImpl
extends BaseUserNotificationResourceImpl {
    private static final EntityModel _entityModel = new UserNotificationEntityModel();
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private ModelResourcePermission<User> _userModelResourcePermission;
    @Reference(target="(component.name=com.liferay.headless.user.notification.internal.dto.v1_0.converter.UserNotificationDTOConverter)")
    private DTOConverter<UserNotificationEvent, UserNotification> _userNotificationDTOConverter;
    @Reference
    private UserNotificationEventService _userNotificationEventService;

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public Page<UserNotification> getMyUserNotificationsPage(String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getPage(filter, pagination, search, sorts, this.contextUser.getUserId());
    }

    @Override
    public Page<UserNotification> getUserAccountUserNotificationsPage(Long userAccountId, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        return this._getPage(filter, pagination, search, sorts, userAccountId);
    }

    @Override
    public UserNotification getUserNotification(Long userNotificationId) throws Exception {
        return this._toUserNotification(this._userNotificationEventService.getUserNotificationEvent(userNotificationId.longValue()));
    }

    @Override
    public void putUserNotificationRead(Long userNotificationId) throws Exception {
        UserNotificationEvent userNotificationEvent = this._userNotificationEventService.getUserNotificationEvent(userNotificationId.longValue());
        this._userNotificationEventService.updateUserNotificationEvent(userNotificationEvent.getUuid(), userNotificationEvent.getCompanyId(), true);
    }

    @Override
    public void putUserNotificationUnread(Long userNotificationId) throws Exception {
        UserNotificationEvent userNotificationEvent = this._userNotificationEventService.getUserNotificationEvent(userNotificationId.longValue());
        this._userNotificationEventService.updateUserNotificationEvent(userNotificationEvent.getUuid(), userNotificationEvent.getCompanyId(), false);
    }

    private Page<UserNotification> _getPage(Filter filter, Pagination pagination, String search, Sort[] sorts, long userId) throws Exception {
        return SearchUtil.search(null, booleanQuery -> {}, (Filter)filter, (String)UserNotificationEvent.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("userId", (Serializable)Long.valueOf(userId));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
        }, (Sort[])sorts, document -> this._toUserNotification(this._userNotificationEventService.getUserNotificationEvent(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    private UserNotification _toUserNotification(UserNotificationEvent userNotificationEvent) throws Exception {
        return (UserNotification)this._userNotificationDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", this.getClass(), (Long)userNotificationEvent.getUserId(), (String)"getUserNotification", this._userModelResourcePermission, (Long)userNotificationEvent.getUserNotificationEventId(), (UriInfo)this.contextUriInfo)).put((Object)"mark-read", (Object)ActionUtil.addAction((String)"UPDATE", this.getClass(), (Long)userNotificationEvent.getUserId(), (String)"putUserNotificationRead", this._userModelResourcePermission, (Long)userNotificationEvent.getUserNotificationEventId(), (UriInfo)this.contextUriInfo)).put((Object)"mark-unread", (Object)ActionUtil.addAction((String)"UPDATE", this.getClass(), (Long)userNotificationEvent.getUserId(), (String)"putUserNotificationUnread", this._userModelResourcePermission, (Long)userNotificationEvent.getUserNotificationEventId(), (UriInfo)this.contextUriInfo)).build(), null, this.contextHttpServletRequest, (Object)userNotificationEvent.getUserNotificationEventId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)userNotificationEvent);
    }
}

