/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.user.notification.internal.dto.v1_0.converter;

import com.liferay.headless.user.notification.dto.v1_0.UserNotification;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.UserNotificationFeedEntry;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.UserNotificationEvent"}, service={DTOConverter.class})
public class UserNotificationDTOConverter
implements DTOConverter<UserNotificationEvent, UserNotification> {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    private ServiceTrackerMap<String, UserNotificationHandler> _serviceTrackerMap;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public String getContentType() {
        return UserNotification.class.getSimpleName();
    }

    public UserNotificationEvent getObject(String externalReferenceCode) throws Exception {
        return this._userNotificationEventLocalService.getUserNotificationEvent(GetterUtil.getLong((String)externalReferenceCode));
    }

    public UserNotification toDTO(final DTOConverterContext dtoConverterContext, final UserNotificationEvent userNotificationEvent) throws Exception {
        return new UserNotification(){
            {
                this.setActions(() -> {
                    if (dtoConverterContext == null) {
                        return null;
                    }
                    return dtoConverterContext.getActions();
                });
                this.setDateCreated(() -> new Date(userNotificationEvent.getTimestamp()));
                this.setId(() -> ((UserNotificationEvent)userNotificationEvent).getUserNotificationEventId());
                this.setMessage(() -> UserNotificationDTOConverter.this._getNotificationMessage(dtoConverterContext, userNotificationEvent));
                this.setRead(() -> ((UserNotificationEvent)userNotificationEvent).isArchived());
                this.setType(() -> {
                    JSONObject jsonObject = UserNotificationDTOConverter.this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
                    if (!jsonObject.has("notificationType")) {
                        return null;
                    }
                    return jsonObject.getInt("notificationType");
                });
            }
        };
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, UserNotificationHandler.class, (String)"javax.portlet.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private String _getNotificationMessage(DTOConverterContext dtoConverterContext, UserNotificationEvent userNotificationEvent) throws Exception {
        UserNotificationHandler userNotificationHandler = (UserNotificationHandler)this._serviceTrackerMap.getService((Object)userNotificationEvent.getType());
        if (userNotificationHandler == null) {
            return null;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)dtoConverterContext.getHttpServletRequest());
        serviceContext.setLanguageId(this._language.getLanguageId(dtoConverterContext.getLocale()));
        UserNotificationFeedEntry userNotificationFeedEntry = userNotificationHandler.interpret(userNotificationEvent, serviceContext);
        if (userNotificationFeedEntry == null) {
            return null;
        }
        return userNotificationFeedEntry.getTitle();
    }
}

